/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.comment;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.exports.common.StringPool;
import oracle.javatools.exports.file.Paths;
import oracle.javatools.exports.message.Log;
import oracle.javatools.util.NullArgumentException;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class RemediationCommentsReader
extends DefaultHandler {
    private StringPool commentPool;
    private boolean schemaValidating;
    private boolean quiet;
    private SAXParser parser;
    private Map<String, String> comments;
    private Log log;
    private Locator locator;
    private Object fileName;
    private int line;
    private int column;
    private String name;
    private String comment;
    private StringBuilder commentBuilder;

    public RemediationCommentsReader() {
        this(StringPool.nullPool(), false, false);
    }

    public RemediationCommentsReader(StringPool commentPool, boolean schemaValidating, boolean quiet) {
        this.commentPool = commentPool;
        this.schemaValidating = schemaValidating;
        this.quiet = quiet;
    }

    public StringPool getCommentPool() {
        return this.commentPool;
    }

    public void setCommentPool(StringPool commentPool) {
        if (commentPool == null) {
            throw new NullArgumentException("commentPool null");
        }
        this.commentPool = commentPool;
    }

    public boolean isSchemaValidating() {
        return this.schemaValidating;
    }

    public void setSchemaValidating(boolean schemaValidating) {
        if (schemaValidating != this.schemaValidating) {
            this.schemaValidating = schemaValidating;
            this.parser = null;
        }
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public Map<String, String> read(URL url, Log log) throws ParserConfigurationException, SAXException, IOException {
        try (InputStream stream = URLFileSystem.openInputStream(url);){
            Map<String, String> map = this.read(url, stream, log);
            return map;
        }
    }

    public Map<String, String> read(Path path, Log log) throws ParserConfigurationException, SAXException, IOException {
        try (InputStream commentsStream = Files.newInputStream(path, new OpenOption[0]);){
            Map<String, String> map = this.read(path, commentsStream, log);
            return map;
        }
    }

    public Map<String, String> read(Object name, InputStream stream, Log log) throws ParserConfigurationException, SAXException, IOException {
        this.fileName = name;
        if (stream == null) {
            throw new IOException("null input stream for " + this.fileName());
        }
        if (this.parser == null) {
            if (this.schemaValidating) {
                InputStream schemaInputStream = RemediationCommentsReader.class.getResourceAsStream("lib-comments.xsd");
                StreamSource schemaSource = new StreamSource(schemaInputStream);
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = schemaFactory.newSchema(schemaSource);
                SAXParserFactory factory = SAXParserFactory.newInstance("com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl", ClassLoader.getSystemClassLoader());
                factory.setNamespaceAware(true);
                factory.setValidating(false);
                factory.setSchema(schema);
                this.parser = factory.newSAXParser();
            } else {
                this.parser = SAXParserFactory.newInstance().newSAXParser();
            }
        }
        this.comments = new LinkedHashMap<String, String>();
        this.log = log;
        this.column = 0;
        this.line = 0;
        this.parser.parse(stream, (DefaultHandler)this);
        Map<String, String> result = this.comments.isEmpty() ? Collections.emptyMap() : this.comments;
        this.comments = null;
        return result;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        if (this.locator != null) {
            this.line = this.locator.getLineNumber();
            this.column = this.locator.getColumnNumber();
        }
        switch (qualifiedName) {
            case "lib-comments": {
                assert (this.comments != null);
                break;
            }
            case "comment": {
                this.name = attributes.getValue("name");
                if (this.name == null) {
                    throw new SAXException("name attribute required ( " + this.fileName() + ":" + this.line + ')');
                }
                this.comment = attributes.getValue("comment");
                if (this.comment != null) {
                    this.comment = this.commentPool.pool(this.comment.trim());
                    this.commentBuilder = null;
                    break;
                }
                this.commentBuilder = new StringBuilder();
                break;
            }
            default: {
                if (this.commentBuilder == null) break;
                this.commentBuilder.append('<').append(qualifiedName);
                int count = attributes.getLength();
                for (int i = 0; i < count; ++i) {
                    this.commentBuilder.append(' ');
                    this.commentBuilder.append(attributes.getQName(i));
                    this.commentBuilder.append('=');
                    String value = attributes.getValue(i);
                    char quote = value.indexOf(34) < 0 ? (char)'\"' : '\'';
                    this.commentBuilder.append(quote);
                    this.commentBuilder.append(value);
                    this.commentBuilder.append(quote);
                }
                this.commentBuilder.append('>');
            }
        }
    }

    @Override
    public void characters(char[] characters, int start, int length) throws SAXException {
        if (this.commentBuilder != null) {
            this.commentBuilder.append(characters, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] characters, int start, int length) throws SAXException {
        if (this.commentBuilder != null) {
            this.commentBuilder.append(characters, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qualifiedName) throws SAXException {
        switch (qualifiedName) {
            case "lib-comments": {
                assert (this.comments != null);
                break;
            }
            case "comment": {
                String predecessor;
                if (this.comment == null) {
                    this.comment = this.commentPool.pool(this.commentBuilder.toString().trim());
                }
                if ((predecessor = this.comments.putIfAbsent(this.name, this.comment)) != null && this.log != null) {
                    this.log.warning("comments-duplicate-comment,", "duplicate comment for %s (%s:%d)", this.name, this.fileName, this.line).scope(this.fileName);
                }
                this.comment = null;
                this.commentBuilder = null;
                break;
            }
            default: {
                if (this.commentBuilder == null) break;
                this.commentBuilder.append("</").append(qualifiedName).append('>');
            }
        }
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.log.warning("comments-schema-validation-warning", "%s (%s:%d)", e.getMessage(), this.fileName, e.getLineNumber()).scope(this.fileName);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.log.error("comments-schema-validation-error", "%s (%s:%d)", e.getMessage(), this.fileName, e.getLineNumber()).scope(this.fileName);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    String at() {
        return " ( " + this.fileName() + ", line " + this.line + ", column " + this.column + ')';
    }

    private String fileName() {
        if (this.fileName instanceof URL) {
            return URLFileSystem.getPlatformPathName((URL)this.fileName);
        }
        if (this.fileName instanceof Path) {
            return Paths.toString((Path)this.fileName);
        }
        return String.valueOf(this.fileName);
    }
}

