/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.command;

import java.nio.file.Path;

public class ClassesSource {
    private final Path path;
    private final String id;
    private final SourceType type;
    private SourceType resolvedType;

    public static ClassesSource installation() {
        return new ClassesSource();
    }

    public static ClassesSource library(Path library) {
        return new ClassesSource(library, null, SourceType.LIBRARY);
    }

    public static ClassesSource library(String nameOrId) {
        return new ClassesSource(null, nameOrId, SourceType.LIBRARY);
    }

    public static ClassesSource extension(Path extension) {
        return new ClassesSource(extension, null, SourceType.EXTENSION);
    }

    public static ClassesSource extension(String extensionId) {
        return new ClassesSource(null, extensionId, SourceType.EXTENSION);
    }

    public static ClassesSource path(Path path) {
        return new ClassesSource(path, SourceType.PATH);
    }

    public ClassesSource(Path path, String id, SourceType type) {
        if (path != null && id != null) {
            throw new IllegalArgumentException("Only one of path and id can be non-null");
        }
        this.path = path;
        this.id = id;
        this.type = type;
        this.resolvedType = type;
    }

    private ClassesSource() {
        this(null, null, SourceType.INSTALLATION);
    }

    public ClassesSource(Path path, SourceType type) {
        this(path, null, type);
    }

    public void resolve(SourceType type) {
        this.resolvedType = type;
    }

    public Path getPath() {
        return this.path;
    }

    public String getId() {
        return this.id;
    }

    public SourceType getType() {
        return this.type;
    }

    public boolean isInstallation() {
        return this.path == null && this.id == null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ClassesSource)) {
            return false;
        }
        ClassesSource that = (ClassesSource)object;
        return this.type == that.type && this.path.equals(that.path) && this.id != null ? this.id.equals(that.id) : this.id == that.id;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        switch (this.resolvedType) {
            case INSTALLATION: {
                builder.append("installation");
                break;
            }
            case LIBRARY: {
                builder.append("library");
                break;
            }
            case EXTENSION: {
                builder.append("libraries of extension");
                break;
            }
            case UNKNOWN: {
                builder.append("library or extension");
            }
        }
        if (this.id != null) {
            builder.append(" \"").append(this.id).append('\"');
        } else if (this.path != null) {
            builder.append(' ').append(this.path);
        }
        return builder.toString();
    }

    public static enum SourceType {
        INSTALLATION,
        LIBRARY,
        EXTENSION,
        PATH,
        UNKNOWN;

    }
}

