/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.classpath;

import java.util.Arrays;
import oracle.javatools.exports.CompatibilityAccess;
import oracle.javatools.exports.classpath.Member;
import oracle.javatools.exports.classpath.Type;
import oracle.javatools.exports.name.MemberName;
import oracle.javatools.exports.name.MethodName;
import oracle.javatools.exports.name.TypeName;
import oracle.javatools.util.NullArgumentException;

public class Method
extends Member<Method> {
    private final MethodName name;
    private Type[] parameterTypes;
    private final TypeName returnTypeName;
    private Type returnType;

    Method(Type parent, MethodName name, TypeName returnTypeName, boolean isStatic, boolean isFinal, boolean isAbstract, Member.Escalation escalation, boolean deprecated, CompatibilityAccess access, boolean escalated, boolean suppressed, String accessComment) {
        super(parent, escalation, deprecated, access, escalated, suppressed, accessComment);
        if (returnTypeName == null) {
            throw new NullArgumentException("returnTypeName null");
        }
        this.name = name;
        this.set('\u0004', isAbstract);
        if (name.getParameters().length == 0) {
            this.parameterTypes = EMPTY_TYPES;
        }
        this.returnTypeName = returnTypeName;
        this.set('\b', isStatic);
        this.set('\u0002', isFinal);
    }

    Method(Type parent, MethodName name, char flags, TypeName returnTypeName) {
        super(parent, flags);
        if (returnTypeName == null) {
            throw new NullArgumentException("returnTypeName null");
        }
        this.name = name;
        if (name.getParameters().length == 0) {
            this.parameterTypes = EMPTY_TYPES;
        }
        this.returnTypeName = returnTypeName;
    }

    @Override
    public MethodName getName() {
        return this.name;
    }

    @Override
    void resolve() {
        this.getResolvedName();
        this.getReturnType();
    }

    @Override
    public TypeName getMemberTypeName() {
        return this.returnTypeName;
    }

    @Override
    public Type getMemberType() {
        return this.getReturnType();
    }

    @Override
    public int getArity() {
        return this.name.getArity();
    }

    @Override
    public boolean isVariableArity() {
        return this.name.isVariableArity();
    }

    @Override
    public MemberName getResolvedName() {
        if (this.parameterTypes == null) {
            this.parameterTypes = this.getModel().findTypes(this.name.getParameters(), "parameter type", this.getName());
        }
        return this.name;
    }

    @Override
    public Iterable<Type> getParameterTypes() {
        if (this.parameterTypes == null) {
            this.parameterTypes = this.getModel().findTypes(this.name.getParameters(), "parameter type", this.getName());
        }
        return Arrays.asList(this.parameterTypes);
    }

    public boolean isAbstract() {
        return this.is('\u0004');
    }

    @Override
    public boolean isDefault() {
        return !this.isAbstract() && this.getType().isInterface();
    }

    public TypeName getReturnTypeName() {
        return this.returnTypeName;
    }

    public Type getReturnType() {
        if (!TypeName.VOID.equals(this.returnTypeName) && this.returnType == null) {
            this.returnType = this.getModel().findType(this.returnTypeName, "return type", this.getName());
        }
        return this.returnType;
    }
}

