/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.classpath;

import java.util.Arrays;
import oracle.javatools.exports.CompatibilityAccess;
import oracle.javatools.exports.classpath.Member;
import oracle.javatools.exports.classpath.Type;
import oracle.javatools.exports.name.ConstructorName;
import oracle.javatools.exports.name.MemberName;
import oracle.javatools.exports.name.TypeName;

public class Constructor
extends Member<Constructor> {
    private final ConstructorName name;
    private Type[] parameterTypes;

    Constructor(Type parent, ConstructorName name, Member.Escalation escalation, boolean deprecated, CompatibilityAccess access, boolean escalated, boolean suppressed, String accessComment) {
        super(parent, escalation, deprecated, access, escalated, suppressed, accessComment);
        this.name = name;
        if (name.getParameters().length == 0) {
            this.parameterTypes = EMPTY_TYPES;
        }
    }

    Constructor(Type parent, ConstructorName name, char flags) {
        super(parent, flags);
        this.name = name;
        if (name.getParameters().length == 0) {
            this.parameterTypes = EMPTY_TYPES;
        }
    }

    @Override
    public ConstructorName getName() {
        return this.name;
    }

    @Override
    void resolve() {
        this.getResolvedName();
    }

    @Override
    public TypeName getMemberTypeName() {
        return this.getParent().getName();
    }

    @Override
    public Type getMemberType() {
        return this.getParent();
    }

    @Override
    public int getArity() {
        return this.name.getArity();
    }

    @Override
    public boolean isVariableArity() {
        return this.name.isVariableArity();
    }

    @Override
    public MemberName getResolvedName() {
        if (this.parameterTypes == null) {
            this.parameterTypes = this.getModel().findTypes(this.name.getParameters(), "parameter type", this.getName());
        }
        return this.name;
    }

    @Override
    public Iterable<Type> getParameterTypes() {
        if (this.parameterTypes == null) {
            this.parameterTypes = this.getModel().findTypes(this.name.getParameters(), "parameter type", this.getName());
        }
        return Arrays.asList(this.parameterTypes);
    }
}

