/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.classpath;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.javatools.exports.CompatibilityAccess;
import oracle.javatools.exports.classpath.BaselineReaderWriter;
import oracle.javatools.exports.classpath.ClassPathModel;
import oracle.javatools.exports.classpath.Conversions;
import oracle.javatools.exports.classpath.Field;
import oracle.javatools.exports.classpath.Member;
import oracle.javatools.exports.classpath.Method;
import oracle.javatools.exports.classpath.OverrideEquivalentMethod;
import oracle.javatools.exports.classpath.Package;
import oracle.javatools.exports.classpath.Type;
import oracle.javatools.exports.classpath.TypeKind;
import oracle.javatools.exports.common.ComparisonIterators;
import oracle.javatools.exports.file.Paths;
import oracle.javatools.exports.message.Log;
import oracle.javatools.exports.message.Message;
import oracle.javatools.exports.message.Severity;
import oracle.javatools.exports.name.ConstructorName;
import oracle.javatools.exports.name.ElementKind;
import oracle.javatools.exports.name.ElementName;
import oracle.javatools.exports.name.MethodName;
import oracle.javatools.exports.name.TypeName;
import oracle.javatools.exports.specification.ExportDomain;
import oracle.javatools.exports.uses.LibraryUses;
import oracle.javatools.exports.uses.TypeOrMemberUses;
import oracle.javatools.exports.uses.TypeUses;
import oracle.javatools.exports.uses.UsesModel;
import oracle.javatools.util.MultiMap;

public class BaselineComparison {
    private final UsesModel uses;
    private final Log log;
    private final List<Message> errors = new ArrayList<Message>();
    private int errorsWithUsesCount;
    private final List<Message> warnings = new ArrayList<Message>();
    private final List<Message> notes = new ArrayList<Message>();
    private final MultiMap<String, String> approvals = new MultiMap(LinkedHashSet.class);
    private final List<Message> matchedApprovals = new ArrayList<Message>();
    private final MultiMap<String, String> unmatchedApprovals = new MultiMap(LinkedHashSet.class);
    private static final Map<String, Change> ID_TO_CHANGE = new LinkedHashMap<String, Change>();
    private final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+");
    private final Matcher USES_MATCHER = Pattern.compile(": [0-9]+ (?:reference|extension)s?[, ]").matcher("");
    private static final TypeKind[] TYPE_KINDS = new TypeKind[]{TypeKind.CLASS, TypeKind.INTERFACE};
    private static final ElementKind[] MEMBER_KINDS = new ElementKind[]{ElementKind.CONSTRUCTOR, ElementKind.METHOD, ElementKind.FIELD};
    private static final Enum<?>[] ELEMENT_KINDS = new Enum[]{TypeKind.CLASS, TypeKind.INTERFACE, ElementKind.CONSTRUCTOR, ElementKind.METHOD, ElementKind.FIELD};
    private static final ElementKind[] FIELD_KINDS = new ElementKind[]{ElementKind.FIELD};
    private static final ElementKind[] METHOD_KINDS = new ElementKind[]{ElementKind.METHOD};

    public BaselineComparison(UsesModel uses, Log log) {
        this.uses = uses;
        this.log = log;
    }

    public void readApprovals(Path path) throws IOException {
        int count = 0;
        for (String line : Files.readAllLines(path)) {
            ++count;
            if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
            int colon = line.indexOf(58);
            if (colon < 0) {
                this.error(Change.APPROVAL_INVALID, "invalid approval, expected \"<id>: <message>\" at %s:%d", path, count);
                continue;
            }
            String id = line.substring(0, colon).trim();
            Change change = Change.getChange(id);
            if (change == null) {
                this.error(Change.APPROVAL_INVALID, "invalid approval, id \"%s\" not valid at %s:%d", id, path, count);
                continue;
            }
            if (change == Change.CHANGE_RETRACTED) {
                this.error(Change.APPROVAL_INVALID, "invalid approval, approval not applicable to retracted approval at %s:%d", path, count);
                continue;
            }
            if (change == Change.APPROVAL_INVALID) {
                this.error(Change.APPROVAL_INVALID, "invalid approval, approval not applicable to invalid approval at %s:%d", path, count);
                continue;
            }
            int end = line.length();
            int used = id.indexOf("-used-");
            if (used > 0) {
                id = id.substring(0, used) + id.substring(used + 5);
                this.USES_MATCHER.reset(line);
                if (this.USES_MATCHER.find(colon + 1)) {
                    end = this.USES_MATCHER.start();
                }
            }
            String message = line.substring(colon + 1, end).trim();
            this.approvals.add(id, message);
            this.unmatchedApprovals.add(id, message);
        }
    }

    public int getErrorsCount() {
        return this.errors.size();
    }

    public int getErrorsWithUsesCount() {
        return this.errorsWithUsesCount;
    }

    public int getWarningsCount() {
        return this.warnings.size();
    }

    public int getNotesCount() {
        return this.notes.size();
    }

    public int getApprovalsCount() {
        return this.approvals.valuesSize();
    }

    public int getMatchedApprovalsCount() {
        return this.matchedApprovals.size();
    }

    public int getUnmatchedApprovalsCount() {
        return this.unmatchedApprovals.valuesSize();
    }

    public Iterable<String> getErrors() {
        return () -> new ChangeIterator(this.errors);
    }

    public Iterable<String> getErrorsWithUses() {
        return () -> new ChangeIterator(this.errors, m -> m.getId().contains("used"));
    }

    public Iterable<String> getWarnings() {
        return () -> new ChangeIterator(this.warnings);
    }

    public Iterable<String> getNotes() {
        return () -> new ChangeIterator(this.notes);
    }

    public Iterable<String> getMatchedApprovals() {
        return () -> new ChangeIterator(this.matchedApprovals);
    }

    public Iterable<String> getUnmatchedApprovals() {
        ArrayList<String> messages = new ArrayList<String>();
        Iterator<Map.Entry<String, String>> i = this.unmatchedApprovals.keyValueIterator();
        while (i.hasNext()) {
            Map.Entry<String, String> entry = i.next();
            messages.add(BaselineComparison.format(entry.getKey(), entry.getValue()));
        }
        Collections.sort(messages);
        return messages;
    }

    /*
     * Unable to fully structure code
     */
    public void compare(ClassPathModel referenceModel, ClassPathModel revisedModel) {
        removedSubdomains = new ExportDomain(new String[0]);
        domains = ComparisonIterators.iterator(referenceModel.getDomain().getSubdomains(), revisedModel.getDomain().getSubdomains(), (Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$compare$6(oracle.javatools.exports.specification.ExportDomain$Subdomain oracle.javatools.exports.specification.ExportDomain$Subdomain ), (Loracle/javatools/exports/specification/ExportDomain$Subdomain;Loracle/javatools/exports/specification/ExportDomain$Subdomain;)I)());
        block49: while (domains.hasNext()) {
            switch (2.$SwitchMap$oracle$javatools$exports$common$ComparisonIterators$Comparison[domains.next().ordinal()]) {
                case 1: {
                    removedSubdomain = domains.left();
                    removedSubdomains.addSubdomain(removedSubdomain);
                    removedName = removedSubdomain.getName();
                    this.warning(Change.DOMAIN_REMOVED, "subdomain %s removed", new Object[]{removedName}).element(removedName);
                    continue block49;
                }
                case 2: {
                    exceptions = ComparisonIterators.iterator(domains.left().getExceptions(), domains.right().getExceptions());
                    block50: while (exceptions.hasNext()) {
                        switch (2.$SwitchMap$oracle$javatools$exports$common$ComparisonIterators$Comparison[exceptions.next().ordinal()]) {
                            case 1: {
                                removedException = (String)exceptions.left();
                                this.note(Change.DOMAIN_EXCEPT_REMOVED, "subdomain %s exception %s removed", new Object[]{domains.left().getName(), removedException}).element(removedException);
                                continue block50;
                            }
                            case 2: {
                                continue block50;
                            }
                            case 3: {
                                addedException = (String)exceptions.right();
                                this.note(Change.DOMAIN_EXCEPT_ADDED, "subdomain %s exception %s added", new Object[]{addedException, domains.left().getName(), addedException}).element(addedException);
                                continue block50;
                            }
                        }
                        throw new IllegalStateException();
                    }
                    continue block49;
                }
                case 3: {
                    addedName = domains.right().getName();
                    this.note(Change.DOMAIN_ADDED, "subdomain %s added", new Object[]{addedName}).element(addedName);
                    continue block49;
                }
            }
            throw new IllegalStateException();
        }
        referenceByName = new TreeMap<Object, ClassPathModel.LibraryDescription>();
        referenceByPath = new HashMap<String, ClassPathModel.LibraryDescription>();
        for (ClassPathModel.LibraryDescription library : referenceModel.getLibraries()) {
            referenceByName.put(library.getName(), library);
            for (String name : library.getAliases()) {
                referenceByName.put(name, library);
            }
            if (!library.getPath().endsWith(".library")) continue;
            referenceByPath.put(library.getPath(), library);
        }
        revisedByName = new TreeMap<String, ClassPathModel.LibraryDescription>();
        revisedByPath = new HashMap<String, ClassPathModel.LibraryDescription>();
        for (ClassPathModel.LibraryDescription library : revisedModel.getLibraries()) {
            revisedByName.put(library.getName(), library);
            for (String name : library.getAliases()) {
                revisedByName.put(name, library);
            }
            if (!library.getPath().endsWith(".library")) continue;
            revisedByPath.put(library.getPath(), library);
        }
        libraries = ComparisonIterators.mapIterator(referenceByName, revisedByName);
        block55: while (libraries.hasNext()) {
            switch (2.$SwitchMap$oracle$javatools$exports$common$ComparisonIterators$Comparison[libraries.next().ordinal()]) {
                case 1: {
                    removed = (ClassPathModel.LibraryDescription)libraries.left().getValue();
                    if (!revisedByPath.containsKey(removed.getPath())) {
                        this.error(Change.LIBRARY_REMOVED, "library \"%s\" at %s removed", new Object[]{removed.getName(), removed.getPath(), this.uses.getLibraryUses(removed.getName())}).element(removed.getPath());
                        continue block55;
                    }
                    this.error(Change.LIBRARY_RENAMED, "library \"%s\" at %s renamed to \"%s\"", new Object[]{removed.getName(), removed.getPath(), ((ClassPathModel.LibraryDescription)revisedByPath.get(removed.getPath())).getName(), this.uses.getLibraryUses(removed.getName())}).element(removed.getPath());
                    continue block55;
                }
                case 2: {
                    reference = (ClassPathModel.LibraryDescription)libraries.left().getValue();
                    revised = (ClassPathModel.LibraryDescription)libraries.right().getValue();
                    if (reference.getPath().equals(revised.getPath())) continue block55;
                    this.warning(Change.LIBRARY_MOVED, "library \"%s\" moved from %s to %s", new Object[]{reference.getName(), reference.getPath(), revised.getPath(), this.uses.getLibraryUses(reference.getName())}).element(reference.getPath());
                    continue block55;
                }
                case 3: {
                    addedName = (String)libraries.right().getKey();
                    addedLibrary = (ClassPathModel.LibraryDescription)libraries.right().getValue();
                    if (addedName.equals(addedLibrary.getName())) {
                        this.note(Change.LIBRARY_ADDED, "library \"%s\" added at %s", new Object[]{addedName, addedLibrary.getPath(), this.uses.getLibraryUses(addedName)}).element(addedLibrary.getPath());
                        continue block55;
                    }
                    this.note(Change.LIBRARY_ALIAS_ADDED, "library alias \"%s\" (to library \"%s\") added at %s", new Object[]{addedName, addedLibrary.getName(), addedLibrary.getPath(), this.uses.getLibraryUses(addedLibrary.getName())}).element(addedLibrary.getPath());
                    continue block55;
                }
            }
            throw new IllegalStateException();
        }
        referenceByName = null;
        referenceByPath = null;
        revisedByName = null;
        revisedByPath = null;
        packages = ComparisonIterators.iterator(referenceModel.getControlledPackages(), revisedModel.getControlledPackages(), (Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$compare$7(oracle.javatools.exports.classpath.Package oracle.javatools.exports.classpath.Package ), (Loracle/javatools/exports/classpath/Package;Loracle/javatools/exports/classpath/Package;)I)());
        while (packages.hasNext()) {
            packageComparison = packages.next();
            referencePackage = packages.left();
            revisedPackage = packages.right();
            switch (2.$SwitchMap$oracle$javatools$exports$common$ComparisonIterators$Comparison[packageComparison.ordinal()]) {
                case 1: {
                    packageName = referencePackage.getName();
                    break;
                }
                case 2: {
                    packageName = referencePackage.getName();
                    break;
                }
                case 3: {
                    packageName = revisedPackage.getName();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            types = ComparisonIterators.iterator(referencePackage, revisedPackage, (Function<Package, Iterable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$compare$8(oracle.javatools.exports.classpath.Package ), (Loracle/javatools/exports/classpath/Package;)Ljava/lang/Iterable;)(), Type.UNQUALIFIED_COMPARATOR);
            block57: while (types.hasNext()) {
                typeComparison = types.next();
                referenceType = types.left();
                revisedType = types.right();
                switch (2.$SwitchMap$oracle$javatools$exports$common$ComparisonIterators$Comparison[typeComparison.ordinal()]) {
                    case 1: {
                        typeKind = referenceType.getTypeKind();
                        typeName = referenceType.getName();
                        typeAccess = referenceType.getReferenceAccess();
                        typeUses = this.uses.getTypeUses(referenceType.getName());
                        if (revisedModel.getDomain().dominates(packageName)) {
                            condition = CompatibilityAccess.isExportedOrRestricted(typeAccess) != false || typeUses != null;
                            this.errorOrNote(condition, Change.ELEMENT_REMOVED, "%s %s %s removed", new Object[]{typeAccess, typeKind, typeName, typeUses}).element(typeName);
                            continue block57;
                        }
                        if (revisedModel.findType(referenceType.getName(), "comparison", referenceType.getName()) != null) {
                            this.note(Change.ELEMENT_EXCLUDED, "%s %s %s excluded by domain", new Object[]{typeAccess, typeKind, typeName, typeUses}).element(typeName);
                            continue block57;
                        }
                        if (revisedModel.isRooted()) {
                            this.errorOrNote(typeUses != null, Change.ELEMENT_REMOVED, "%s %s %s removed", new Object[]{typeAccess, typeKind, typeName, typeUses}).element(typeName);
                            continue block57;
                        }
                        condition = typeUses != null;
                        this.errorOrNote(condition, Change.TYPE_MAYBE_REMOVED, "%s %s %s maybe removed", new Object[]{typeAccess, typeKind, typeName, typeUses}).element(typeName);
                        continue block57;
                    }
                    case 2: {
                        typeKind = referenceType.getTypeKind();
                        typeName = referenceType.getName();
                        typeUses = this.uses.getTypeUses(referenceType.getName());
                        typeAccess = referenceType.getReferenceAccess();
                        revisedAccess = revisedType.getReferenceAccess();
                        if (CompatibilityAccess.isMoreExported(typeAccess, revisedAccess)) {
                            this.error(Change.ELEMENT_REDUCED, "%s %s %s %s", new Object[]{typeAccess, typeKind, typeName, revisedAccess, typeUses}).element(typeName);
                            break;
                        }
                        if (!CompatibilityAccess.isMoreConcealed(typeAccess, revisedAccess)) break;
                        this.note(Change.ELEMENT_EXPANDED, "%s %s %s %s", new Object[]{typeAccess, typeKind, typeName, revisedAccess}).element(typeName);
                        break;
                    }
                    case 3: {
                        typeKind = revisedType.getTypeKind();
                        typeName = revisedType.getName();
                        typeAccess = revisedType.getReferenceAccess();
                        typeUses = this.uses.getTypeUses(revisedType.getName());
                        if (referenceModel.getDomain().dominates(packageName)) {
                            this.note(Change.ELEMENT_ADDED, "%s %s %s added", new Object[]{typeAccess, typeKind, typeName}).element(typeName);
                            break;
                        }
                        this.note(Change.ELEMENT_INCLUDED, "%s %s %s added by domain %s", new Object[]{typeAccess, typeKind, typeName, revisedModel.getDomain().getSubdomain(packageName).getName()}).element(typeName);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                members = ComparisonIterators.iterator(referenceType, revisedType, (Function<Type, Iterable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$compare$9(oracle.javatools.exports.classpath.Type ), (Loracle/javatools/exports/classpath/Type;)Ljava/lang/Iterable;)(), Member.UNQUALIFIED_COMPARATOR);
                block58: while (members.hasNext()) {
                    switch (2.$SwitchMap$oracle$javatools$exports$common$ComparisonIterators$Comparison[members.next().ordinal()]) {
                        case 1: {
                            removedMember = members.left();
                            memberKind = removedMember.getKind();
                            memberName = removedMember.getName();
                            memberAccess = removedMember.getReferenceAccess();
                            memberUses = this.uses.getMemberUses(memberName);
                            if (CompatibilityAccess.isConcealedOrNull(memberAccess) && memberUses == null) continue block58;
                            switch (2.$SwitchMap$oracle$javatools$exports$name$ElementKind[removedMember.getKind().ordinal()]) {
                                case 1: {
                                    constructors = revisedType.getApplicableConstructors((ConstructorName)removedMember.getName(), removedMember.getParameterTypes());
                                    replacement = constructors.isEmpty() != false ? null : (Member)constructors.iterator().next();
                                    break;
                                }
                                case 2: {
                                    replacement = null;
                                    access = null;
                                    for (OverrideEquivalentMethod oem : revisedType.getApplicableMethods((MethodName)removedMember.getName(), removedMember.getParameterTypes())) {
                                        if (!CompatibilityAccess.isMoreExported(oem.getMethod().getReferenceAccess(), access)) continue;
                                        replacement = oem.getMethod();
                                        access = replacement.getReferenceAccess();
                                    }
                                    break;
                                }
                                case 3: {
                                    replacement = revisedType.getDeclaredOrInheritedField(((Field)removedMember).getName());
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("unexpected label " + (Object)removedMember.getKind());
                                }
                            }
                            if (replacement == null) {
                                this.error(Change.ELEMENT_REMOVED, "%s %s %s removed", new Object[]{memberAccess, memberKind, memberName, memberUses}).element(memberName);
                                continue block58;
                            }
                            revisedAccess = replacement.getReferenceAccess();
                            if (CompatibilityAccess.isMoreConcealed(revisedAccess, memberAccess)) {
                                this.error(Change.MEMBER_REDUCED_REPLACED, "%s %s %s removed, replaced by %s %s", new Object[]{memberAccess, memberKind, memberName, revisedAccess, replacement.getQualifiedSourceName(), memberUses}).element(memberName);
                                continue block58;
                            }
                            if (CompatibilityAccess.isMoreExported(revisedAccess, memberAccess)) {
                                this.warning(Change.MEMBER_EXPANDED_REPLACED, "%s %s %s removed, replaced by %s %s", new Object[]{memberAccess, memberKind, memberName, revisedAccess, replacement.getQualifiedSourceName(), memberUses}).element(memberName);
                                continue block58;
                            }
                            this.warning(Change.MEMBER_REPLACED, "%s %s %s removed, replaced by %s", new Object[]{memberAccess, memberKind, memberName, replacement.getQualifiedSourceName(), memberUses}).element(memberName);
                            continue block58;
                        }
                        case 2: {
                            referenceMember = members.left();
                            revisedMember = members.right();
                            memberKind = referenceMember.getKind();
                            memberName = referenceMember.getName();
                            memberUses = this.uses.getMemberUses(referenceMember.getName());
                            referenceMemberAccess = referenceMember.getReferenceAccess();
                            revisedMemberAccess = revisedMember.getReferenceAccess();
                            if (referenceType != null && memberKind.isMethod()) {
                                this.checkAbstractionOfNewOrChangedMethod((Method)referenceMember, referenceType, (Method)revisedMember, revisedType, typeUses);
                            }
                            if ((CompatibilityAccess.isExportedOrRestricted(revisedMemberAccess) || memberUses != null) && CompatibilityAccess.isMoreExported(revisedMemberAccess, referenceMemberAccess)) {
                                this.note(Change.ELEMENT_EXPANDED, "%s %s %s %s", new Object[]{referenceMemberAccess, memberKind, memberName, revisedMemberAccess}).element(memberName);
                            }
                            if (CompatibilityAccess.isConcealedOrNull(referenceMemberAccess) && memberUses == null) continue block58;
                            if (CompatibilityAccess.isMoreConcealed(revisedMemberAccess, referenceMemberAccess)) {
                                this.error(Change.ELEMENT_REDUCED, "%s %s %s %s", new Object[]{referenceMemberAccess, memberKind, memberName, revisedMemberAccess, memberUses}).element(memberName);
                            }
                            block35 : switch (2.$SwitchMap$oracle$javatools$exports$name$ElementKind[referenceMember.getKind().ordinal()]) {
                                case 3: {
                                    referenceField = (Field)referenceMember;
                                    revisedField = (Field)revisedMember;
                                    referenceConstantValue = referenceField.getConstantValue();
                                    revisedConstantValue = revisedField.getConstantValue();
                                    if (Objects.equals(referenceConstantValue, revisedConstantValue)) ** GOTO lbl249
                                    if (!referenceField.isConstant() || !revisedField.isConstant()) ** GOTO lbl243
                                    this.note(Change.FIELD_CHANGED, "%s %s %s constant value changed to %s", new Object[]{referenceMemberAccess, memberKind, memberName, this.image(revisedConstantValue), memberUses}).element(memberName);
                                    ** GOTO lbl249
lbl243:
                                    // 1 sources

                                    if (referenceField.isConstant()) {
                                        this.note(Change.FIELD_CHANGED, "%s %s %s no longer constant", new Object[]{referenceMemberAccess, memberKind, memberName, memberUses}).element(memberName);
                                    } else {
                                        this.note(Change.FIELD_CHANGED, "%s %s %s newly constant", new Object[]{referenceMemberAccess, memberKind, memberName, memberUses}).element(memberName);
                                    }
                                }
lbl249:
                                // 5 sources

                                case 2: {
                                    if (!referenceMember.isFinal() && revisedMember.isFinal()) {
                                        this.error(Change.MEMBER_FINAL_ADDED, "%s %s %s final modifier added", new Object[]{referenceMemberAccess, referenceMember.getKind(), memberName, memberUses}).element(memberName);
                                    }
                                    if (referenceMember.isStatic() != revisedMember.isStatic()) {
                                        if (referenceMember.isStatic()) {
                                            this.error(Change.MEMBER_STATIC_REMOVED, "%s %s %s static modifier removed", new Object[]{referenceMemberAccess, referenceMember.getKind(), memberName, memberUses}).element(memberName);
                                        } else {
                                            this.error(Change.MEMBER_STATIC_ADDED, "%s %s %s static modifier added", new Object[]{referenceMemberAccess, referenceMember.getKind(), memberName, memberUses}).element(memberName);
                                        }
                                    }
                                    leftType = referenceMember.getMemberType();
                                    rightType = revisedMember.getMemberType();
                                    if (leftType != null) {
                                        revisedLeftType = revisedModel.findType(leftType.getName(), "member type", revisedMember.getName());
                                        if (revisedLeftType.isUnresolved()) {
                                            if (leftType.isInnerStatic() && rightType.isInnerStatic() && leftType.getSimpleName().equals(rightType.getSimpleName()) && !(revisedOuterType = revisedModel.findType(leftType.getOuterType().getName(), "outer member type", revisedMember.getName())).isUnresolved() && Conversions.isWideningReferenceConversion(revisedOuterType, rightType.getOuterType())) {
                                                this.warning(Change.MEMBER_TYPE_MOVED, "%s %s %s type moved from %s to %s", new Object[]{referenceMemberAccess, memberKind, memberName, leftType.getName(), rightType.getName(), memberUses}).element(memberName);
                                                break;
                                            }
                                        } else {
                                            leftType = revisedLeftType;
                                        }
                                    }
                                    conversion = Conversions.memberTypeConversion(leftType, rightType);
                                    switch (2.$SwitchMap$oracle$javatools$exports$classpath$Conversions$MemberTypeConversion[conversion.ordinal()]) {
                                        case 1: {
                                            break block35;
                                        }
                                        case 2: {
                                            this.warning(Change.MEMBER_NARROWED, "%s %s %s type narrowed from %s to %s", new Object[]{referenceMemberAccess, memberKind, memberName, leftType.getName(), rightType.getName(), memberUses}).element(typeName);
                                            break block35;
                                        }
                                        case 3: {
                                            this.error(Change.MEMBER_WIDENED, "%s %s %s type widened from %s to %s", new Object[]{referenceMemberAccess, memberKind, memberName, leftType.getName(), rightType.getName(), memberUses}).element(typeName);
                                            break block35;
                                        }
                                        case 4: {
                                            this.error(Change.MEMBER_BOXED, "%s %s %s boxed to %s", new Object[]{referenceMemberAccess, memberKind, memberName, rightType.getName(), memberUses}).element(memberName);
                                            break block35;
                                        }
                                        case 5: {
                                            this.note(Change.MEMBER_UNBOXED, "%s %s %s unboxed to %s", new Object[]{referenceMemberAccess, memberKind, memberName, rightType.getName(), memberUses}).element(memberName);
                                            break block35;
                                        }
                                        case 6: {
                                            this.note(Change.MEMBER_UNVOIDED, "%s %s %s type changed from void to %s", new Object[]{referenceMemberAccess, memberKind, memberName, rightType.getName(), memberUses}).element(typeName);
                                            break block35;
                                        }
                                        case 7: {
                                            this.error(Change.MEMBER_VOIDED, "%s %s %s type changed from %s to void", new Object[]{referenceMemberAccess, memberKind, memberName, leftType.getName(), memberUses}).element(typeName);
                                            break block35;
                                        }
                                        case 8: {
                                            this.error(Change.MEMBER_RETYPED, "%s %s %s type changed from %s to %s", new Object[]{referenceMemberAccess, memberKind, memberName, leftType.getName(), rightType.getName(), memberUses}).element(typeName);
                                            break block35;
                                        }
                                    }
                                    throw new IllegalArgumentException("unexpected member type conversion " + (Object)conversion);
                                }
                            }
                            continue block58;
                        }
                        case 3: {
                            addedMember = members.right();
                            memberName = addedMember.getName();
                            memberAccess = addedMember.getReferenceAccess();
                            memberKind = addedMember.getKind();
                            if (referenceType != null && memberKind.isMethod()) {
                                this.checkAbstractionOfNewOrChangedMethod(null, referenceType, (Method)addedMember, revisedType, typeUses);
                            }
                            if (!CompatibilityAccess.isExportedOrRestricted(memberAccess)) continue block58;
                            this.note(Change.ELEMENT_ADDED, "%s %s %s added", new Object[]{memberAccess, memberKind, memberName}).element(memberName);
                            continue block58;
                        }
                    }
                    throw new IllegalStateException();
                }
            }
        }
        this.sort(this.errors);
        this.sort(this.warnings);
        this.sort(this.notes);
        this.sort(this.matchedApprovals);
    }

    protected void checkAbstractionOfNewOrChangedMethod(Method referenceMethod, Type referenceType, Method revisedMethod, Type revisedType, TypeUses typeUses) {
        boolean concreteUses;
        OverrideEquivalentMethod methods;
        MethodName methodName = revisedMethod.getName();
        if (referenceMethod != null && referenceMethod.isAbstract()) {
            return;
        }
        if (!revisedMethod.isAbstract()) {
            return;
        }
        if (referenceMethod == null && (methods = referenceType.getDeclaredOrInheritedMethod(methodName)).isAbstract()) {
            return;
        }
        ExtensionUses extensionUses = new ExtensionUses(typeUses);
        HashSet<Type> visited = new HashSet<Type>();
        visited.add(revisedType);
        for (Type extendingType : revisedType.getExtendingTypes()) {
            this.searchExtendingTypesForExtensionUses(extendingType, methodName, extensionUses, visited, referenceType.getModel());
        }
        if (extensionUses.getConcrete() > 0) {
            concreteUses = true;
        } else if (extensionUses.getExtensions() > 0) {
            concreteUses = false;
        } else if (CompatibilityAccess.isExportedOrRestricted(CompatibilityAccess.mostConcealed(referenceType.getExtensionAccess(), revisedType.getExtensionAccess()))) {
            concreteUses = false;
            extensionUses = null;
        } else {
            return;
        }
        if (referenceMethod == null) {
            this.errorOrWarning(concreteUses, Change.METHOD_UNIMPLEMENTED, "%s %s %s added with no implementation", new Object[]{revisedMethod.getReferenceAccess(), ElementKind.METHOD, methodName, extensionUses}).element(methodName);
        } else {
            this.errorOrWarning(concreteUses, Change.METHOD_ABSTRACTED, "%s %s %s implementation removed", new Object[]{referenceMethod.getReferenceAccess(), ElementKind.METHOD, methodName, extensionUses}).element(methodName);
        }
    }

    private void searchExtendingTypesForExtensionUses(Type type, MethodName methodName, ExtensionUses extensionUses, Set<Type> visited, ClassPathModel referenceModel) {
        if (!visited.add(type)) {
            return;
        }
        OverrideEquivalentMethod inheritedMethods = type.getDeclaredOrInheritedMethod(methodName);
        if (!inheritedMethods.isAbstract()) {
            return;
        }
        TypeUses typeUses = this.uses.getTypeUses(type.getName());
        extensionUses.addUses(type.getName(), typeUses);
        for (Type extendingType : type.getExtendingTypes()) {
            this.searchExtendingTypesForExtensionUses(extendingType, methodName, extensionUses, visited, referenceModel);
        }
    }

    private String image(Object constantValue) {
        if (constantValue == null) {
            return "null";
        }
        if (constantValue instanceof Character) {
            return BaselineReaderWriter.encode(constantValue.toString(), '\'');
        }
        if (constantValue instanceof String) {
            return BaselineReaderWriter.encode((String)constantValue, '\"');
        }
        return constantValue.toString();
    }

    private Message error(Change type, String format, Object ... arguments) {
        return this.message(type, true, Severity.ERROR, Severity.NOTE, format, arguments);
    }

    private Message errorOrNote(boolean condition, Change type, String format, Object ... arguments) {
        return this.message(type, condition, Severity.ERROR, Severity.NOTE, format, arguments);
    }

    private Message errorOrWarning(boolean condition, Change type, String format, Object ... arguments) {
        return this.message(type, condition, Severity.ERROR, Severity.WARNING, format, arguments);
    }

    private Message warningOrNote(boolean condition, Change type, String format, Object ... arguments) {
        return this.message(type, condition, Severity.WARNING, Severity.NOTE, format, arguments);
    }

    private Message warning(Change type, String format, Object ... arguments) {
        return this.message(type, true, Severity.WARNING, Severity.NOTE, format, arguments);
    }

    private Message note(Change type, String format, Object ... arguments) {
        return this.message(type, true, Severity.NOTE, Severity.NOTE, format, arguments);
    }

    private Message message(Change change, boolean condition, Severity severityTrue, Severity severityFalse, String format, Object ... arguments) {
        String matchId;
        String access1 = "";
        String access2 = "";
        String label = "";
        boolean used = false;
        for (int i = 0; i < arguments.length; ++i) {
            String image;
            Object argument = arguments[i];
            if (argument instanceof TypeOrMemberUses || argument instanceof ExtensionUses || argument instanceof LibraryUses) {
                used = true;
                continue;
            }
            if (argument instanceof ElementKind) {
                if (!label.isEmpty()) continue;
                image = ((ElementKind)((Object)argument)).toLowerCase();
                label = '-' + image;
                arguments[i] = image;
                continue;
            }
            if (argument instanceof TypeKind) {
                if (!label.isEmpty()) continue;
                image = ((TypeKind)((Object)argument)).toLowerCase();
                label = '-' + image;
                arguments[i] = image;
                continue;
            }
            if (!(argument instanceof CompatibilityAccess)) continue;
            if (access1.isEmpty()) {
                access1 = '-' + ((CompatibilityAccess)((Object)argument)).toLowerCase();
                continue;
            }
            if (!access2.isEmpty()) continue;
            access2 = '-' + ((CompatibilityAccess)((Object)argument)).toLowerCase();
        }
        StringBuilder idBuilder = new StringBuilder("baseline");
        boolean accessed = false;
        int usedIndex = 0;
        for (Object generator : change.generators) {
            if (generator.equals("?used")) {
                if (!used) continue;
                usedIndex = idBuilder.length();
                idBuilder.append("-used");
                continue;
            }
            if (generator == CompatibilityAccess.class) {
                idBuilder.append(accessed ? access2 : access1);
                accessed = true;
                continue;
            }
            if (generator.getClass().isArray()) {
                idBuilder.append(label);
                continue;
            }
            idBuilder.append('-').append(generator);
        }
        String id = idBuilder.toString();
        String string = matchId = used ? id.substring(0, usedIndex) + id.substring(usedIndex + 5) : id;
        if (used) {
            format = format + ": %s";
        }
        Message message = this.log.message(condition ? severityTrue : severityFalse, id, format, arguments);
        String matchText = null;
        boolean matched = false;
        if (!this.approvals.isEmpty() && this.approvals.valuesSize(matchId) > 0) {
            String messageText;
            matchText = messageText = message.getMessage();
            if (used) {
                this.USES_MATCHER.reset(matchText);
                if (this.USES_MATCHER.find()) {
                    matchText = matchText.substring(0, this.USES_MATCHER.start());
                }
            }
            matched = this.approvals.contains(matchId, matchText);
        }
        if (matched) {
            this.matchedApprovals.add(message);
            this.unmatchedApprovals.removeValue(matchId, matchText);
        } else {
            switch (message.getSeverity()) {
                case ERROR: {
                    this.errors.add(message);
                    if (!used) break;
                    ++this.errorsWithUsesCount;
                    break;
                }
                case WARNING: {
                    this.warnings.add(message);
                    break;
                }
                case NOTE: {
                    this.notes.add(message);
                }
            }
        }
        return message;
    }

    protected void sort(List<Message> list) {
        Collections.sort(list, (l, r) -> {
            Object lo = l.getValue("element", Object.class);
            String ls = lo instanceof ElementName ? ((ElementName)lo).getQualifiedSourceName() : (lo instanceof Path ? Paths.toString((Path)lo) : String.valueOf(lo));
            Object ro = r.getValue("element", Object.class);
            String rs = ro instanceof ElementName ? ((ElementName)ro).getQualifiedSourceName() : (ro instanceof Path ? Paths.toString((Path)ro) : String.valueOf(ro));
            return ls.compareTo(rs);
        });
    }

    private static <T> Object list(final Collection<T> list, final Function<T, String> formatter) {
        return new Object(){

            public String toString() {
                Iterator iterator = list.iterator();
                switch (list.size()) {
                    case 0: {
                        return "<empty>";
                    }
                    case 1: {
                        return (String)formatter.apply(iterator.next());
                    }
                    case 2: {
                        return (String)formatter.apply(iterator.next()) + " and " + (String)formatter.apply(iterator.next());
                    }
                }
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < list.size() - 1; ++i) {
                    builder.append((String)formatter.apply(iterator.next())).append(", ");
                }
                builder.append("and ").append((String)formatter.apply(iterator.next()));
                return builder.toString();
            }
        };
    }

    private static String format(String id, String message) {
        StringBuilder builder = new StringBuilder(id).append(": ");
        int i = "baseline-used-exported-constructor-restricted: ".length() - builder.length();
        while (--i > 0) {
            builder.append(' ');
        }
        builder.append(message);
        return builder.toString();
    }

    private static /* synthetic */ Iterable lambda$compare$9(Type t) {
        return t != null ? t.getDeclaredMembers() : null;
    }

    private static /* synthetic */ Iterable lambda$compare$8(Package p) {
        return p != null ? p.getExportableControlledTypes() : null;
    }

    private static /* synthetic */ int lambda$compare$7(Package l, Package r) {
        return l.getName().compareTo(r.getName());
    }

    private static /* synthetic */ int lambda$compare$6(ExportDomain.Subdomain l, ExportDomain.Subdomain r) {
        return l.getName().compareTo(r.getName());
    }

    static /* synthetic */ Enum[] access$000() {
        return ELEMENT_KINDS;
    }

    static /* synthetic */ TypeKind[] access$100() {
        return TYPE_KINDS;
    }

    static /* synthetic */ ElementKind[] access$200() {
        return MEMBER_KINDS;
    }

    static /* synthetic */ ElementKind[] access$300() {
        return METHOD_KINDS;
    }

    static /* synthetic */ ElementKind[] access$400() {
        return FIELD_KINDS;
    }

    private class ChangeIterator
    implements Iterator<String> {
        private Iterator<Message> iterator;
        private Predicate<Message> filter;
        private String next;

        public ChangeIterator(List<Message> changes) {
            this(changes, m -> true);
        }

        public ChangeIterator(List<Message> changes, Predicate<Message> filter) {
            this.iterator = changes.iterator();
            this.filter = filter;
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public String next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            String result = this.next;
            this.next = null;
            this.advance();
            return result;
        }

        private void advance() {
            assert (this.next == null);
            while (this.iterator.hasNext()) {
                Message message = this.iterator.next();
                if (!this.filter.test(message)) continue;
                this.next = BaselineComparison.format(message.getId(), message.getMessage());
                break;
            }
        }
    }

    private static class ExtensionUses {
        private Map<TypeName, TypeUses> uses = new LinkedHashMap<TypeName, TypeUses>();
        private int directExtensions;
        private int directConcrete;
        private int extensions;
        private int concrete;

        ExtensionUses(TypeUses uses) {
            if (uses != null) {
                short s = uses.getExtensions();
                this.directExtensions = s;
                this.extensions = s;
                short s2 = uses.getConcrete();
                this.directConcrete = s2;
                this.concrete = s2;
            }
        }

        void addUses(TypeName name, TypeUses uses) {
            if (uses == null) {
                return;
            }
            short extensions = uses.getExtensions();
            if (extensions == 0) {
                return;
            }
            this.extensions += extensions;
            this.concrete += uses.getConcrete();
            this.uses.put(name, uses);
        }

        int getExtensions() {
            return this.extensions;
        }

        int getConcrete() {
            return this.concrete;
        }

        boolean isConcrete() {
            return this.concrete > 0;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getExtensions());
            builder.append(" extension");
            if (this.getExtensions() != 1) {
                builder.append('s');
            }
            if (this.getExtensions() > 0) {
                builder.append(" (");
                builder.append(this.getConcrete());
                builder.append(" concrete)");
            }
            if (this.directExtensions < this.extensions) {
                builder.append(": ");
                if (this.directExtensions > 0) {
                    builder.append("direct ");
                    builder.append(this.directExtensions);
                    builder.append(" (");
                    builder.append(this.directConcrete);
                    builder.append("), ");
                }
                for (Map.Entry<TypeName, TypeUses> entry : this.uses.entrySet()) {
                    short extensions = entry.getValue().getExtensions();
                    if (extensions == 0) continue;
                    builder.append(entry.getKey());
                    builder.append(", ");
                    builder.append(extensions);
                    builder.append(" (").append(entry.getValue().getConcrete()).append("), ");
                }
                builder.setLength(builder.length() - 2);
                builder.append(')');
            }
            return builder.toString();
        }
    }

    public static enum Change {
        DOMAIN_ADDED(1, true, c -> true, "domain-added"),
        DOMAIN_REMOVED(1, false, c -> true, "domain-removed"),
        DOMAIN_EXCEPT_ADDED(1, true, c -> true, "domain-except-added"),
        DOMAIN_EXCEPT_REMOVED(1, false, c -> true, "domain-except-removed"),
        LIBRARY_ADDED(1, true, c -> true, "?used", "library-added"),
        LIBRARY_ALIAS_ADDED(1, true, c -> true, "?used", "library-alias-added"),
        LIBRARY_REMOVED(1, false, c -> true, "?used", "library-removed"),
        LIBRARY_RENAMED(1, false, c -> true, "?used", "library-renamed"),
        LIBRARY_MOVED(1, false, c -> true, "?used", "library-moved"),
        LIBRARY_CHANGED(1, false, c -> true, "?used", "library-changed"),
        ELEMENT_ADDED(2, true, c -> true, "?used", CompatibilityAccess.class, BaselineComparison.access$000(), "added"),
        ELEMENT_REMOVED(2, false, c -> true, "?used", CompatibilityAccess.class, BaselineComparison.access$000(), "removed"),
        ELEMENT_EXCLUDED(2, true, c -> true, "?used", CompatibilityAccess.class, BaselineComparison.access$000(), "excluded"),
        ELEMENT_EXPANDED(2, true, c -> Change.lt(c), "?used", CompatibilityAccess.class, BaselineComparison.access$000(), CompatibilityAccess.class),
        ELEMENT_INCLUDED(2, false, c -> true, "?used", CompatibilityAccess.class, BaselineComparison.access$000(), "included"),
        TYPE_MAYBE_REMOVED(2, false, c -> true, new Object[]{"?used", CompatibilityAccess.class, BaselineComparison.access$100(), "maybe"}),
        ELEMENT_REDUCED(2, false, c -> Change.gt(c), "?used", CompatibilityAccess.class, BaselineComparison.access$000(), CompatibilityAccess.class),
        MEMBER_TYPE_MOVED(2, true, c -> true, new Object[]{"?used", CompatibilityAccess.class, BaselineComparison.access$200(), "type-moved"}),
        MEMBER_REPLACED(2, true, c -> true, new Object[]{"?used", CompatibilityAccess.class, BaselineComparison.access$200(), "replaced"}),
        MEMBER_EXPANDED_REPLACED(2, true, c -> Change.lt(c), new Object[]{"?used", CompatibilityAccess.class, BaselineComparison.access$200(), "replaced", CompatibilityAccess.class}),
        MEMBER_REDUCED_REPLACED(2, true, c -> Change.gt(c), new Object[]{"?used", CompatibilityAccess.class, BaselineComparison.access$200(), "replaced", CompatibilityAccess.class}),
        TYPE_REPLACED(2, true, c -> true, new Object[]{"?used", CompatibilityAccess.class, BaselineComparison.access$100(), "replaced"}),
        METHOD_ABSTRACTED(2, false, c -> true, new Object[]{"?used", CompatibilityAccess.class, BaselineComparison.access$300(), "abstracted"}),
        METHOD_UNIMPLEMENTED(2, false, c -> true, new Object[]{"?used", CompatibilityAccess.class, BaselineComparison.access$300(), "unimplemented"}),
        MEMBER_BOXED(2, false, c -> true, new Object[]{"?used", CompatibilityAccess.class, BaselineComparison.access$200(), "boxed"}),
        MEMBER_UNBOXED(2, true, c -> true, new Object[]{"?used", CompatibilityAccess.class, BaselineComparison.access$200(), "unboxed"}),
        MEMBER_WIDENED(2, false, c -> true, new Object[]{"?used", CompatibilityAccess.class, BaselineComparison.access$200(), "widened"}),
        MEMBER_NARROWED(2, true, c -> true, new Object[]{"?used", CompatibilityAccess.class, BaselineComparison.access$200(), "narrowed"}),
        MEMBER_VOIDED(2, false, c -> true, new Object[]{"?used", CompatibilityAccess.class, BaselineComparison.access$200(), "voided"}),
        MEMBER_UNVOIDED(2, true, c -> true, new Object[]{"?used", CompatibilityAccess.class, BaselineComparison.access$200(), "unvoided"}),
        FIELD_CHANGED(2, false, c -> true, new Object[]{"?used", CompatibilityAccess.class, BaselineComparison.access$400(), "changed"}),
        MEMBER_RETYPED(2, true, c -> true, new Object[]{"?used", CompatibilityAccess.class, BaselineComparison.access$200(), "retyped"}),
        MEMBER_FINAL_ADDED(2, false, c -> true, new Object[]{"?used", CompatibilityAccess.class, BaselineComparison.access$200(), "final-added"}),
        MEMBER_STATIC_ADDED(2, false, c -> true, new Object[]{"?used", CompatibilityAccess.class, BaselineComparison.access$200(), "static-added"}),
        MEMBER_STATIC_REMOVED(2, false, c -> true, new Object[]{"?used", CompatibilityAccess.class, BaselineComparison.access$200(), "static-removed"}),
        CHANGE_RETRACTED(0, false, c -> true, "change-retracted"),
        APPROVAL_INVALID(0, false, c -> true, "approval-invalid");

        private final int nameIndex;
        private final boolean expandsAccess;
        private final Object[] generators;

        private Change(int element, boolean expandsAccess, PermutationFilter permutationFilter, Object ... idGenerators) {
            this.nameIndex = element;
            this.expandsAccess = expandsAccess;
            this.generators = idGenerators;
            Change.branch(idGenerators, 0, new Object[idGenerators.length], 0, permutationFilter, this);
        }

        private static boolean lt(Object ... values) {
            ArrayList<CompatibilityAccess> access = new ArrayList<CompatibilityAccess>(2);
            for (Object value : values) {
                if (!(value instanceof CompatibilityAccess)) continue;
                access.add((CompatibilityAccess)((Object)value));
            }
            return CompatibilityAccess.isMoreConcealed((CompatibilityAccess)((Object)access.get(0)), (CompatibilityAccess)((Object)access.get(1)));
        }

        private static boolean gt(Object ... values) {
            ArrayList<CompatibilityAccess> access = new ArrayList<CompatibilityAccess>(2);
            for (Object value : values) {
                if (!(value instanceof CompatibilityAccess)) continue;
                access.add((CompatibilityAccess)((Object)value));
            }
            return CompatibilityAccess.isMoreExported((CompatibilityAccess)((Object)access.get(0)), (CompatibilityAccess)((Object)access.get(1)));
        }

        private static void branch(Object[] idGenerators, int index, Object[] values, int vi, PermutationFilter filter, Change change) {
            if (index < idGenerators.length) {
                Object generator;
                if ((generator = idGenerators[index++]) instanceof Class) {
                    for (Enum value : (Enum[])((Class)generator).getEnumConstants()) {
                        values[vi] = value;
                        Change.branch(idGenerators, index, values, vi + 1, filter, change);
                    }
                } else if (generator.getClass().isArray()) {
                    Object[] objectArray = (Object[])generator;
                    int n = objectArray.length;
                    for (int i = 0; i < n; ++i) {
                        Object value;
                        values[vi] = value = objectArray[i];
                        Change.branch(idGenerators, index, values, vi + 1, filter, change);
                    }
                } else {
                    String string = generator.toString();
                    if (string.charAt(0) == '?') {
                        Change.branch(idGenerators, index, values, vi, filter, change);
                        values[vi] = string.substring(1);
                        Change.branch(idGenerators, index, values, vi + 1, filter, change);
                    } else {
                        values[vi] = string;
                        Change.branch(idGenerators, index, values, vi + 1, filter, change);
                    }
                }
            } else if (filter.accept(values)) {
                StringBuilder builder = new StringBuilder("baseline");
                for (int i = 0; i < vi; ++i) {
                    Object value = values[i];
                    if (value instanceof Enum) {
                        value = value.toString().toLowerCase();
                    }
                    builder.append('-').append(value);
                }
                ID_TO_CHANGE.put(builder.toString(), change);
            }
        }

        public int getNameIndex() {
            return this.nameIndex;
        }

        public boolean isExpandsAccess() {
            return this.expandsAccess;
        }

        public static Change getChange(String id) {
            return (Change)((Object)ID_TO_CHANGE.get(id));
        }

        private static interface PermutationFilter {
            public boolean accept(Object ... var1);
        }
    }
}

