/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.mongodb.tst;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class TestMainJDBCCustom {
    static final String JDBC_DRIVER = "oracle.dbtools.thirdparty.mongodb.jdbc.MongoDBDriver";
    static final String DB_URL = "jdbc:mongodb://localhost:27017/testdb";
    static String[] nosqls = new String[]{"db.simple.stats()", "/*table*/db.simple.stats()"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Connection connection = null;
        try {
            Class.forName(JDBC_DRIVER);
            System.out.println("Connecting to database...");
            connection = DriverManager.getConnection(DB_URL);
            for (String string : nosqls) {
                System.out.println("Creating statement..." + string);
                TestMainJDBCCustom.executePreparedStatement(connection, string);
            }
            connection.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
        System.out.println("Goodbye!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executePreparedStatement(Connection connection, String string) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet != null) {
                System.out.println(TestMainJDBCCustom.desc(resultSet.getMetaData()));
                int n = 0;
                while (resultSet.next()) {
                    ++n;
                    System.out.println(resultSet.toString());
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("[");
                    for (int i = 1; i <= resultSet.getMetaData().getColumnCount(); ++i) {
                        Object object = resultSet.getObject(i);
                        if (i > 1) {
                            stringBuffer.append("|");
                        }
                        if (object == null) {
                            stringBuffer.append("NULL");
                            continue;
                        }
                        stringBuffer.append(object.toString());
                    }
                    stringBuffer.append("]");
                    System.out.println(stringBuffer.toString());
                }
                System.out.println("");
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeQuery(Connection connection, String string) {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            if (resultSet != null) {
                System.out.println(TestMainJDBCCustom.desc(resultSet.getMetaData()));
                int n = 0;
                while (resultSet.next()) {
                    ++n;
                    System.out.println(resultSet.toString());
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("[");
                    for (int i = 1; i <= resultSet.getMetaData().getColumnCount(); ++i) {
                        Object object = resultSet.getObject(i);
                        if (i > 1) {
                            stringBuffer.append("|");
                        }
                        stringBuffer.append(object.toString());
                    }
                    stringBuffer.append("]");
                    System.out.println(stringBuffer.toString());
                }
                System.out.println("");
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private static String desc(ResultSetMetaData resultSetMetaData) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                if (i > 1) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(resultSetMetaData.getColumnName(i));
                stringBuffer.append(" ");
                stringBuffer.append(resultSetMetaData.getColumnTypeName(i));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuffer.toString();
    }
}

