/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.program;

import java.sql.Connection;
import java.util.HashMap;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.utils.Connections;

public class ProgramPropertyPanelDBTask
extends DatabaseQueryTask<Boolean> {
    protected String connectionName;
    protected String objectName;
    protected String objectOwner;
    protected String taskName;
    protected String query;
    protected String statement;

    public ProgramPropertyPanelDBTask(String string, String string2, String string3, String string4, String string5) {
        super(DatabaseNavigatorResources.getString((String)"CONNECTION_FILTER_OPEN"), IRaptorTaskRunMode.IDE_STATUSBAR, false, false, true);
        this.connectionName = string;
        this.objectName = string2;
        this.objectOwner = string3;
        this.taskName = string4;
        this.statement = string5;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public String getQuery() {
        return this.taskName;
    }

    protected Boolean doWork() throws TaskException {
        return this.doWorkStatement();
    }

    protected Boolean doWorkStatement() throws TaskException {
        Connection connection;
        try {
            connection = Connections.getInstance().getConnection(this.getConnectionName());
        }
        catch (Exception exception) {
            return Boolean.FALSE;
        }
        LockManager.lock((Connection)connection);
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (this.objectName != null) {
                hashMap.put("PROGRAM_NAME", this.objectName);
            }
            if (this.objectOwner != null) {
                hashMap.put("OWNER", this.objectOwner);
            }
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            dBUtil.setRaiseError(true);
            Boolean bl = dBUtil.execute(this.statement, hashMap);
            return bl;
        }
        catch (Throwable throwable) {
            throw new TaskException(throwable);
        }
        finally {
            LockManager.unlock((Connection)connection);
        }
    }
}

