/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.groups;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.models.SQLComboxModel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.RaptorQueryUtils;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;
import oracle.ide.help.HelpSystem;

public class CredentialListEditorDialog
extends JEWTDialog {
    private transient JPanel panel = new JPanel();
    private transient JScrollPane listScrollPane = new JScrollPane();
    private transient JList credentialList = new JList();
    private transient GridBagLayout gridBagLayout2 = new GridBagLayout();
    private transient JLabel messageLabel = new JLabel();
    private transient ListModel listModel;
    private transient CredentialListMouseListener credentialListMouseListener = new CredentialListMouseListener();

    public CredentialListEditorDialog(Frame frame, String string, Image image, Connection connection) {
        super(frame, SchedulerArb.get("GROUP_CREDENTIAL_LIST_DIALOG_PROMPT"));
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        this.panel.setLayout(this.gridBagLayout2);
        this.messageLabel.setText(SchedulerArb.get("GROUP_CREDENTIAL_LIST_DIALOG_MESSAGE"));
        this.listScrollPane.getViewport().add((Component)this.credentialList, null);
        this.panel.add((Component)this.listScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 142, 148));
        this.panel.add((Component)this.messageLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        try {
            String string2 = dBMSSchedulerCodeGenerator.generate(connection, "GROUP_CREDENTIALS_LIST", null);
            string2 = RaptorQueryUtils.promoteToDba((String)string2, (Connection)connection);
            this.listModel = new SQLComboxModel(Connections.getInstance().getConnectionName(connection), string2);
        }
        catch (Exception exception) {
            this.listModel = new DefaultListModel();
        }
        this.credentialList.setModel(this.listModel);
        this.credentialList.addMouseListener(this.credentialListMouseListener);
        this.setContent(this.panel);
        this.setIconImage(image);
        this.setModal(true);
        this.setResizable(true);
        this.setPreferredSize(new Dimension(480, 320));
        this.setButtonMask(7);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.panel, string);
    }

    public String getCredential() {
        Object object;
        Object e = this.credentialList.getSelectedValue();
        object = e != null ? (((String)(object = e.toString())).equalsIgnoreCase("default") ? "" : (String)object + "@") : "";
        return object;
    }

    private class CredentialListMouseListener
    extends MouseAdapter {
        private CredentialListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() >= 2) {
                CredentialListEditorDialog.this.dismissDialog(false);
            }
        }
    }
}

