/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.groups;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import oracle.dbtools.scheduler.panels.groups.AddressedIdentifier;

public class AddressedIdentifierSelection
implements Transferable,
ClipboardOwner {
    public static final DataFlavor addressedIdentifierFlavor = AddressedIdentifierSelection.createConstant(AddressedIdentifier.class, "Addressed Identifier");
    private static final DataFlavor[] flavors = new DataFlavor[]{addressedIdentifierFlavor};
    private AddressedIdentifier data;

    public AddressedIdentifierSelection(AddressedIdentifier addressedIdentifier) {
        this.data = addressedIdentifier;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])flavors.clone();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        for (int i = 0; i < flavors.length; ++i) {
            if (!dataFlavor.equals(flavors[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(addressedIdentifierFlavor)) {
            return this.data;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    private static DataFlavor createConstant(Class clazz, String string) {
        try {
            return new DataFlavor(clazz, string);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

