/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval.model;

import java.util.Collection;
import java.util.NavigableSet;
import java.util.TreeSet;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ClauseType;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.NaryClauseModel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModelEvent;

public class SortedClauseModel<E>
extends NaryClauseModel<E> {
    protected TreeSet<E> values = new TreeSet();

    static <E> int calculateIndexOf(TreeSet<E> treeSet, E e) {
        return treeSet.headSet(e).size();
    }

    public SortedClauseModel(Class<E> clazz, ClauseType clauseType, RepeatIntervalModel repeatIntervalModel) {
        this(clazz, clauseType, repeatIntervalModel, null);
    }

    public SortedClauseModel(Class<E> clazz, ClauseType clauseType, RepeatIntervalModel repeatIntervalModel, E[] EArray) {
        super(clazz, clauseType, repeatIntervalModel, EArray);
        this.reset();
    }

    @Override
    protected Collection<E> getValues() {
        return this.values;
    }

    protected void reset() {
        this.values.clear();
        if (this.defaultValue != null) {
            for (Object object : this.defaultValue) {
                this.values.add(object);
            }
        }
    }

    @Override
    public boolean add(E e) {
        boolean bl = false;
        if (e != null && (bl = this.values.add(e))) {
            int n = SortedClauseModel.calculateIndexOf(this.values, e);
            this.fireRepeatIntervalModelEvent(new RepeatIntervalModelEvent(this, RepeatIntervalModelEvent.EventType.CREATE, n, null, e));
        }
        return bl;
    }

    @Override
    public boolean remove(E e) {
        boolean bl = false;
        if (e != null && (bl = this.values.remove(e))) {
            int n = SortedClauseModel.calculateIndexOf(this.values, e);
            this.fireRepeatIntervalModelEvent(new RepeatIntervalModelEvent(this, RepeatIntervalModelEvent.EventType.DELETE, n, e, null));
        }
        return bl;
    }

    @Override
    public E[] getAll() {
        return this.values.toArray(this.newArray(this.values.size()));
    }

    public E[] getHeadList(E e, boolean bl) {
        NavigableSet<E> navigableSet = this.values.headSet(e, bl);
        return navigableSet.toArray(this.newArray(navigableSet.size()));
    }

    public E[] getTailList(E e, boolean bl) {
        NavigableSet<E> navigableSet = this.values.tailSet(e, bl);
        return navigableSet.toArray(this.newArray(navigableSet.size()));
    }

    @Override
    public boolean contains(E e) {
        boolean bl = false;
        if (e != null) {
            bl = this.values.contains(e);
        }
        return bl;
    }

    @Override
    public void clear() {
        E[] EArray = this.getAll();
        this.reset();
        this.fireRepeatIntervalModelEvent(new RepeatIntervalModelEvent(this, RepeatIntervalModelEvent.EventType.CLEAR, EArray, this.getAll()));
    }

    @Override
    public boolean isClear() {
        if (this.defaultValue != null) {
            if (this.defaultValue.length == this.values.size()) {
                for (Object object : this.defaultValue) {
                    if (this.contains(object)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return this.isEmpty();
    }

    @Override
    public int size() {
        return this.values.size();
    }
}

