/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval.model;

import oracle.dbtools.scheduler.panels.common.repeatinterval.model.Identifier;

public class IdentifierImpl
implements Comparable<IdentifierImpl>,
Identifier {
    protected final String orig;
    protected final String identifier;
    protected final boolean valid;
    protected final boolean escapeAllowed;

    public IdentifierImpl(String string) {
        this(string, null, false);
    }

    public IdentifierImpl(String string, Boolean bl, boolean bl2) {
        this.escapeAllowed = bl2;
        this.orig = string;
        this.valid = IdentifierImpl.isValidIdentifier(string, bl, bl2);
        String string2 = string;
        if (string != null && (bl == null || bl.booleanValue()) && string.contains("\"") && (this.valid || string.equals("\"\""))) {
            string2 = IdentifierImpl.stripDelimiters(string, bl2);
        }
        this.identifier = string2;
    }

    public String toString() {
        return this.orig;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        IdentifierImpl identifierImpl = (IdentifierImpl)object;
        return IdentifierImpl.areEqual(this.identifier, identifierImpl.identifier);
    }

    @Override
    public int compareTo(IdentifierImpl identifierImpl) {
        int n = 0;
        if (this != identifierImpl && this.identifier != identifierImpl.identifier) {
            n = this.identifier == null && identifierImpl.identifier != null ? -1 : (this.identifier != null && identifierImpl.identifier == null ? 1 : this.identifier.compareTo(identifierImpl.identifier));
        }
        return n;
    }

    public int hashCode() {
        int n = 7;
        n = n * 31 + (this.identifier == null ? 0 : this.identifier.hashCode());
        return n;
    }

    protected static boolean isValidIdentifier(String string, Boolean bl, boolean bl2) {
        if (string != null) {
            if (bl == null || bl.booleanValue()) {
                boolean bl3 = string.startsWith("\"");
                if (bl3) {
                    string = string.substring(1, string.length());
                } else if (bl != null && bl.booleanValue()) {
                    return false;
                }
                if (string.endsWith("\"")) {
                    string = string.substring(0, string.length() - 1);
                } else if (bl3 || bl != null && bl.booleanValue()) {
                    return false;
                }
                if (bl3 && bl2) {
                    string.replaceAll("([\"][\"])", "");
                }
            }
            if (string.contains("\"")) {
                return false;
            }
        }
        return string != null && string.length() > 0;
    }

    protected static String stripDelimiters(String string, boolean bl) {
        if (string != null) {
            if (string.startsWith("\"")) {
                string = string.substring(1, string.length());
            }
            if (string.endsWith("\"")) {
                string = string.substring(0, string.length() - 1);
            }
            if (bl) {
                string.replaceAll("([\"][\"])", "\"");
            }
        }
        return string;
    }

    public static String delimit(String string) {
        return IdentifierImpl.delimit(string, false);
    }

    public static String delimit(String object, boolean bl) {
        if (object != null && ((String)object).length() > 0) {
            if (bl) {
                object = "\"" + ((String)object).replaceAll("[\"]", "\"\"") + "\"";
            } else if (!((String)object).contains("\"")) {
                object = "\"" + (String)object + "\"";
            }
        }
        return object;
    }

    private static boolean areEqual(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.equals(object2);
    }

    public boolean isCleanIdentifier() {
        boolean bl = false;
        if (this.identifier != null && this.identifier.length() > 0) {
            bl = true;
            for (int i = 0; i < this.identifier.length(); ++i) {
                char c = this.identifier.charAt(i);
                if (Character.isUpperCase(c) || Character.isDigit(c) || c == '_') continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public boolean isValid() {
        return this.valid;
    }

    @Override
    public String getId(Boolean bl) {
        if (bl != null ? bl != false : this.valid && !this.isCleanIdentifier()) {
            return IdentifierImpl.delimit(this.identifier, this.escapeAllowed);
        }
        return this.identifier;
    }

    @Override
    public String getId() {
        return this.getId(null);
    }
}

