/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval.component;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import oracle.dbtools.raptor.datatypes.ui.control.FlatButton;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.panels.common.repeatinterval.component.ByClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.component.ByClauseButtonPanel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.Date;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.Month;

public class DatePanel
extends ByClause
implements ActionListener {
    protected Calendar calender = Calendar.getInstance();
    protected Locale locale = null;
    private String[] months = new String[12];
    private JComboBox monthButton = new JComboBox();
    private ComboBoxModel monthModel;
    private JSpinner yearButton = new JSpinner();
    protected SpinnerNumberModel yearModel = new SpinnerNumberModel(Calendar.getInstance().get(1), 1970, 2026, 1);
    private FlatButton prevButton;
    private FlatButton homeButton;
    private FlatButton nextButton;
    private JPanel daysPanel;
    private JPanel dualPanel;
    private CardLayout dualLayout;
    private Calendar cal;
    private TreeSet<Date> selectedDates;
    private boolean dualMode = false;
    private boolean singleSelection = false;
    private ByClauseButtonPanel noYearPanel;
    private JCheckBox years;
    private JButton clearAll;
    private EventListenerList actionListeners;
    private Date[] initVal = null;
    static final int YEAR_RANGE_MIN = 0;
    static final int YEAR_RANGE_MAX = 3000;
    static final int YEARS_IN_RANGE = 9;
    static final int CHAR_PIXELS = 12;
    static final Color LIGHT_GRAY = new Color(221, 219, 219);
    static final Color LIGHT_YELLOW = new Color(255, 255, 180);
    private boolean firstReset = false;

    protected DatePanel(Properties properties, boolean bl, ByClauseButtonPanel byClauseButtonPanel, boolean bl2, Date[] dateArray) {
        super(properties);
        this.singleSelection = bl2;
        this.dualMode = bl;
        this.noYearPanel = byClauseButtonPanel;
        this.applyLocale(Locale.getDefault());
        this.createPanel(dateArray);
    }

    public DatePanel(boolean bl, boolean bl2, Date[] dateArray) {
        this(null, bl, null, bl2, dateArray);
    }

    public DatePanel(ByClauseButtonPanel byClauseButtonPanel, boolean bl, Date[] dateArray) {
        this(null, byClauseButtonPanel != null, byClauseButtonPanel, bl, dateArray);
    }

    public DatePanel(Date[] dateArray) {
        this(null, false, false, dateArray);
    }

    public DatePanel(Properties properties, boolean bl, boolean bl2, Date[] dateArray) {
        this(properties, bl, null, bl2, dateArray);
    }

    public DatePanel(Properties properties, ByClauseButtonPanel byClauseButtonPanel, boolean bl, Date[] dateArray) {
        this(properties, byClauseButtonPanel != null, byClauseButtonPanel, bl, dateArray);
    }

    public DatePanel(Properties properties, Date[] dateArray) {
        this(properties, false, false, dateArray);
    }

    private void createPanel(Date[] dateArray) {
        this.initVal = dateArray;
        this.cal = Calendar.getInstance();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        int n = -1;
        this.dualLayout = new CardLayout();
        this.dualPanel = new JPanel(this.dualLayout);
        JPanel jPanel = this.createCalendarPanel();
        this.dualPanel.add((Component)jPanel, "YearsCard");
        gridBagConstraints.gridy = ++n;
        this.add((Component)this.dualPanel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        if (this.dualMode) {
            if (this.noYearPanel == null) {
                Properties properties = this.getProperties() != null ? this.getProperties() : new Properties();
                properties.setProperty("repeatinterval.component.ByClauseButtonPanel.hideActionButtons", "true");
                this.noYearPanel = new ByClauseButtonPanel(properties, 1, 31, 7, "BYDATE", this.months, Calendar.getInstance().get(2), "Month", dateArray);
            }
            this.noYearPanel.addActionListener(this);
            this.dualPanel.add((Component)this.noYearPanel, "NoYearsCard");
            this.years = new JCheckBox(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_YEARS_LONG"));
            this.years.setToolTipText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_YEARS_LONG_TOOLTIP"));
            this.years.setFont(this.years.getFont().deriveFont(10.0f));
            this.years.setActionCommand("Years");
            this.years.addActionListener(this);
            gridBagConstraints.gridy = ++n;
            this.add((Component)this.years, gridBagConstraints);
            gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        }
        if (!this.singleSelection) {
            this.clearAll = new JButton(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_CLEAR_ALL"));
            this.clearAll.setActionCommand("Clear");
            this.clearAll.setToolTipText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_CLEAR_ALL_TOOLTIP"));
            this.clearAll.setFont(this.clearAll.getFont().deriveFont(10.0f));
            this.clearAll.addActionListener(this);
            gridBagConstraints.gridy = ++n;
            this.add((Component)this.clearAll, gridBagConstraints);
            gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        }
        this.actionListeners = new EventListenerList();
        this.firstReset = true;
        this.reset();
        this.firstReset = false;
    }

    private JPanel createCalendarPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(LIGHT_GRAY);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.monthButton = new JComboBox();
        this.monthModel = new DefaultComboBoxModel<String>(this.months);
        this.monthButton.setModel(this.monthModel);
        this.monthButton.setToolTipText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_SELECT_MONTH_TOOLTIP"));
        this.monthButton.setFont(this.monthButton.getFont().deriveFont(10.0f));
        this.monthButton.setBackground(LIGHT_GRAY);
        this.monthButton.setActionCommand("month");
        this.monthButton.addActionListener(this);
        jPanel.add((Component)this.monthButton, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        this.yearButton = new JSpinner(this.yearModel);
        this.yearButton.setEditor(new JSpinner.NumberEditor(this.yearButton, "0000"));
        this.yearButton.setToolTipText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_SELECT_YEAR_TOOLTIP"));
        this.yearButton.setFont(this.yearButton.getFont().deriveFont(10.0f));
        this.yearButton.setBackground(LIGHT_GRAY);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.yearButton, gridBagConstraints);
        this.yearModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                DatePanel.this.dateHasChanged(false);
            }
        });
        gridBagConstraints.fill = 0;
        this.prevButton = new FlatButton((Icon)new ImageIcon(this.getClass().getResource("/oracle/dbtools/scheduler/images/Back16.gif")));
        this.prevButton.setToolTipText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_MONTH_BACK_TOOLTIP"));
        this.prevButton.setBackground(LIGHT_GRAY);
        this.prevButton.setRolloverBorder(BorderFactory.createRaisedBevelBorder());
        Dimension dimension = this.prevButton.getPreferredSize();
        Dimension dimension2 = new Dimension(dimension.width + 8, dimension.height + 8);
        this.prevButton.setPreferredSize(dimension2);
        this.prevButton.setMinimumSize(dimension2);
        this.prevButton.setMaximumSize(dimension2);
        this.prevButton.setActionCommand("back");
        this.prevButton.addActionListener((ActionListener)this);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.prevButton, gridBagConstraints);
        this.homeButton = new FlatButton((Icon)new ImageIcon(this.getClass().getResource("/oracle/dbtools/scheduler/images/Home16.gif")));
        this.homeButton.setToolTipText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_GO_TO_TODAY_TOOLTIP"));
        this.homeButton.setBackground(LIGHT_GRAY);
        this.homeButton.setRolloverBorder(BorderFactory.createRaisedBevelBorder());
        dimension = this.homeButton.getPreferredSize();
        dimension2 = new Dimension(dimension.width + 8, dimension.height + 8);
        this.homeButton.setPreferredSize(dimension2);
        this.homeButton.setMinimumSize(dimension2);
        this.homeButton.setMaximumSize(dimension2);
        this.homeButton.setActionCommand("today");
        this.homeButton.addActionListener((ActionListener)this);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.homeButton, gridBagConstraints);
        this.nextButton = new FlatButton((Icon)new ImageIcon(this.getClass().getResource("/oracle/dbtools/scheduler/images/Forward16.gif")));
        this.nextButton.setToolTipText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_MONTH_FORWARD_TOOLTIP"));
        this.nextButton.setBackground(LIGHT_GRAY);
        this.nextButton.setRolloverBorder(BorderFactory.createRaisedBevelBorder());
        dimension = this.nextButton.getPreferredSize();
        dimension2 = new Dimension(dimension.width + 8, dimension.height + 8);
        this.nextButton.setPreferredSize(dimension2);
        this.nextButton.setMinimumSize(dimension2);
        this.nextButton.setMaximumSize(dimension2);
        this.nextButton.setActionCommand("next");
        this.nextButton.addActionListener((ActionListener)this);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.nextButton, gridBagConstraints);
        this.createDaysPanel();
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.daysPanel, gridBagConstraints);
        return jPanel;
    }

    private void createDaysPanel() {
        Serializable serializable;
        this.daysPanel = new JPanel();
        this.daysPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        Map<String, Integer> map = Calendar.getInstance().getDisplayNames(7, 1, Locale.getDefault());
        String[] stringArray = new String[map.size()];
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            stringArray[entry.getValue().intValue() - 1] = entry.getKey();
        }
        int n = (this.cal.getFirstDayOfWeek() + 7 - 1) % 7;
        for (int i = 0; i < 7; ++i) {
            serializable = new JLabel(stringArray[(n + i) % 7], 0);
            ((JComponent)serializable).setFont(((Component)serializable).getFont().deriveFont(10.0f));
            ++gridBagConstraints.gridx;
            this.daysPanel.add((Component)serializable, gridBagConstraints);
        }
        FlatButton flatButton = new FlatButton("00");
        serializable = flatButton.getPreferredSize();
        Dimension dimension = new Dimension(((Dimension)serializable).width + 2, ((Dimension)serializable).height + 2);
        gridBagConstraints.gridx = -1;
        for (int i = 0; i < 42; ++i) {
            FlatButton flatButton2 = new FlatButton();
            flatButton2.setFont(flatButton2.getFont().deriveFont(9.0f));
            flatButton2.setPreferredSize(dimension);
            flatButton2.setMinimumSize(dimension);
            flatButton2.addActionListener((ActionListener)this);
            ++gridBagConstraints.gridx;
            if (gridBagConstraints.gridx % 7 == 0) {
                gridBagConstraints.gridx = 0;
                ++gridBagConstraints.gridy;
            }
            this.daysPanel.add((Component)flatButton2, gridBagConstraints);
        }
        this.selectedDates = new TreeSet();
    }

    protected void applyLocale(Locale locale) {
        this.locale = locale;
        Map<String, Integer> map = this.calender.getDisplayNames(2, 2, locale);
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            String string;
            this.months[entry.getValue().intValue()] = string = entry.getKey();
        }
    }

    private void adjustDaysPanel(int n, int n2) {
        FlatButton flatButton;
        int n3;
        this.cal.set(5, 1);
        int n4 = this.cal.getActualMaximum(5);
        int n5 = (this.cal.get(7) + 7 - this.cal.getFirstDayOfWeek()) % 7;
        Calendar calendar = (Calendar)this.cal.clone();
        calendar.add(2, -1);
        int n6 = calendar.getActualMaximum(5);
        for (int i = 0; i < n5; ++i) {
            FlatButton flatButton2 = (FlatButton)this.daysPanel.getComponent(i + 7);
            flatButton2.setText(Integer.toString(n6 - n5 + i + 1));
            flatButton2.setFont(flatButton2.getFont().deriveFont(0));
            flatButton2.setActionCommand("dayOfLastMonth");
            flatButton2.setSelected(false);
            flatButton2.setBackground(LIGHT_GRAY);
            this.paintButtonSelected(flatButton2, false);
        }
        Calendar calendar2 = Calendar.getInstance();
        for (n3 = 1; n3 <= n4; ++n3) {
            flatButton = (FlatButton)this.daysPanel.getComponent(n3 + 6 + n5);
            flatButton.setText(Integer.toString(n3));
            flatButton.setFont(flatButton.getFont().deriveFont(1));
            flatButton.setActionCommand("dayOfThisMonth");
            flatButton.setSelected(false);
            if (n3 == calendar2.get(5) && n == calendar2.get(2) && n2 == calendar2.get(1)) {
                flatButton.setBackground(LIGHT_YELLOW);
            } else {
                flatButton.setBackground(Color.WHITE);
            }
            this.paintButtonSelected(flatButton, false);
        }
        for (n3 = 1; n3 <= 42 - n4 - n5; ++n3) {
            flatButton = (FlatButton)this.daysPanel.getComponent(n3 + 6 + n5 + n4);
            flatButton.setText(Integer.toString(n3));
            flatButton.setFont(flatButton.getFont().deriveFont(0));
            flatButton.setActionCommand("dayOfNextMonth");
            flatButton.setSelected(false);
            flatButton.setBackground(LIGHT_GRAY);
            this.paintButtonSelected(flatButton, false);
        }
        if (this.selectedDates.size() > 0) {
            this.alreadySelected(n2, n, n5);
        }
        this.daysPanel.revalidate();
        this.daysPanel.repaint();
    }

    @Override
    public void reset() {
        if (this.dualMode) {
            if (!this.firstReset) {
                this.noYearPanel.reset();
            }
            this.years.setSelected(false);
            this.years.doClick();
        }
        this.cal = Calendar.getInstance();
        this.selectedDates.clear();
        if (this.initVal != null) {
            for (Date date : this.initVal) {
                this.checkInitValues(date);
            }
            if (this.selectedDates.size() > 0) {
                Date date = this.selectedDates.first();
                this.setCalendar(this.cal, date.getYear(), date.getMonth().ordinal() + 1, date.getDay());
            }
        }
        this.dateHasChanged(true);
        this.initVal = null;
    }

    private void checkInitValues(Date date) {
        if (date.getYear() != null) {
            this.selectedDates.add(date);
        }
    }

    private void dateHasChanged(boolean bl) {
        int n = 0;
        int n2 = 0;
        if (bl) {
            n = this.cal.get(1);
            this.yearModel.setValue(n);
            n2 = this.cal.get(2);
            this.monthModel.setSelectedItem(this.months[n2]);
        } else {
            try {
                n = this.yearModel.getNumber().intValue();
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            String string = (String)this.monthModel.getSelectedItem();
            for (int i = 0; i < 12; ++i) {
                if (!this.months[i].equals(string)) continue;
                n2 = i;
                break;
            }
            this.cal.set(n, n2, 1);
        }
        this.adjustDaysPanel(n2, n);
    }

    private void alreadySelected(int n, int n2, int n3) {
        try {
            int n4;
            int n5 = n4 = n3 > 0 && n2 == 0 ? n - 1 : n;
            int n6 = n3 > 0 ? (n2 == 0 ? 12 : n2) : n2 + 1;
            int n7 = Integer.parseInt(((FlatButton)this.daysPanel.getComponent(7)).getText());
            Date date = this.getDate(n4, n6, n7);
            int n8 = n2 == 11 ? n + 1 : n;
            int n9 = n2 == 11 ? 1 : n2 + 2;
            int n10 = Integer.parseInt(((FlatButton)this.daysPanel.getComponent(48)).getText());
            Date date2 = this.getDate(n8, n9, n10);
            Calendar calendar = null;
            Calendar calendar2 = null;
            int n11 = 0;
            for (Date date3 : this.selectedDates) {
                if (date3.compareTo(date2) > 0) break;
                if (date3.compareTo(date) < 0) continue;
                if (calendar2 == null) {
                    calendar2 = Calendar.getInstance();
                }
                this.setCalendar(calendar2, date3);
                if (calendar == null) {
                    calendar = Calendar.getInstance();
                    this.setCalendar(calendar, n4, n6, n7);
                }
                while (calendar.before(calendar2)) {
                    calendar.add(5, 1);
                    ++n11;
                }
                FlatButton flatButton = (FlatButton)this.daysPanel.getComponent(7 + n11);
                this.paintButtonSelected(flatButton, true);
                calendar.add(5, 1);
                ++n11;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected boolean setSelection(Date date) {
        return this.setSelection(date, (Boolean)true, false);
    }

    protected Date getDate(int n, int n2, int n3) {
        return new Date(n3, Month.values()[n2 - 1], n);
    }

    protected void setCalendar(Calendar calendar, Date date) {
        calendar.set(date.getYear(), date.getMonth().ordinal(), date.getDay());
    }

    protected void setCalendar(Calendar calendar, int n, int n2, int n3) {
        calendar.set(n, n2 - 1, n3);
    }

    protected boolean setSelection(Date date, Boolean bl, boolean bl2) {
        boolean bl3 = false;
        if (date != null) {
            int n;
            if (bl == null) {
                bl = this.selectedDates.contains(date);
            } else if (bl.booleanValue()) {
                this.selectedDates.add(date);
            } else {
                this.selectedDates.remove(date);
            }
            int n2 = this.cal.get(1);
            int n3 = this.cal.get(2);
            int n4 = (this.cal.get(7) + 7 - this.cal.getFirstDayOfWeek()) % 7;
            int n5 = n = n4 > 0 && n3 == 0 ? n2 - 1 : n2;
            int n6 = n4 > 0 ? (n3 == 0 ? 12 : n3) : n3 + 1;
            int n7 = Integer.parseInt(((FlatButton)this.daysPanel.getComponent(7)).getText());
            Date date2 = this.getDate(n, n6, n7);
            int n8 = n3 == 11 ? n2 + 1 : n2;
            int n9 = n3 == 11 ? 1 : n3 + 2;
            int n10 = Integer.parseInt(((FlatButton)this.daysPanel.getComponent(48)).getText());
            Date date3 = this.getDate(n8, n9, n10);
            Calendar calendar = null;
            Calendar calendar2 = null;
            int n11 = 0;
            if (date.compareTo(date3) <= 0 && date.compareTo(date2) >= 0) {
                if (calendar2 == null) {
                    calendar2 = Calendar.getInstance();
                }
                this.setCalendar(calendar2, date);
                if (calendar == null) {
                    calendar = Calendar.getInstance();
                    this.setCalendar(calendar, n, n6, n7);
                }
                while (calendar.before(calendar2)) {
                    calendar.add(5, 1);
                    ++n11;
                }
                FlatButton flatButton = (FlatButton)this.daysPanel.getComponent(7 + n11);
                if (bl2) {
                    this.paintButtonSelected(flatButton, bl);
                }
            }
        }
        return bl3;
    }

    protected boolean setSelection(Date[] dateArray) {
        return this.setSelection(dateArray, (Boolean)true, false);
    }

    protected boolean setSelection(Date[] dateArray, Boolean bl, boolean bl2) {
        Boolean bl3 = null;
        if (dateArray != null) {
            for (Date date : dateArray) {
                boolean bl4 = this.setSelection(date, bl, bl2);
                if (bl3 != null && !bl3.booleanValue()) continue;
                bl3 = bl4;
            }
        }
        return bl3 == null ? false : bl3;
    }

    protected void changeSelection(Date date, Boolean bl) {
        this.setSelection(date, bl, true);
    }

    protected void resetSelections(Date[] dateArray) {
        this.reset();
        for (int i = 0; i < dateArray.length; ++i) {
            this.changeSelection(dateArray[i], true);
        }
    }

    protected void resetSelections() {
        this.reset();
    }

    protected void paintButtonSelected(FlatButton flatButton, boolean bl) {
        Color color;
        Color color2 = flatButton.getForeground();
        Color color3 = color = bl ? Color.RED : Color.BLACK;
        if (color != color2) {
            flatButton.setForeground(color);
        }
    }

    protected boolean isPaintButtonSelected(FlatButton flatButton) {
        return flatButton.getForeground() == Color.RED;
    }

    protected Date getClauseElement(FlatButton flatButton, String string) {
        int n = 0;
        try {
            n = this.yearModel.getNumber().intValue();
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        int n2 = 0;
        for (int i = 0; i < 12; ++i) {
            if (!this.months[i].equals(this.monthModel.getSelectedItem())) continue;
            n2 = i;
            break;
        }
        if (string.equals("dayOfLastMonth")) {
            if (n2 == 0) {
                --n;
                n2 = 12;
            }
        } else if (string.equals("dayOfThisMonth")) {
            ++n2;
        } else if (string.equals("dayOfNextMonth")) {
            if (n2 == 11) {
                ++n;
                n2 = 1;
            } else {
                n2 += 2;
            }
        }
        return this.getDate(n, n2, Integer.parseInt(flatButton.getText()));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("month")) {
            this.dateHasChanged(false);
        } else if (string.equals("dayOfLastMonth") || string.equals("dayOfThisMonth") || string.equals("dayOfNextMonth")) {
            FlatButton flatButton = (FlatButton)actionEvent.getSource();
            Date date = this.getClauseElement(flatButton, string);
            if (date == null) {
                return;
            }
            if (this.isPaintButtonSelected(flatButton)) {
                this.selectedDates.remove(date);
                this.paintButtonSelected(flatButton, false);
            } else {
                if (this.singleSelection) {
                    if (this.selectedDates.size() > 0) {
                        this.selectedDates.clear();
                        for (int i = 7; i < 49; ++i) {
                            FlatButton flatButton2 = (FlatButton)this.daysPanel.getComponent(i);
                            this.paintButtonSelected(flatButton2, false);
                        }
                    }
                    this.selectedDates.add(date);
                } else {
                    boolean bl = this.selectedDates.add(date);
                    if (!bl) {
                        this.selectedDates.add(date);
                    }
                }
                this.paintButtonSelected(flatButton, true);
            }
            this.fireAction(new ActionEvent(this, 1001, "BYDATE"));
        } else if (string.equals("today")) {
            this.cal = Calendar.getInstance();
            this.dateHasChanged(true);
        } else if (string.equals("back")) {
            this.cal.add(2, -1);
            this.dateHasChanged(true);
        } else if (string.equals("next")) {
            this.cal.add(2, 1);
            this.dateHasChanged(true);
        } else if (string.equals("Clear")) {
            if (this.dualMode) {
                this.noYearPanel.reset();
            }
            this.selectedDates.clear();
            for (int i = 7; i < 49; ++i) {
                FlatButton flatButton = (FlatButton)this.daysPanel.getComponent(i);
                this.paintButtonSelected(flatButton, false);
            }
            this.fireAction(new ActionEvent(this, 1001, "BYDATE"));
        } else if (string.equals("Years")) {
            boolean bl = this.years.isSelected();
            this.dualLayout.show(this.dualPanel, bl ? "YearsCard" : "NoYearsCard");
        } else if (string.equals("BYDATE")) {
            this.fireAction(new ActionEvent(this, 1001, "BYDATE"));
        }
    }

    public void setYearsVisible(boolean bl) {
        this.dualLayout.show(this.dualPanel, bl ? "YearsCard" : "NoYearsCard");
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners.remove(ActionListener.class, actionListener);
    }

    protected void fireAction(ActionEvent actionEvent) {
        Object[] objectArray = this.actionListeners.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ActionListener.class) continue;
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
        }
    }
}

