/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval.clause;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.AbstractRepeatIntervalClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.AbstractScheduleClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.ClauseSyntaxHandler;
import oracle.dbtools.scheduler.panels.common.repeatinterval.component.ClausePanel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.component.PropertyBasedPanel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ClauseModel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ClauseType;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.CombinedSchedule;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.DateModifier;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ModifierType;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.NamedSchedule;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.OffsetModifier;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModelEvent;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModelListener;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ScheduleClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.SortedClauseModel;

public class CombinedScheduleClause
extends AbstractScheduleClause<CombinedSchedule, SortedClauseModel<CombinedSchedule>> {
    public CombinedScheduleClause(RepeatIntervalModel repeatIntervalModel) {
        this(CombinedSchedule.class, repeatIntervalModel);
    }

    protected CombinedScheduleClause(SortedClauseModel<CombinedSchedule> sortedClauseModel) {
        super(sortedClauseModel);
    }

    protected CombinedScheduleClause(Class<CombinedSchedule> clazz, RepeatIntervalModel repeatIntervalModel) {
        this(new SortedClauseModel<CombinedSchedule>(clazz, ClauseType.COMBINEDSCHED, repeatIntervalModel));
    }

    @Override
    public JPanel getPanel() {
        return this.getPanel(null);
    }

    @Override
    public JPanel getPanel(Properties properties) {
        return new Panel(properties);
    }

    @Override
    public ClauseSyntaxHandler getSyntaxHandler() {
        return new SyntaxHandler();
    }

    protected class SyntaxHandler
    extends AbstractRepeatIntervalClause.AbstractSyntaxHandler {
        protected SyntaxHandler() {
        }

        @Override
        public void initialise(String string) {
            if (string != null) {
                String[] stringArray;
                for (String string2 : stringArray = string.split(",")) {
                    string2 = string2.trim();
                    try {
                        ArrayList<DateModifier> arrayList = new ArrayList<DateModifier>();
                        string2 = CombinedScheduleClause.this.initialiseDateModifiers(string2, arrayList);
                        OffsetModifier offsetModifier = (OffsetModifier)DateModifier.getDataModifier(arrayList, ModifierType.OFFSET);
                        ((SortedClauseModel)CombinedScheduleClause.this.clauseModel).add(new CombinedSchedule(new ScheduleClause(new NamedSchedule(string2), offsetModifier)));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected class Panel
    extends PropertyBasedPanel
    implements ClausePanel<CombinedSchedule> {
        protected GridBagLayout gridBagLayout1;
        protected transient JComboBox combinedScheduleComboBox;
        protected transient ComboBoxModel combinedScheduleModel;
        protected JButton addButton;
        protected JButton removeButton;
        protected JButton clearButton;

        public Panel(Properties properties) {
            super(properties);
            this.gridBagLayout1 = new GridBagLayout();
            this.combinedScheduleComboBox = new JComboBox();
            this.addButton = new JButton();
            this.removeButton = new JButton();
            this.clearButton = new JButton();
            try {
                this.jbInit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ((SortedClauseModel)CombinedScheduleClause.this.clauseModel).addRepeatIntervalModelListener(new RepeatIntervalChangeListener());
        }

        protected void jbInit() throws Exception {
            this.setLayout(this.gridBagLayout1);
            NamedSchedule[] namedScheduleArray = CombinedScheduleClause.this.getRepeatIntervalModel().getNamedScheduleList();
            this.combinedScheduleModel = new DefaultComboBoxModel<NamedSchedule>(namedScheduleArray);
            this.combinedScheduleComboBox.setModel(this.combinedScheduleModel);
            this.combinedScheduleComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Panel.this.combinedScheduleComboBox_actionPerformed(actionEvent);
                }
            });
            this.addButton.setText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_ADD"));
            this.addButton.setActionCommand("Add");
            this.addButton.setToolTipText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_ADD_TOOLTIP"));
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Panel.this.addButton_actionPerformed(actionEvent);
                }
            });
            this.addButton.setMargin(new Insets(0, 0, 0, 0));
            this.removeButton.setText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_REMOVE"));
            this.removeButton.setActionCommand("Del");
            this.removeButton.setToolTipText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_REMOVE_TOOLTIP"));
            this.removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Panel.this.removeButton_actionPerformed(actionEvent);
                }
            });
            this.removeButton.setMargin(new Insets(0, 0, 0, 0));
            this.clearButton.setText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_CLEAR_ALL"));
            this.clearButton.setActionCommand("Clear");
            this.clearButton.setToolTipText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_CLEAR_ALL_TOOLTIP"));
            this.clearButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Panel.this.clearButton_actionPerformed(actionEvent);
                }
            });
            this.clearButton.setMargin(new Insets(0, 0, 0, 0));
            this.add((Component)this.combinedScheduleComboBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
            this.add((Component)this.addButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
            this.add((Component)this.removeButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
            this.add((Component)this.clearButton, new GridBagConstraints(3, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
            this.combinedScheduleComboBox.setSelectedItem(null);
        }

        protected void combinedScheduleComboBox_actionPerformed(ActionEvent actionEvent) {
            CombinedSchedule combinedSchedule = this.getSelectedClauseElement();
            if (combinedSchedule != null) {
                CombinedScheduleClause.this.getRepeatIntervalModel().setFreq(null);
            }
        }

        @Override
        public CombinedSchedule getSelectedClauseElement() {
            Object object = this.combinedScheduleComboBox.getSelectedItem();
            if (object != null) {
                return new CombinedSchedule(new ScheduleClause((NamedSchedule)object));
            }
            return null;
        }

        @Override
        public ClauseModel<CombinedSchedule> getClauseModel() {
            return CombinedScheduleClause.this.clauseModel;
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.combinedScheduleComboBox.setEnabled(bl);
            this.addButton.setEnabled(bl);
            this.removeButton.setEnabled(bl);
            this.clearButton.setEnabled(bl);
        }

        protected void addButton_actionPerformed(ActionEvent actionEvent) {
            CombinedSchedule combinedSchedule = this.getSelectedClauseElement();
            ((SortedClauseModel)CombinedScheduleClause.this.clauseModel).add(combinedSchedule);
        }

        protected void removeButton_actionPerformed(ActionEvent actionEvent) {
            CombinedSchedule combinedSchedule = this.getSelectedClauseElement();
            ((SortedClauseModel)CombinedScheduleClause.this.clauseModel).remove(combinedSchedule);
        }

        protected void clearButton_actionPerformed(ActionEvent actionEvent) {
            ((SortedClauseModel)CombinedScheduleClause.this.clauseModel).clear();
        }

        protected class RepeatIntervalChangeListener
        implements RepeatIntervalModelListener {
            protected RepeatIntervalChangeListener() {
            }

            @Override
            public void repeatIntervalChanged(RepeatIntervalModelEvent repeatIntervalModelEvent) {
                switch (repeatIntervalModelEvent.getClauseType()) {
                    case FREQ: {
                        Object object;
                        if (repeatIntervalModelEvent.getEventType() == RepeatIntervalModelEvent.EventType.PROPERTY_CHANGE || (object = repeatIntervalModelEvent.getNewValue()) == null) break;
                        Panel.this.combinedScheduleComboBox.setSelectedItem(null);
                    }
                }
            }
        }
    }
}

