/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval.clause;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.AbstractRepeatIntervalClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.AbstractClauseModel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.DateModifier;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.DurationUnit;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.DurationValue;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ModifierType;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.OffsetAnchor;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.OffsetModifier;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.SpanAnchor;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.SpanModifier;

public abstract class AbstractDateModifierClause<E, M extends AbstractClauseModel<E>>
extends AbstractRepeatIntervalClause<E, M> {
    protected static final String OFFSET_REGEX = "[+-](OFFSET:)?[1-9][0-9]*[WD]$";
    protected static final String SPAN_REGEX = "[+-^](SPAN:)[1-9][0-9]*[WD]$";

    protected DateModifier initialiseDateModifier(ModifierType modifierType, String string) {
        int n;
        Enum enum_ = null;
        DurationUnit durationUnit = null;
        Integer n2 = 0;
        switch (modifierType) {
            case SPAN: {
                if (string.startsWith("-")) {
                    enum_ = SpanAnchor.END;
                    break;
                }
                if (string.startsWith("^")) {
                    enum_ = SpanAnchor.MIDDLE;
                    break;
                }
                enum_ = SpanAnchor.START;
                break;
            }
            default: {
                enum_ = string.startsWith("-") ? OffsetAnchor.EARLIER : OffsetAnchor.LATER;
            }
        }
        durationUnit = string.endsWith("W") ? DurationUnit.W : DurationUnit.D;
        for (n = string.length() - 2; n > 0 && Character.isDigit(string.charAt(n)); --n) {
        }
        n2 = Integer.parseInt(string.substring(n + 1, string.length() - 1));
        switch (modifierType) {
            case SPAN: {
                return new SpanModifier((SpanAnchor)enum_, new DurationValue(durationUnit, n2));
            }
        }
        return new OffsetModifier((OffsetAnchor)enum_, new DurationValue(durationUnit, n2));
    }

    protected String initialiseDateModifiers(String string, List<DateModifier> list) {
        Pattern pattern = Pattern.compile(OFFSET_REGEX);
        Pattern pattern2 = Pattern.compile(SPAN_REGEX);
        if (string == null) {
            return null;
        }
        while (true) {
            String string2;
            DateModifier dateModifier = null;
            Matcher matcher = pattern2.matcher(string);
            if (matcher.find()) {
                string2 = string.substring(matcher.start(), matcher.end());
                dateModifier = this.initialiseDateModifier(ModifierType.SPAN, string2);
                if (dateModifier != null) {
                    list.add(0, dateModifier);
                }
                string = string.substring(0, string.length() - string2.length());
                continue;
            }
            matcher = pattern.matcher(string);
            if (matcher.find()) {
                string2 = string.substring(matcher.start(), matcher.end());
                dateModifier = this.initialiseDateModifier(ModifierType.OFFSET, string2);
                if (dateModifier != null) {
                    list.add(0, dateModifier);
                }
                string = string.substring(0, string.length() - string2.length());
                continue;
            }
            if (dateModifier == null) break;
        }
        return string;
    }

    public AbstractDateModifierClause(M m) {
        super(m);
    }
}

