/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.editors.graphical.xmlmodel;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineEdge;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineGraph;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineModel;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineNode;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineObject;
import oracle.dbtools.scheduler.editors.graphical.xmlmodel.XMLGraphEngineNode;
import oracle.ide.Context;

public class XMLGraphEngineGraph
extends XMLGraphEngineNode
implements GraphEngineGraph {
    private GraphEngineModel model;
    private List<Context> contexts = new Vector<Context>();
    private Map<String, GraphEngineEdge> edges = new HashMap<String, GraphEngineEdge>();

    public XMLGraphEngineGraph(GraphEngineModel graphEngineModel) {
        super(null);
        this.model = graphEngineModel;
    }

    @Override
    public GraphEngineModel getModel() {
        return this.model;
    }

    @Override
    public void clear() {
        for (GraphEngineEdge graphEngineObject : this.edges.values().toArray(new GraphEngineEdge[this.edges.size()])) {
            this.remove(graphEngineObject);
        }
        for (GraphEngineObject graphEngineObject : this.childNodes.values().toArray(new GraphEngineNode[this.childNodes.size()])) {
            this.remove((GraphEngineNode)graphEngineObject);
        }
        for (GraphEngineObject graphEngineObject : this.contexts.toArray(new Context[this.contexts.size()])) {
            this.removeContext((Context)graphEngineObject);
        }
    }

    @Override
    public void refresh() {
        System.out.println("Refresh called");
    }

    @Override
    public Collection<GraphEngineNode> getNodes() {
        return Collections.unmodifiableCollection(this.childNodes.values());
    }

    @Override
    public GraphEngineNode getNode(String string) {
        return this.getChildNode(string, true);
    }

    @Override
    public Collection<GraphEngineEdge> getEdges() {
        return Collections.unmodifiableCollection(this.edges.values());
    }

    @Override
    public Collection<GraphEngineEdge> getEdgesOutboundFrom(GraphEngineNode graphEngineNode) {
        Vector<GraphEngineEdge> vector = new Vector<GraphEngineEdge>();
        for (GraphEngineEdge graphEngineEdge : this.edges.values()) {
            if (graphEngineEdge == null || !graphEngineEdge.getSource().equals(graphEngineNode)) continue;
            vector.add(graphEngineEdge);
        }
        return vector;
    }

    @Override
    public Collection<GraphEngineEdge> getEdgesInboundTo(GraphEngineNode graphEngineNode) {
        Vector<GraphEngineEdge> vector = new Vector<GraphEngineEdge>();
        for (GraphEngineEdge graphEngineEdge : this.edges.values()) {
            if (graphEngineEdge == null || !graphEngineEdge.getTarget().equals(graphEngineNode)) continue;
            vector.add(graphEngineEdge);
        }
        return vector;
    }

    @Override
    public GraphEngineEdge getEdge(String string) {
        return this.edges.get(string);
    }

    @Override
    public void addContext(Context context) {
        if (!this.contexts.contains(context)) {
            List<Context> list = Collections.unmodifiableList(this.contexts);
            this.contexts.add(context);
            this.propertyChangeSupport.firePropertyChange("contextadded", list, this.contexts);
        }
    }

    @Override
    public void removeContext(Context context) {
        if (this.contexts.contains(context)) {
            List<Context> list = Collections.unmodifiableList(this.contexts);
            this.contexts.remove(context);
            this.propertyChangeSupport.firePropertyChange("contextremoved", list, this.contexts);
        }
    }

    public List<Context> getContexts() {
        return this.contexts;
    }

    @Override
    public final GraphEngineGraph getGraph() {
        return this;
    }

    @Override
    public boolean add(GraphEngineEdge graphEngineEdge) {
        boolean bl = false;
        if (graphEngineEdge != null && !this.edges.containsKey(graphEngineEdge.getId())) {
            Map<String, GraphEngineEdge> map = Collections.unmodifiableMap(this.edges);
            this.edges.put(graphEngineEdge.getId(), graphEngineEdge);
            this.propertyChangeSupport.firePropertyChange("edgeAdded", map, graphEngineEdge);
            bl = true;
        }
        return bl;
    }

    @Override
    public void remove(GraphEngineEdge graphEngineEdge) {
        if (graphEngineEdge != null && this.edges.containsKey(graphEngineEdge.getId())) {
            Map<String, GraphEngineEdge> map = Collections.unmodifiableMap(this.edges);
            this.edges.remove(graphEngineEdge.getId());
            this.propertyChangeSupport.firePropertyChange("edgeRemoved", map, graphEngineEdge);
        }
    }
}

