/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.editors.graphical.xmlmodel;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.raptor.query.Column;
import oracle.dbtools.raptor.query.ObjectQueries;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineEdge;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineEdgeGenerator;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineEdgeType;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineGraph;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineModel;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineNode;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineNodeGenerator;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineObject;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineResultSetValueProcessor;
import oracle.dbtools.scheduler.editors.graphical.xmlmodel.XMLGraphEngineDefinitions;
import oracle.dbtools.scheduler.editors.graphical.xmlmodel.XMLGraphEngineGenerator;
import oracle.dbtools.scheduler.editors.graphical.xmlmodel.XMLGraphEngineUtils;

public class XMLGraphEngineEdgeGenerator
extends XMLGraphEngineGenerator
implements GraphEngineEdgeGenerator {
    GraphEngineResultSetValueProcessor columnNameValueProcessor;
    GraphEngineEdgeType edgeType;
    ObjectQueries inboundQueries;

    public XMLGraphEngineEdgeGenerator(XMLGraphEngineDefinitions xMLGraphEngineDefinitions) {
        super(xMLGraphEngineDefinitions);
    }

    public void setInboundQueries(ObjectQueries objectQueries) {
        ObjectQueries objectQueries2 = this.inboundQueries;
        this.inboundQueries = objectQueries;
        this.propertyChangeSupport.firePropertyChange("inboundqueries", objectQueries2, objectQueries);
    }

    public ObjectQueries getInboundQueries() {
        return this.inboundQueries;
    }

    public void setOutboundQueries(ObjectQueries objectQueries) {
        ObjectQueries objectQueries2 = this.getOutboundQueries();
        this.setQueries(objectQueries);
        this.propertyChangeSupport.firePropertyChange("outboundqueries", objectQueries2, objectQueries);
    }

    public ObjectQueries getOutboundQueries() {
        return this.getQueries();
    }

    public void setEdgeType(GraphEngineEdgeType graphEngineEdgeType) {
        GraphEngineEdgeType graphEngineEdgeType2 = this.edgeType;
        this.edgeType = graphEngineEdgeType;
        this.propertyChangeSupport.firePropertyChange("EdgeType", graphEngineEdgeType2, graphEngineEdgeType);
    }

    @Override
    public GraphEngineEdgeType getEdgeType() {
        return this.edgeType;
    }

    @Override
    public String getSourceType() {
        return this.getEdgeType().getSourceType();
    }

    @Override
    public String getTargetType() {
        return this.getEdgeType().getTargetType();
    }

    @Override
    public boolean isGeneratorForTarget(String string) {
        return string == null ? false : this.getTargetType().equals(string);
    }

    @Override
    public boolean isGeneratorForSource(String string) {
        return string == null ? false : this.getSourceType().equals(string);
    }

    private String[] getColumnNames() {
        ColumnEnum[] columnEnumArray = ColumnEnum.values();
        String[] stringArray = new String[columnEnumArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = columnEnumArray[i].getColumnName();
        }
        return stringArray;
    }

    private String nodeId(String string, String string2, String string3) {
        if (string != null) {
            return string;
        }
        if (string2 != null) {
            return string2 + "." + string3;
        }
        return this.path(string2, string3);
    }

    private String path(String string, String string2) {
        if (string != null) {
            return string + "." + string2;
        }
        return string2;
    }

    private String getColumnValue(ResultSet resultSet, String string) throws SQLException {
        if (this.columnNameValueProcessor != null) {
            Object object = this.columnNameValueProcessor.getColumnValue(resultSet, string);
            if (object != null) {
                return object.toString();
            }
        } else {
            return resultSet.getString(string);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<GraphEngineObject> generateEdges(ObjectQueries objectQueries, Map<String, Object> map, boolean bl) {
        Vector<GraphEngineObject> vector = new Vector<GraphEngineObject>();
        GraphEngineModel graphEngineModel = this.getDefinitions().getModel();
        Connection connection = graphEngineModel.getConnection();
        String string = graphEngineModel.getConnectionName();
        if (connection == null) {
            return vector;
        }
        Query query = objectQueries.getQuery(DefaultConnectionIdentifier.createIdentifier((Connection)connection));
        if (query == null) return vector;
        String string2 = query.getSql();
        if (!Connections.getInstance().lock(connection)) return vector;
        try {
            DBUtil dBUtil = DBUtil.getInstance((String)string);
            ResultSet resultSet = dBUtil.executeQuery(string2, map);
            if (resultSet == null) return vector;
            try {
                Object object;
                List list = query.getCols();
                String[] stringArray = this.getColumnNames();
                if (list != null) {
                    for (Column column : list) {
                        try {
                            object = ColumnEnum.valueOf(column.getID());
                            stringArray[object.ordinal()] = column.getName();
                        }
                        catch (Throwable throwable) {}
                    }
                }
                String[] stringArray2 = new String[stringArray.length];
                while (resultSet.next()) {
                    List<GraphEngineObject> list2;
                    List<GraphEngineNodeGenerator> list3;
                    HashMap<String, Object> hashMap;
                    Object object2;
                    Point2D point2D;
                    Column column;
                    column = ColumnEnum.values();
                    for (int i = 0; i < ((Column)column).length; ++i) {
                        try {
                            if (stringArray[i] != null) {
                                stringArray2[i] = this.getColumnValue(resultSet, stringArray[i]);
                                continue;
                            }
                            stringArray2[i] = null;
                            continue;
                        }
                        catch (Exception exception) {
                            stringArray2[i] = null;
                        }
                    }
                    object = this.nodeId(stringArray2[ColumnEnum.SRCID.ordinal()], stringArray2[ColumnEnum.SRCOWNER.ordinal()], stringArray2[ColumnEnum.SRCNAME.ordinal()]);
                    String string3 = this.nodeId(stringArray2[ColumnEnum.TGTID.ordinal()], stringArray2[ColumnEnum.TGTOWNER.ordinal()], stringArray2[ColumnEnum.TGTNAME.ordinal()]);
                    GraphEngineGraph graphEngineGraph = this.getDefinitions().getModel().getGraph();
                    GraphEngineNode graphEngineNode = graphEngineGraph.getNode((String)object);
                    GraphEngineNode graphEngineNode2 = graphEngineGraph.getNode(string3);
                    Point2D point2D2 = point2D = graphEngineNode == null ? null : graphEngineNode.getLocation();
                    if (point2D == null) {
                        Point2D point2D3 = point2D = graphEngineNode2 == null ? null : graphEngineNode2.getLocation();
                    }
                    if (point2D == null) {
                        point2D = new Point();
                    }
                    if (graphEngineNode == null && bl && this.getEdgeType().isLoadSource()) {
                        object2 = null;
                        object2 = XMLGraphEngineUtils.getDatabaseNode(string, this.getSourceType(), stringArray2[ColumnEnum.SRCOWNER.ordinal()], stringArray2[ColumnEnum.SRCNAME.ordinal()]);
                        hashMap = new HashMap<String, Object>();
                        hashMap.put("owner", stringArray2[ColumnEnum.SRCOWNER.ordinal()]);
                        hashMap.put("objectName", stringArray2[ColumnEnum.SRCNAME.ordinal()]);
                        hashMap.put("element", object2);
                        hashMap.put("objType", this.getSourceType());
                        hashMap.put("name", stringArray2[ColumnEnum.SRCNAME.ordinal()]);
                        hashMap.put("location", point2D);
                        list3 = this.getDefinitions().getNodeGeneratorsFor(this.getSourceType());
                        for (GraphEngineNodeGenerator graphEngineNodeGenerator : list3) {
                            point2D.setLocation(point2D.getX() + 32.0, point2D.getY() + 32.0);
                            list2 = graphEngineNodeGenerator.generate(hashMap);
                            vector.addAll(list2);
                        }
                        graphEngineNode = graphEngineGraph.getNode((String)object);
                    }
                    if (graphEngineNode2 == null && bl && this.getEdgeType().isLoadTarget()) {
                        object2 = null;
                        object2 = XMLGraphEngineUtils.getDatabaseNode(string, this.getTargetType(), stringArray2[ColumnEnum.TGTOWNER.ordinal()], stringArray2[ColumnEnum.TGTNAME.ordinal()]);
                        hashMap = new HashMap();
                        hashMap.put("owner", stringArray2[ColumnEnum.TGTOWNER.ordinal()]);
                        hashMap.put("objectName", stringArray2[ColumnEnum.TGTNAME.ordinal()]);
                        hashMap.put("element", object2);
                        hashMap.put("objType", this.getTargetType());
                        hashMap.put("name", stringArray2[ColumnEnum.TGTNAME.ordinal()]);
                        hashMap.put("location", point2D);
                        list3 = this.getDefinitions().getNodeGeneratorsFor(this.getTargetType());
                        for (GraphEngineNodeGenerator graphEngineNodeGenerator : list3) {
                            point2D.setLocation(point2D.getX() + 32.0, point2D.getY() + 32.0);
                            list2 = graphEngineNodeGenerator.generate(hashMap);
                            vector.addAll(list2);
                        }
                        graphEngineNode2 = graphEngineGraph.getNode(string3);
                    }
                    if (graphEngineNode == null || graphEngineNode2 == null) continue;
                    if (stringArray2[ColumnEnum.EDGETYPE.ordinal()] == null) {
                        stringArray2[ColumnEnum.EDGETYPE.ordinal()] = this.getObjectType();
                    }
                    if (!graphEngineGraph.add((GraphEngineEdge)(object2 = XMLGraphEngineUtils.createEdge(graphEngineGraph, graphEngineGraph, stringArray2[ColumnEnum.EDGETYPE.ordinal()], stringArray2[ColumnEnum.EDGEID.ordinal()], stringArray2[ColumnEnum.DIRECTED.ordinal()] == null ? false : stringArray2[ColumnEnum.DIRECTED.ordinal()].equalsIgnoreCase("true"), stringArray2[ColumnEnum.LABEL.ordinal()], stringArray2[ColumnEnum.TOOLTIP.ordinal()], graphEngineNode, graphEngineNode2)))) continue;
                    vector.add((GraphEngineObject)object2);
                }
                return vector;
            }
            catch (SQLException sQLException) {
                return vector;
            }
            finally {
                DBUtil.closeResultSet((ResultSet)resultSet);
            }
        }
        finally {
            Connections.getInstance().unlock(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GraphEngineObject> generateInboundTo(GraphEngineNode graphEngineNode) {
        boolean bl = this.getDefinitions().isGeneratingEdges();
        try {
            ObjectQueries objectQueries = this.getInboundQueries();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("TGT_OWNER", graphEngineNode.getOwner());
            hashMap.put("TGT_OBJECT_NAME", graphEngineNode.getName());
            List<GraphEngineObject> list = this.generateEdges(objectQueries, hashMap, !bl);
            return list;
        }
        finally {
            this.getDefinitions().setGeneratingEdges(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GraphEngineObject> generateOutboundFrom(GraphEngineNode graphEngineNode) {
        boolean bl = this.getDefinitions().isGeneratingEdges();
        try {
            ObjectQueries objectQueries = this.getOutboundQueries();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("SRC_OWNER", graphEngineNode.getOwner());
            hashMap.put("SRC_OBJECT_NAME", graphEngineNode.getName());
            List<GraphEngineObject> list = this.generateEdges(objectQueries, hashMap, !bl);
            return list;
        }
        finally {
            this.getDefinitions().setGeneratingEdges(bl);
        }
    }

    public void setColumnNameValueProcessor(GraphEngineResultSetValueProcessor graphEngineResultSetValueProcessor) {
        GraphEngineResultSetValueProcessor graphEngineResultSetValueProcessor2 = this.columnNameValueProcessor;
        this.columnNameValueProcessor = graphEngineResultSetValueProcessor;
        this.propertyChangeSupport.firePropertyChange("columnNameValueProcessor", graphEngineResultSetValueProcessor2, graphEngineResultSetValueProcessor);
    }

    public GraphEngineResultSetValueProcessor getColumnNameValueProcessor() {
        return this.columnNameValueProcessor;
    }

    private static enum ColumnEnum {
        EDGETYPE(true),
        EDGEID(true),
        DIRECTED(true),
        LABEL(true),
        SRCID,
        SRCOWNER,
        SRCNAME,
        TGTID,
        TGTOWNER,
        TGTNAME,
        TOOLTIP;

        boolean defNull;

        private ColumnEnum() {
            this.defNull = false;
        }

        private ColumnEnum(boolean bl) {
            this.defNull = bl;
        }

        public String getColumnName() {
            if (this.defNull) {
                return null;
            }
            return this.name();
        }
    }
}

