/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.editors.graphical.xmlmodel;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineDefinitions;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineEdgeGenerator;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineEdgeType;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineModel;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineNodeGenerator;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineNodeType;

public class XMLGraphEngineDefinitions
implements GraphEngineDefinitions {
    private Object layout;
    private GraphEngineModel model;
    private GraphEngineNodeType rootDefinition;
    private Map<String, GraphEngineNodeType> nodeDefinitions = new TreeMap<String, GraphEngineNodeType>();
    private Map<String, GraphEngineEdgeType> edgeDefinitions = new TreeMap<String, GraphEngineEdgeType>();
    private List<GraphEngineNodeGenerator> nodeGenerators = new Vector<GraphEngineNodeGenerator>();
    private List<GraphEngineEdgeGenerator> edgeGenerators = new Vector<GraphEngineEdgeGenerator>();
    private boolean generatingEdges;
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public XMLGraphEngineDefinitions(GraphEngineModel graphEngineModel) {
        this.model = graphEngineModel;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void setLayout(Object object) {
        Object object2 = this.layout;
        this.layout = object;
        this.propertyChangeSupport.firePropertyChange("layout", object2, object);
    }

    @Override
    public Object getLayout() {
        return this.layout;
    }

    public void addNodeType(GraphEngineNodeType graphEngineNodeType) {
        this.nodeDefinitions.put(graphEngineNodeType.getTypeId(), graphEngineNodeType);
        this.propertyChangeSupport.firePropertyChange("nodeTypeAdded", this.nodeDefinitions, this.nodeDefinitions);
    }

    public void setRootDefinition(GraphEngineNodeType graphEngineNodeType) {
        this.rootDefinition = graphEngineNodeType;
    }

    @Override
    public GraphEngineNodeType getRootDefinition() {
        return this.rootDefinition;
    }

    @Override
    public Map<String, GraphEngineNodeType> getNodeDefinitions() {
        return Collections.unmodifiableMap(this.nodeDefinitions);
    }

    @Override
    public GraphEngineNodeType getNodeDefinition(String string) {
        return this.nodeDefinitions.get(string);
    }

    public void addEdgeType(GraphEngineEdgeType graphEngineEdgeType) {
        this.edgeDefinitions.put(graphEngineEdgeType.getTypeId(), graphEngineEdgeType);
        this.propertyChangeSupport.firePropertyChange("edgeTypeAdded", this.edgeDefinitions, graphEngineEdgeType);
    }

    @Override
    public Map<String, GraphEngineEdgeType> getEdgeDefinitions() {
        return Collections.unmodifiableMap(this.edgeDefinitions);
    }

    @Override
    public GraphEngineEdgeType getEdgeDefinition(String string) {
        return this.edgeDefinitions.get(string);
    }

    public void addNodeGenerator(GraphEngineNodeGenerator graphEngineNodeGenerator) {
        if (graphEngineNodeGenerator != null && !this.nodeGenerators.contains(graphEngineNodeGenerator)) {
            List<GraphEngineNodeGenerator> list = Collections.unmodifiableList(this.nodeGenerators);
            this.nodeGenerators.add(graphEngineNodeGenerator);
            this.propertyChangeSupport.firePropertyChange("nodegeneratoradded", list, this.nodeGenerators);
        }
    }

    @Override
    public List<GraphEngineNodeGenerator> getNodeGenerators() {
        return Collections.unmodifiableList(this.nodeGenerators);
    }

    @Override
    public List<GraphEngineNodeGenerator> getNodeGeneratorsFor(String string) {
        Vector<GraphEngineNodeGenerator> vector = new Vector<GraphEngineNodeGenerator>();
        for (GraphEngineNodeGenerator graphEngineNodeGenerator : this.nodeGenerators) {
            if (!graphEngineNodeGenerator.isGeneratorFor(string)) continue;
            vector.add(graphEngineNodeGenerator);
        }
        return Collections.unmodifiableList(vector);
    }

    public void addEdgeGenerator(GraphEngineEdgeGenerator graphEngineEdgeGenerator) {
        if (graphEngineEdgeGenerator != null && !this.edgeGenerators.contains(graphEngineEdgeGenerator)) {
            List<GraphEngineEdgeGenerator> list = Collections.unmodifiableList(this.edgeGenerators);
            this.edgeGenerators.add(graphEngineEdgeGenerator);
            this.propertyChangeSupport.firePropertyChange("edgegeneratoradded", list, this.edgeGenerators);
        }
    }

    @Override
    public List<GraphEngineEdgeGenerator> getEdgeGenerators() {
        return Collections.unmodifiableList(this.edgeGenerators);
    }

    @Override
    public List<GraphEngineEdgeGenerator> getEdgeGeneratorsFor(String string) {
        Vector<GraphEngineEdgeGenerator> vector = new Vector<GraphEngineEdgeGenerator>();
        for (GraphEngineEdgeGenerator graphEngineEdgeGenerator : this.edgeGenerators) {
            if (!graphEngineEdgeGenerator.isGeneratorFor(string)) continue;
            vector.add(graphEngineEdgeGenerator);
        }
        return vector;
    }

    @Override
    public List<GraphEngineEdgeGenerator> getEdgeGeneratorsOutboundFrom(String string) {
        Vector<GraphEngineEdgeGenerator> vector = new Vector<GraphEngineEdgeGenerator>();
        for (GraphEngineEdgeGenerator graphEngineEdgeGenerator : this.edgeGenerators) {
            if (!graphEngineEdgeGenerator.isGeneratorForSource(string)) continue;
            vector.add(graphEngineEdgeGenerator);
        }
        return vector;
    }

    @Override
    public List<GraphEngineEdgeGenerator> getEdgeGeneratorsInboundTo(String string) {
        Vector<GraphEngineEdgeGenerator> vector = new Vector<GraphEngineEdgeGenerator>();
        for (GraphEngineEdgeGenerator graphEngineEdgeGenerator : this.edgeGenerators) {
            if (!graphEngineEdgeGenerator.isGeneratorForTarget(string)) continue;
            vector.add(graphEngineEdgeGenerator);
        }
        return vector;
    }

    @Override
    public GraphEngineModel getModel() {
        return this.model;
    }

    @Override
    public void setGeneratingEdges(boolean bl) {
        this.generatingEdges = bl;
    }

    @Override
    public boolean isGeneratingEdges() {
        return this.generatingEdges;
    }
}

