/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.editors.chain;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ListCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.CompletionTextAction;
import oracle.dbtools.raptor.ui.controls.NameBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.scheduler.editors.chain.ChainGraphModel;
import oracle.dbtools.scheduler.editors.chain.Messages;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;
import oracle.dbtools.scheduler.panels.common.ObjectNameValidator;
import oracle.javatools.controls.completionfield.FieldInsightProvider;
import oracle.javatools.ui.search.SearchMatcher;

public class ChainRuleCreateAction
extends ActionDialog {
    private static final String SCHEMA = "schema";
    private static final String SOURCE_STEP = "Source Step";
    private static final String CHAIN_NAME = "Chain Name";
    private static final String PROGRAM = "Program";
    private static final String TARGET_STEP = "Target Step";
    private static final String CONDITION = "Condition";
    private static final String ACTION = "Action";
    private static final String RULE_NAME = "Rule Name";
    private static final String COMMENTS = "Comments";
    private String chain_name;
    private String targetStep = null;
    private String sourceStep = null;
    private boolean isStartRule = false;
    private boolean isEndRule = false;
    private String owner;

    public ChainRuleCreateAction() {
        ObjectAction objectAction = new ObjectAction();
        objectAction.setReloadParent(false);
        objectAction.setReload(true);
        this.setObjectAction(objectAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        DBUtil dBUtil;
        TextBoxActionControl textBoxActionControl;
        Object object;
        String string = this.chain_name;
        if (Connections.getInstance().lock(connection)) {
            block5: {
                object = null;
                try {
                    textBoxActionControl = new HashMap();
                    textBoxActionControl.put("CHAIN_NAME", string);
                    dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    object = dBUtil.executeOracleQuery(this.getQuery(connection, "getChainOwner"), textBoxActionControl);
                    if (object == null || !object.next()) break block5;
                    this.owner = object.getString("owner");
                }
                catch (Exception exception) {
                    try {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(object);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                    DBUtil.closeResultSet((ResultSet)object);
                    Connections.getInstance().unlock(connection);
                }
            }
            DBUtil.closeResultSet((ResultSet)object);
            Connections.getInstance().unlock(connection);
        }
        object = new SqlComboBoxActionControl(SCHEMA, Messages.getString("ChainRuleCreateAction.9"), connection, this.getQuery(connection, "getUsers"), null, this.owner);
        object.setEditable(false);
        textBoxActionControl = new TextBoxActionControl(CHAIN_NAME, Messages.getString("ChainRuleCreateAction.11"), this.chain_name);
        textBoxActionControl.setEditable(false);
        dBUtil = new NameBoxActionControl(RULE_NAME, Messages.getString("ChainRuleCreateAction.14"), null);
        CompletionTextAction completionTextAction = null;
        completionTextAction = new CompletionTextAction(CONDITION, Messages.getString("ChainRuleCreateAction.15"), (String)(this.isStartRule ? "TRUE" : (this.sourceStep == null ? "" : "\"" + this.sourceStep + "\" COMPLETED")), new FieldInsightProvider(){
            private Logger logger = Logger.getLogger(this.getClass().getName());
            private DefaultListCellRenderer _renderer;

            public void completeInsight(Document document, int n, Object object) {
                try {
                    String string = document.getText(0, n);
                    if (string.length() > 0 && string.lastIndexOf(" ") > 0) {
                        if (Character.isWhitespace(string.charAt(string.length() - 1))) {
                            document.insertString(n, (String)object, null);
                        } else if (n - 1 > -1) {
                            document.remove(string.lastIndexOf(" ") + 1, document.getLength() - string.lastIndexOf(" ") - 1);
                            document.insertString(string.lastIndexOf(" ") + 1, (String)object, null);
                        }
                    } else {
                        document.remove(0, document.getLength());
                        document.insertString(0, (String)object, null);
                    }
                }
                catch (BadLocationException badLocationException) {
                    this.logger.log(Level.WARNING, "", badLocationException);
                }
            }

            public ListCellRenderer getCellRenderer() {
                if (this._renderer == null) {
                    this._renderer = new DefaultListCellRenderer();
                }
                return this._renderer;
            }

            public Object[] getInsightData(Document document, int n) {
                ArrayList<String> arrayList = new ArrayList<String>();
                try {
                    String string = document.getText(0, n);
                    List<String> list = Arrays.asList(ChainGraphModel.getReservedWords());
                    if (list != null) {
                        for (String string2 : list) {
                            SearchMatcher searchMatcher;
                            if (string.length() == 0 || Character.isWhitespace(string.charAt(string.length() - 1))) {
                                SearchMatcher searchMatcher2 = SearchMatcher.getPrefixMatcher((CharSequence)string, (boolean)true, (boolean)true);
                                if (searchMatcher2.matches((CharSequence)string2)) {
                                    arrayList.add(0, string2);
                                    continue;
                                }
                                arrayList.add(string2);
                                continue;
                            }
                            int n2 = 0;
                            if (string.lastIndexOf(" ") > 0 && string.lastIndexOf(" ") < string.length()) {
                                n2 = string.lastIndexOf(" ");
                            }
                            if (!(searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string.substring(n2 + 1, string.length()), (boolean)true)).matches((CharSequence)string2)) continue;
                            arrayList.add(string2);
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    this.logger.log(Level.WARNING, "", badLocationException);
                }
                return arrayList.toArray();
            }

            public boolean handlesInsight(Document document, int n) {
                return true;
            }

            public boolean isAutoPopupChar(char c) {
                return true;
            }
        });
        TextBoxActionControl textBoxActionControl2 = new TextBoxActionControl(ACTION, Messages.getString("ChainRuleCreateAction.16"), (String)(this.isEndRule ? this.targetStep : "START " + (String)(this.targetStep != null ? "\"" + this.targetStep + "\"" : "")));
        TextBoxActionControl textBoxActionControl3 = new TextBoxActionControl(COMMENTS, Messages.getString("ChainRuleCreateAction.20"), null);
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add((ActionControl)dBUtil);
        arrayList.add((ActionControl)completionTextAction);
        arrayList.add((ActionControl)textBoxActionControl2);
        arrayList.add((ActionControl)textBoxActionControl3);
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        String string;
        String string2 = this.getDBObject().getDBVersion();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        try {
            string = this.getDBObjectSchemaName();
            if (string == null) {
                string = this.getDBObject().getSchemaName();
            }
        }
        catch (Exception exception) {
            string = null;
        }
        String string3 = values.get(RULE_NAME);
        string3 = ObjectNameValidator.validateName(string3);
        String string4 = values.get(CHAIN_NAME);
        String string5 = values.get(CONDITION);
        String string6 = values.get(ACTION);
        String string7 = values.get(COMMENTS);
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string3 != null && string3.length() == 0) {
            string3 = null;
        }
        if (string4 != null && string4.length() == 0) {
            string4 = null;
        }
        if (string5 != null && string5.length() == 0) {
            string5 = null;
        }
        if (string6 != null && string6.length() == 0) {
            string6 = null;
        }
        if (string7 != null && string7.length() == 0) {
            string7 = null;
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put(SCHEMA, string);
        treeMap.put("rule_name", string3);
        treeMap.put("condition", string5);
        treeMap.put("chain_name", string4);
        treeMap.put("action", string6);
        treeMap.put("comments", string7);
        TreeMap<String, Object> treeMap2 = new TreeMap<String, Object>();
        treeMap2.put("model", treeMap);
        String string8 = null;
        string8 = dBMSSchedulerCodeGenerator.generate(string2, "CHAIN_CREATE_RULE", treeMap2);
        return string8;
    }

    protected String getTitle() {
        return Messages.getString("ChainRuleCreateAction.28");
    }

    public void setChainName(String string) {
        this.chain_name = string;
    }

    public void setSourceStep(String string) {
        this.sourceStep = string;
    }

    public void setTargetStep(String string) {
        this.targetStep = string;
    }

    public void setIsStartRule(boolean bl) {
        this.isStartRule = bl;
    }

    void setIsEndRule(boolean bl) {
        this.isEndRule = bl;
    }

    protected boolean isCloseOnError() {
        return false;
    }
}

