/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.wiz;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.wiz.GITBranchTag;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.SearchCriteria;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITPushCommitPanel
extends DefaultTraversablePanel {
    private JMultiLineLabel _hintText = new JMultiLineLabel();
    private JTree _tree = new JTree(new DefaultMutableTreeNode("Commits"), true);

    public GITPushCommitPanel() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEntry(TraversableContext dataContext) {
        if (dataContext.getDirection() == 1) {
            GitClient client = null;
            try {
                Collection branches = (Collection)dataContext.get("git.use-branches");
                URL localRootUrl = (URL)dataContext.get("git.local-url");
                client = GITClientAdaptor.getClient(localRootUrl);
                GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("branches");
                Map mapBranches = client.getBranches(false, (ProgressMonitor)monitor);
                DefaultMutableTreeNode root = (DefaultMutableTreeNode)this._tree.getModel().getRoot();
                this.removeNodesForCommits(branches);
                for (GITBranchTag branch : branches) {
                    if (this.treeContains(branch)) continue;
                    DefaultMutableTreeNode brNode = new DefaultMutableTreeNode(new BranchNode(branch), true);
                    ((DefaultTreeModel)this._tree.getModel()).insertNodeInto(brNode, root, root.getChildCount());
                    GitBranch gBranch = (GitBranch)mapBranches.get(branch.getLocal());
                    if (gBranch != null && gBranch.getTrackedBranch() != null) {
                        GitRevisionInfo[] infos;
                        for (GitRevisionInfo info : infos = this.getCommitsFor(client, localRootUrl, gBranch.getTrackedBranch().getName(), branch.getLocal())) {
                            DefaultMutableTreeNode cNode = new DefaultMutableTreeNode(new CommitNode(info), true);
                            ((DefaultTreeModel)this._tree.getModel()).insertNodeInto(cNode, brNode, brNode.getChildCount());
                            DefaultMutableTreeNode lNode = new DefaultMutableTreeNode(new LoadingNode(), false);
                            ((DefaultTreeModel)this._tree.getModel()).insertNodeInto(lNode, cNode, cNode.getChildCount());
                        }
                        continue;
                    }
                    DefaultMutableTreeNode noBranchNode = new DefaultMutableTreeNode(new NoTrackingBranchNode(), false);
                    ((DefaultTreeModel)this._tree.getModel()).insertNodeInto(noBranchNode, brNode, brNode.getChildCount());
                }
            }
            catch (GitException e) {
                MessageDialog.error((Component)((Object)this), (Object)Resource.get("ERROR_COMMIT_MSG"), (String)Resource.get("ERROR_PUSH_COMMIT"), null);
                GITProfile.getQualifiedLogger(GITPushCommitPanel.class.getName()).log(Level.WARNING, "Push commits " + e.getMessage());
            }
            finally {
                if (client != null) {
                    client.release();
                }
            }
        }
    }

    private GitRevisionInfo[] getCommitsFor(GitClient client, URL localRootUrl, String remoteName, String branchName) throws GitException, GitException.MissingObjectException {
        ArrayList<GitRevisionInfo> listInfo = new ArrayList<GitRevisionInfo>();
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("log");
        SearchCriteria sc = new SearchCriteria();
        sc.setRevisionTo(branchName);
        if (remoteName != null) {
            sc.setRevisionFrom(remoteName);
        }
        sc.setFollowRenames(true);
        sc.setIncludeMerges(true);
        sc.setFiles(new File[]{new File(localRootUrl.getPath())});
        GitRevisionInfo[] infos = client.log(sc, true, (ProgressMonitor)monitor);
        for (int i = 0; i < infos.length - 1; ++i) {
            listInfo.add(infos[i]);
        }
        return listInfo.toArray(new GitRevisionInfo[0]);
    }

    private void init() {
        Insets ins = new Insets(5, 5, 5, 5);
        this._hintText.setText(Resource.get("WZ_PUSH_COMMIT_HINT"));
        this.setLayout(new GridBagLayout());
        this.add((Component)this._hintText, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add(new JScrollPane(this._tree), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, ins, 0, 0));
        this._tree.getSelectionModel().setSelectionMode(1);
        CommitCellRender render = new CommitCellRender();
        render.setLeafIcon(OracleIcons.getIcon((String)"file.png"));
        this._tree.setCellRenderer(render);
        this._tree.setRootVisible(false);
        this._tree.setShowsRootHandles(true);
        this._tree.addTreeExpansionListener(new CommitTreeExpansionListener());
        ToolTipManager.sharedInstance().registerComponent(this._tree);
    }

    private boolean treeContains(GITBranchTag branch) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this._tree.getModel().getRoot();
        Enumeration<TreeNode> children = root.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            if (!child.getUserObject().equals(GITPushCommitPanel.getBranchText(branch))) continue;
            return true;
        }
        return false;
    }

    private static String getBranchText(GITBranchTag node) {
        StringBuilder sb = new StringBuilder(node.getLocal());
        sb.append(" -> ");
        sb.append(node.getLocal());
        return sb.toString();
    }

    private void removeNodesForCommits(Collection<GITBranchTag> branches) {
        HashSet<String> brNames = new HashSet<String>(branches.size());
        Iterator<GITBranchTag> it = branches.iterator();
        while (it.hasNext()) {
            brNames.add(GITPushCommitPanel.getBranchText(it.next()));
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this._tree.getModel().getRoot();
        Enumeration<TreeNode> children = root.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            if (brNames.contains(child.getUserObject().toString())) continue;
            ((DefaultTreeModel)this._tree.getModel()).removeNodeFromParent(child);
        }
    }

    private class CommitCellRender
    extends DefaultTreeCellRenderer {
        private CommitCellRender() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String tooltip = "";
            Object user = ((DefaultMutableTreeNode)value).getUserObject();
            if (user instanceof CommitNode) {
                tooltip = ((CommitNode)user).getToolTip();
            }
            this.setToolTipText(tooltip);
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            return this;
        }
    }

    private static class CommitTreeExpansionListener
    implements TreeExpansionListener {
        private CommitTreeExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            TreePath path = event.getPath();
            final JTree tree = (JTree)event.getSource();
            final DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node.getUserObject() instanceof CommitNode) {
                final GitRevisionInfo info = ((CommitNode)node.getUserObject()).getRevisionInfo();
                final DefaultMutableTreeNode lnode = (DefaultMutableTreeNode)node.getFirstChild();
                if (lnode.getUserObject() instanceof LoadingNode) {
                    SwingWorker<DefaultMutableTreeNode[], Void> worker = new SwingWorker<DefaultMutableTreeNode[], Void>(){
                        private Exception _e;

                        @Override
                        protected DefaultMutableTreeNode[] doInBackground() throws Exception {
                            ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
                            try {
                                Map files = info.getModifiedFiles();
                                for (File file : files.keySet()) {
                                    DefaultMutableTreeNode fnode = new DefaultMutableTreeNode(new FileNode(file, (GitRevisionInfo.GitFileInfo)files.get(file)), false);
                                    nodes.add(fnode);
                                }
                            }
                            catch (GitException e) {
                                GITProfile.getQualifiedLogger(GITPushCommitPanel.class.getName()).log(Level.WARNING, "File of commit " + e.getMessage());
                            }
                            return nodes.toArray(new DefaultMutableTreeNode[0]);
                        }

                        @Override
                        protected void done() {
                            try {
                                DefaultMutableTreeNode[] fnodes;
                                ((DefaultTreeModel)tree.getModel()).removeNodeFromParent(lnode);
                                for (DefaultMutableTreeNode fnode : fnodes = (DefaultMutableTreeNode[])this.get()) {
                                    ((DefaultTreeModel)tree.getModel()).insertNodeInto(fnode, node, node.getChildCount());
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    };
                    worker.execute();
                }
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
        }
    }

    private static class NoTrackingBranchNode {
        private NoTrackingBranchNode() {
        }

        public String toString() {
            return Resource.get("PUSH_COMMIT_NO_TRACKING");
        }
    }

    private static class LoadingNode {
        private LoadingNode() {
        }

        public String toString() {
            return Resource.get("PUSH_COMMIT_LOAD");
        }
    }

    private static class BranchNode {
        private GITBranchTag _node;

        BranchNode(GITBranchTag branch) {
            this._node = branch;
        }

        public String toString() {
            return GITPushCommitPanel.getBranchText(this._node);
        }

        public boolean equals(Object txt) {
            return this.toString().equals(txt);
        }
    }

    private static class FileNode {
        private File _file;
        private GitRevisionInfo.GitFileInfo _info;

        FileNode(File file, GitRevisionInfo.GitFileInfo fileInfo) {
            this._file = file;
            this._info = fileInfo;
        }

        public String toString() {
            return this._file.getPath();
        }
    }

    private static class CommitNode {
        private GitRevisionInfo _info;

        CommitNode(GitRevisionInfo gitRevisionInfo) {
            this._info = gitRevisionInfo;
        }

        GitRevisionInfo getRevisionInfo() {
            return this._info;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this._info.getShortMessage().length() > 50) {
                sb.append(this._info.getShortMessage().substring(0, 50));
                sb.append("...");
            } else {
                sb.append(this._info.getShortMessage());
            }
            sb.append(this._info.getShortMessage().isEmpty() ? "" : " ");
            sb.append(GITUtil.shortCommitId(this._info.getRevision()));
            return sb.toString();
        }

        private String getToolTip() {
            if (this._info.getShortMessage().length() > 50) {
                return this._info.getFullMessage();
            }
            return null;
        }
    }
}

