/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.wiz;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import oracle.ide.Ide;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.GenericTablePersistentSettings;
import oracle.jdeveloper.vcs.vop.DisplayProperty;
import oracle.jdevimpl.vcs.git.GITDisplayProperty;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.wiz.GITRemoteBranchTableModel;
import org.netbeans.libs.git.GitBranch;

public abstract class GITBranchPanel
extends DefaultTraversablePanel {
    private JMultiLineLabel _hintText = new JMultiLineLabel();
    private GenericTable _table = new GenericTable();
    private JButton _btnSelect = new JButton();
    private JButton _btnDeselect = new JButton();
    private SearchControl _search = new SearchControl();
    private Map<String, GitBranch> _branches = Collections.emptyMap();
    private Set<String> _checkedBranches = new HashSet<String>();
    private String _remoteName;

    public GITBranchPanel() {
        this.init();
        this.addListeners();
    }

    protected abstract String getHintText();

    protected abstract String getBranchPersistKey();

    private void init() {
        Insets ins = new Insets(5, 5, 5, 5);
        this._table.setModel((TableModel)new BranchTableModel(this.getDisplayProperties()));
        this._hintText.setText(this.getHintText());
        ResourceUtils.resButton((AbstractButton)this._btnSelect, (String)Resource.get("BRANCH_SELECT_ALL"));
        ResourceUtils.resButton((AbstractButton)this._btnDeselect, (String)Resource.get("BRANCH_DESELECT_ALL"));
        this.setLayout(new GridBagLayout());
        this.add((Component)this._hintText, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add((Component)this._search.getUI(), new GridBagConstraints(2, 0, 1, 1, 0.5, 0.0, 17, 2, ins, 0, 0));
        this.add(new JScrollPane((Component)this._table), new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 17, 1, ins, 0, 0));
        this.add(new JPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add(this._btnSelect, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add(this._btnDeselect, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
    }

    private void addListeners() {
        this._btnSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GITBranchPanel.this.selectAllBranches(true);
            }
        });
        this._btnDeselect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GITBranchPanel.this.selectAllBranches(false);
            }
        });
        this._table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getColumn() == 0) {
                    Boolean inc = (Boolean)((BranchTableModel)e.getSource()).getValueAt(e.getFirstRow(), 0);
                    String branch = (String)((BranchTableModel)e.getSource()).getValueAt(e.getFirstRow(), 1);
                    if (inc.booleanValue()) {
                        GITBranchPanel.this._checkedBranches.add(branch);
                    } else {
                        GITBranchPanel.this._checkedBranches.remove(branch);
                    }
                }
            }
        });
    }

    private void selectAllBranches(boolean enable) {
        TableModel model = this._table.getModel();
        for (int r = 0; r < model.getRowCount(); ++r) {
            model.setValueAt(enable, r, 0);
        }
    }

    private DisplayProperty[] getDisplayProperties() {
        DisplayProperty[] props = new DisplayProperty[]{new GITDisplayProperty(Resource.get("WZ_BRANCH_COLUMN1"), null, 0, Boolean.FALSE, null, Boolean.class, 80, true), new GITDisplayProperty(Resource.get("WZ_BRANCH_COLUMN2"), null, 2, " a very long branch name that may be used in a git operation ", null, String.class, 200, false), new GITDisplayProperty(Resource.get("WZ_BRANCH_COLUMN3"), null, 2, " a very long branch name that may be used in a git operation ", null, String.class, 200, false)};
        return props;
    }

    public void onEntry(TraversableContext dataContext) {
        if (dataContext.getDirection() == 1) {
            this._branches = (Map)dataContext.get("git.remote-branches");
            this._remoteName = (String)dataContext.get("git.remote-name");
            Map activebranch = (Map)dataContext.get("git.use-branches");
            String[] activeBranch = null;
            if (activebranch != null && !activebranch.isEmpty() && activebranch.keySet().size() == 1) {
                activeBranch = activebranch.keySet().toArray(new String[0]);
            }
            ((BranchTableModel)this._table.getModel()).addData(this._branches.keySet(), activeBranch != null && activeBranch.length > 0 ? activeBranch[0] : "", Collections.emptyList());
            this._checkedBranches.addAll(((BranchTableModel)this._table.getModel()).getOperationBranches().keySet());
            this._table.setSortColumn(1, true);
            Map settings = (Map)Ide.getDTCache().getData(this.getBranchPersistKey());
            if (settings != null) {
                this._table.setPersistentSettings(new GenericTablePersistentSettings(settings));
            }
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        if (dataContext.getDirection() == 1) {
            Map<String, String> branches = ((BranchTableModel)this._table.getModel()).getOperationBranches();
            if (branches.isEmpty()) {
                throw new TraversalException(Resource.get("WZ_NO_BRANCH"), Resource.get("WZ_NO_BRANCH_TITLE"));
            }
            dataContext.put("git.use-branches", branches);
            GenericTablePersistentSettings settings = this._table.getPersistentSettings();
            Ide.getDTCache().putData(this.getBranchPersistKey(), settings.toMap());
        }
    }

    private class SearchControl {
        private SearchField _search;

        private SearchControl() {
        }

        SearchField getUI() {
            if (this._search == null) {
                this.initSearch();
            }
            return this._search;
        }

        private void initSearch() {
            this._search = new SearchField();
            this._search.setPrompt(Resource.get("BRANCH_SEARCH"));
            this._search.setStyle(SearchField.Style.FILTER);
            this._search.addSearchListener(new SearchListener(){

                public void searchPerformed(SearchEvent se) {
                    String txt = se.getSearchText();
                    if (txt.isEmpty()) {
                        this.restoreTable();
                        return;
                    }
                    this.filterBranch(txt);
                }

                public void searchCategoryChanged(SearchEvent se) {
                }

                private void filterBranch(String txt) {
                    BranchTableModel model = (BranchTableModel)GITBranchPanel.this._table.getModel();
                    Set<String> matching = GITBranchPanel.this._branches.keySet().stream().filter(item -> item.contains(txt)).collect(Collectors.toSet());
                    model.removeAll();
                    model.addData(matching, GITBranchPanel.this._remoteName, GITBranchPanel.this._checkedBranches);
                }

                private void restoreTable() {
                    BranchTableModel model = (BranchTableModel)GITBranchPanel.this._table.getModel();
                    model.removeAll();
                    model.addData(GITBranchPanel.this._branches.keySet(), GITBranchPanel.this._remoteName, GITBranchPanel.this._checkedBranches);
                }
            });
        }
    }

    private class BranchTableModel
    extends GITRemoteBranchTableModel {
        BranchTableModel(DisplayProperty[] properties) {
            super(properties);
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0 || col == 1) {
                return super.getValueAt(row, col);
            }
            if (col == 2) {
                return this.getToBranch(row);
            }
            return new Object();
        }

        private String getToBranch(int row) {
            return GITUtil.getRemoteBranchName(GITBranchPanel.this._remoteName, (String)this.getValueAt(row, 1));
        }

        Map<String, String> getOperationBranches() {
            Collection<String> incBranch = super.getIncludeBranches();
            HashMap<String, String> branches = new HashMap<String, String>();
            incBranch.stream().forEach(item -> branches.put((String)item, GITUtil.getRemoteBranchName(GITBranchPanel.this._remoteName, item)));
            return branches;
        }

        @Override
        public boolean canHide(int column) {
            return column == 2;
        }
    }
}

