/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizerAdapter;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.ui.GITBranchRevisionPanel;
import oracle.jdevimpl.vcs.git.ui.GITBranchTagHelper;
import oracle.jdevimpl.vcs.git.ui.GITBranchTagValidator;
import org.netbeans.libs.git.GitBranch;

public class GITCheckoutCustomizer
extends VCSOptionsCustomizerAdapter {
    private Map<String, GitBranch> _branches;
    private GITCheckoutPanel _panel;
    private final GITBranchTagValidator _validator = new GITBranchTagValidator();
    private final GITBranchTagHelper _helper = new GITBranchTagHelper();

    public Component getComponent() {
        if (this._panel == null) {
            this._panel = new GITCheckoutPanel();
        }
        return this._panel;
    }

    public Map<?, ?> getOptions() {
        GITCheckoutPanel ui = (GITCheckoutPanel)this.getComponent();
        Map<String, Object> options = this._helper.getOptions(ui.getBranchPanel());
        options.put("Git-create-branch", ui.getCreateBranch());
        return options;
    }

    public void setOptions(Map<?, ?> map) {
        GITCheckoutPanel ui = (GITCheckoutPanel)this.getComponent();
        this._helper.setOptions(map, ui.getBranchPanel());
    }

    public void validateOptions() throws VCSException {
        Map<?, ?> opts = this.getOptions();
        String branch = (String)opts.get("Git-use-branch");
        String tag = (String)opts.get("Git-use-tag");
        URL root = (URL)opts.get("Git-local-root");
        String revision = (String)opts.get("Git-use-revision");
        String crBranch = (String)opts.get("Git-create-branch");
        VCSException exception = this._validator.validateBranchAndTag(branch, tag, root, Resource.get("CHECKOUT_ERROR_TITLE"), this.getBranches(root));
        if (exception != null) {
            throw exception;
        }
        if (this.getBranches(root).containsKey(crBranch)) {
            throw new VCSException(Resource.get("CHECKOUT_ERROR_TITLE"), Resource.format("CHECKOUT_BRANCH_EXIST", crBranch));
        }
        if (this.isDetachedHead(root, branch, tag, revision, crBranch)) {
            throw new VCSException(Resource.get("CHECKOUT_ERROR_TITLE"), Resource.get("CHECKOUT_WARNING_BRANCH"));
        }
    }

    private boolean isDetachedHead(URL root, String branch, String tag, String revision, String crBranch) {
        if (tag != null && !tag.isEmpty() && crBranch.isEmpty()) {
            return true;
        }
        if (branch != null) {
            Map<String, GitBranch> branches = this.getBranches(root);
            if (crBranch.isEmpty() && !GITUtil.isLatest(root, branch, revision)) {
                return true;
            }
            GitBranch gbranch = branches.get(branch);
            if (gbranch.isRemote() && crBranch.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private Map<String, GitBranch> getBranches(URL root) {
        if (this._branches == null) {
            this._branches = GITUtil.getBranches(root);
        }
        return this._branches;
    }

    private static class GITCheckoutPanel
    extends JPanel {
        private GITBranchRevisionPanel _brrevPanel = new GITBranchRevisionPanel();
        private JLabel _lblNewBranch = new JLabel();
        private JTextField _fldNewBranch = new JTextField();

        private GITCheckoutPanel() {
            this.init();
            this.initLayout();
        }

        GITBranchRevisionPanel getBranchPanel() {
            return this._brrevPanel;
        }

        private void init() {
            ResourceUtils.resLabel((JLabel)this._lblNewBranch, (Component)this._fldNewBranch, (String)Resource.get("CHECKOUT_CREATE_BRANCH"));
        }

        private void initLayout() {
            this.setLayout(new GridBagLayout());
            this.add((Component)this._brrevPanel, new GridBagConstraints(0, 0, 2, 2, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this._lblNewBranch, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
            this.add((Component)this._fldNewBranch, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 12, 5, 0), 0, 0));
        }

        private String getCreateBranch() {
            return this._fldNewBranch.getText();
        }
    }
}

