/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.nav.cmd;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.net.URL;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.cmd.GITAbstractOperation;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.ui.GITRemotePanel;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITCommonRemoteCommand
extends GITAbstractOperation {
    public GITCommonRemoteCommand(String string) {
        super(string);
    }

    protected void validateName(PropertyChangeEvent evt, GITRemotePanel panel) throws PropertyVetoException {
        String name = panel.getRemoteName();
        if (name == null || name.isEmpty()) {
            MessageDialog.error((Component)panel, (Object)Resource.get("ADD_REMOTE_NO_NAME"), (String)Resource.get("ADD_REMOTE_TITLE"), null);
            throw new PropertyVetoException(Resource.get("ADD_REMOTE_NO_NAME"), evt);
        }
    }

    protected void validateURL(PropertyChangeEvent evt, GITRemotePanel panel, String url) throws PropertyVetoException {
        if (url == null || url.isEmpty()) {
            MessageDialog.error((Component)panel, (Object)Resource.get("ADD_REMOTE_NO_URL"), (String)Resource.get("ADD_REMOTE_TITLE"), null);
            throw new PropertyVetoException(Resource.get("ADD_REMOTE_NO_URL"), evt);
        }
        if (!url.contains("://")) {
            MessageDialog.error((Component)panel, (Object)Resource.format("ADD_REMOTE_URL_NOT_VALID", url), (String)Resource.get("ADD_REMOTE_TITLE"), null);
            throw new PropertyVetoException(Resource.get("ADD_REMOTE_URL_NOT_VALID"), evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateRemoteName(PropertyChangeEvent evt, GITRemotePanel panel, URL root) throws PropertyVetoException {
        GitClient client = null;
        String name = panel.getRemoteName().trim();
        try {
            client = GITClientAdaptor.getClient(root);
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("remote");
            monitor.setLog(false);
            GitRemoteConfig config = client.getRemote(name, (ProgressMonitor)monitor);
            if (config != null) {
                MessageDialog.error((Component)panel, (Object)Resource.format("ADD_REMOTE_NAME_EXIST", name), (String)Resource.get("ADD_REMOTE_TITLE"), null);
                throw new PropertyVetoException(Resource.get("ADD_REMOTE_NAME_EXIST"), evt);
            }
        }
        catch (GitException gitException) {
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }
}

