/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.nav;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.icons.OracleIcons;
import oracle.jdevimpl.vcs.git.GITNavURLFileSystemHelper;
import oracle.jdevimpl.vcs.git.GITRevision;
import oracle.jdevimpl.vcs.git.nav.GITRemote;
import oracle.jdevimpl.vcs.git.nav.GITStashFileNode;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitRevisionInfo;

public class GITStashNode
extends DefaultContainer
implements GITRemote {
    private GitRevisionInfo _info;
    private URL _toolUrl;
    private int _stashNo;
    private GITRevision _revision;

    GITStashNode(URL url, GitRevisionInfo info, int stashNo) {
        this._info = info;
        this._toolUrl = url;
        this._stashNo = stashNo;
        this.setURL(GITNavURLFileSystemHelper.toNavigatorURL(url));
    }

    public int getStashIndex() {
        return this._stashNo;
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public String getShortLabel() {
        return Resource.format("STASH_NODE_LABEL", this._stashNo, this._info.getShortMessage());
    }

    public Icon getIcon() {
        return OracleIcons.getIcon((String)"commit2.png");
    }

    public String getToolTipText() {
        return URLFileSystem.toDisplayString((URL)this._toolUrl);
    }

    @Override
    public boolean canDelete() {
        return true;
    }

    @Override
    public boolean canRefresh() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openImpl() {
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            GITRevision rev = (GITRevision)this.getData();
            Collection<File> files = rev.getFiles();
            if (files == null) {
                this._children.add(new Node(){

                    public String getShortLabel() {
                        return Resource.get("STASH_UNTRACKED_FILE");
                    }
                });
            } else {
                files.stream().forEach(item -> this._children.add(new GITStashFileNode(this._toolUrl, (File)item, rev)));
            }
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GITStashNode)) {
            return false;
        }
        return this.equalsImpl((Node)obj);
    }

    public Object getData() {
        if (this._revision == null) {
            this._revision = new GITRevision(this._toolUrl, this._info);
        }
        return this._revision;
    }
}

