/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.nav;

import java.awt.Component;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Node;
import oracle.jdevimpl.vcs.git.nav.GITBranchNode;
import oracle.jdevimpl.vcs.git.nav.GITConnectionListNode;
import oracle.jdevimpl.vcs.git.nav.GITRemote;
import oracle.jdevimpl.vcs.git.nav.GITRemoteConfigNode;
import oracle.jdevimpl.vcs.git.nav.GITRemoteFetchNode;
import oracle.jdevimpl.vcs.git.nav.GITRemotePushNode;
import oracle.jdevimpl.vcs.git.nav.GITRemotesListNode;
import oracle.jdevimpl.vcs.git.nav.GITStashFileNode;
import oracle.jdevimpl.vcs.git.nav.GITStashNode;
import oracle.jdevimpl.vcs.git.nav.GITTagNode;
import oracle.jdevimpl.vcs.git.nav.cmd.GITAddRemoteCommand;
import oracle.jdevimpl.vcs.git.nav.cmd.GITCopyURLCommand;
import oracle.jdevimpl.vcs.git.nav.cmd.GITEditRemoteCommand;
import oracle.jdevimpl.vcs.git.nav.cmd.GITNavCompareWorking;

public class GITNavigatorContextMenu
implements ContextMenuListener {
    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        Node node = context.getNode();
        if (node instanceof GITConnectionListNode) {
            this.addMenuItem(contextMenu, Ide.findCmdID((String)"oracle.jdeveloper.git.clone"), 1.0f, 1.0f);
        }
        if (node instanceof GITRemoteFetchNode) {
            this.addMenuItem(contextMenu, Ide.findCmdID((String)"oracle.jdeveloper.git.fetch"), 2.0f);
            this.addMenuItem(contextMenu, Ide.findCmdID((String)GITCopyURLCommand.COMMAND_ID), 2.0f);
        }
        if (node instanceof GITRemotePushNode) {
            this.addMenuItem(contextMenu, Ide.findCmdID((String)GITCopyURLCommand.COMMAND_ID), 2.0f);
        }
        if (node instanceof GITRemoteConfigNode) {
            this.addMenuItem(contextMenu, Ide.findCmdID((String)GITEditRemoteCommand.COMMAND_ID), 2.0f);
        }
        if (node instanceof GITRemote) {
            this.addMenuItemRefresh(contextMenu);
        }
        if (node instanceof GITTagNode || node instanceof GITBranchNode) {
            this.addMenuItemDelete(contextMenu);
            this.addMenuItem(contextMenu, Ide.findCmdID((String)"oracle.jdeveloper.git.createbranch"), 2.0f);
            if (node instanceof GITBranchNode) {
                this.addMenuItem(contextMenu, Ide.findCmdID((String)"oracle.jdeveloper.git.createtag"), 2.0f);
                this.addMenuItem(contextMenu, Ide.findCmdID((String)"oracle.jdeveloper.git.checkout"), 2.0f);
                this.addMenuItem(contextMenu, Ide.findCmdID((String)"oracle.jdeveloper.git.assign-remote-branch"), 2.0f);
            }
            this.addMenuItem(contextMenu, Ide.findCmdID((String)"oracle.jdeveloper.git.merge"), 2.0f);
            this.addMenuItem(contextMenu, Ide.findCmdID((String)"oracle.jdeveloper.git.nav-properties"), MenuConstants.WEIGHT_EDIT_PROPERTIES + 1.0f);
        }
        if (node instanceof GITRemotesListNode) {
            this.addMenuItem(contextMenu, Ide.findCmdID((String)GITAddRemoteCommand.COMMAND_ID), 2.0f);
        }
        if (node instanceof GITStashNode) {
            this.addMenuItem(contextMenu, Ide.findCmdID((String)"oracle.jdeveloper.git.stash-apply"), 2.0f);
        }
        if (node instanceof GITStashFileNode) {
            this.addMenuItem(contextMenu, Ide.findCmdID((String)GITNavCompareWorking.COMMAND_ID), 2.0f);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    protected final void addMenuItemRefresh(ContextMenu popup) {
        if (popup.getIndexOfCommandId(popup.getGUI(true), 51) >= 0) {
            return;
        }
        popup.add((Component)popup.createMenuItem((ToggleAction)IdeAction.find((int)51)), MenuConstants.WEIGHT_EDIT_PROPERTIES);
    }

    private void addMenuItem(ContextMenu contextMenu, Integer commandId, float weight) {
        contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)IdeAction.find((int)commandId), weight));
    }

    private void addMenuItemDelete(ContextMenu popup) {
        if (popup.getIndexOfCommandId(popup.getGUI(true), 20) >= 0) {
            return;
        }
        popup.add((Component)popup.createMenuItem((ToggleAction)IdeAction.find((int)20)), MenuConstants.WEIGHT_FILE_ERASE);
    }

    private void addMenuItem(ContextMenu popup, int commandId, float section, float weight) {
        popup.add((Component)popup.createMenuItem((ToggleAction)IdeAction.find((int)commandId), weight), section);
    }
}

