/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.imp;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.FileField;
import oracle.jdeveloper.vcs.spi.VCSCommentsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSRecentCommentsModel;
import oracle.jdeveloper.vcs.util.VCSNavigableUtils;
import oracle.jdevimpl.vcs.git.res.Resource;

public class SourcePanel
extends DefaultTraversablePanel {
    private boolean _initialized = false;
    private JMultiLineLabel _hint;
    private JLabel _sourceLabel;
    private FileField _sourceField;
    private JButton _sourceBrowseButton;
    private JLabel _destLabel;
    private FileField _destField;
    private JButton _destBrowseButton;
    private VCSCommentsCustomizer _commentsUI;
    private static VCSRecentCommentsModel _recentCommentsModel;

    public void onEntry(TraversableContext ctx) {
        this.initialize();
        URL srcURL = (URL)ctx.get("source_url");
        URL destURL = (URL)ctx.get("dest_url");
        this._sourceField.setText(URLFileSystem.getPlatformPathName((URL)srcURL));
        if (destURL == null) {
            this._destField.setText(URLFileSystem.getPlatformPathName((URL)srcURL));
        } else {
            this._destField.setText(URLFileSystem.getPlatformPathName((URL)destURL));
        }
        ctx.getWizardCallbacks().wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
    }

    public void onExit(TraversableContext ctx) throws TraversalException {
        if (ctx.getDirection() == 1) {
            if (this._sourceField.getText().length() == 0) {
                throw new TraversalException(Resource.get("ERROR_IMPORT_SRC"), Resource.get("ERROR_EXPORT_TITLE"));
            }
            URL url = URLFactory.newURL((String)this._sourceField.getText());
            if (url == null || !URLFileSystem.exists((URL)url)) {
                throw new TraversalException(Resource.format("IMPORT_OP_ERROR_MSG_SOURCENOTEXIST", this._sourceField.getText()), Resource.get("ERROR_EXPORT_TITLE"));
            }
            if (this._destField.getText().length() == 0) {
                throw new TraversalException(Resource.get("ERROR_IMPORT_DST"), Resource.get("ERROR_EXPORT_TITLE"));
            }
            url = URLFactory.newURL((String)this._destField.getText());
            if (url == null || !url.getProtocol().equals("file")) {
                throw new TraversalException(Resource.get("ERROR_IMPORT_DST_LOCATION"), Resource.get("ERROR_EXPORT_TITLE"));
            }
        }
        ctx.put("source_url", (Object)URLFactory.newURL((String)this._sourceField.getText()));
        ctx.put("dest_url", (Object)URLFactory.newURL((String)this._destField.getText()));
        ctx.put("comments", this._commentsUI.getOptions().get("setting_comments"));
    }

    private synchronized void initialize() {
        if (this._initialized) {
            return;
        }
        this.createComponents();
        this.layoutComponents();
        this.initListeners();
        this._initialized = true;
    }

    private void createComponents() {
        this._hint = new JMultiLineLabel();
        this._hint.setText(Resource.get("IMPORT_UI_SOURCE_DEST_HINT"));
        this._sourceField = new FileField(true);
        this._sourceField.setText("");
        this._sourceLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this._sourceLabel, (Component)this._sourceField, (String)Resource.get("IMPORT_UI_SOURCE_DIR"));
        this._sourceBrowseButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this._sourceBrowseButton, (String)Resource.get("IMPORT_UI_SOURCE_BROWSE"));
        this._destField = new FileField(true);
        this._destField.setText("");
        this._destLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this._destLabel, (Component)this._destField, (String)Resource.get("IMPORT_UI_DEST_DIR"));
        this._destBrowseButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this._destBrowseButton, (String)Resource.get("IMPORT_UI_DEST_BROWSE"));
        this._commentsUI = new VCSCommentsCustomizer("oracle.jdeveloper.git");
        this._commentsUI.setShowTemplatesAndCommentsCombo(true);
        this._commentsUI.setTemplatesSettingsPath(VCSNavigableUtils.getSystemNavigablePath((String)Resource.get("VCS_SHORT_NAME"), (String[])new String[]{VCSCommentsCustomizer.COMMENT_TEMPLATES_NAVIGABLE_LABEL}));
        this._commentsUI.setTemplateOnly(true);
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this._hint, this.gbc(0, 0, 2, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 15, 0), 0, 0));
        this.add(this._sourceLabel, this.gbc(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.add((Component)this._sourceField, this.gbc(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.add(this._sourceBrowseButton, this.gbc(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this._destLabel, this.gbc(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.add((Component)this._destField, this.gbc(0, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.add(this._destBrowseButton, this.gbc(1, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this._commentsUI.getComponent(), this.gbc(0, 5, 2, 1, 1.0, 1.0, 17, 1, new Insets(20, 0, 0, 0), 0, 0));
    }

    private void initListeners() {
        BrowseActionListener listener = new BrowseActionListener();
        this._sourceBrowseButton.addActionListener(listener);
        this._destBrowseButton.addActionListener(listener);
    }

    private class BrowseActionListener
    implements ActionListener {
        private BrowseActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == SourcePanel.this._sourceBrowseButton) {
                this.showOpenDialog(SourcePanel.this._sourceField);
            } else if (e.getSource() == SourcePanel.this._destBrowseButton) {
                this.showOpenDialog(SourcePanel.this._destField);
            }
        }

        private void showOpenDialog(FileField field) {
            URL current = URLFactory.newDirURL((String)field.getText());
            URLChooser chooser = DialogUtil.newURLChooser((URL)current);
            chooser.setSelectionMode(0);
            chooser.setSelectionScope(1);
            if (chooser.showOpenDialog((Component)((Object)SourcePanel.this)) == 0) {
                field.setText(URLFileSystem.getPlatformPathName((URL)chooser.getSelectedURL()));
            }
        }
    }
}

