/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.commithistory;

import java.util.logging.Level;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.commithistory.GITCommitVersionCompare;
import oracle.jdevimpl.vcs.git.commithistory.GITCommitVersionDockableWindow;

public class GITCommitVersionController
implements Controller {
    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (context.getView() instanceof GITCommitVersionDockableWindow) {
            if (cmdId == 51) {
                ((GITCommitVersionDockableWindow)context.getView()).refresh();
                return true;
            }
            if (cmdId == Ide.findCmdID((String)GITCommitVersionCompare.COMMAND_ID)) {
                this.invokeCompare(context);
                return true;
            }
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (context.getView() instanceof GITCommitVersionDockableWindow) {
            if (cmdId == 51) {
                action.setEnabled(!((GITCommitVersionDockableWindow)context.getView()).isBusy());
                return true;
            }
            if (cmdId == Ide.findCmdID((String)"oracle.jdeveloper.git.commithistory.createtag")) {
                action.setEnabled(true);
                return true;
            }
            if (cmdId == Ide.findCmdID((String)"oracle.jdeveloper.git.commithistory.exportcommit")) {
                action.setEnabled(true);
                return true;
            }
            if (cmdId == Ide.findCmdID((String)GITCommitVersionCompare.COMMAND_ID)) {
                if (context.containsProperty("commit-version-file-path")) {
                    action.setEnabled(true);
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
        }
        return false;
    }

    private boolean invokeCompare(Context context) {
        return this.invokeCommand((Command)new GITCommitVersionCompare(), context);
    }

    private boolean invokeCommand(Command command, Context context) {
        try {
            command.setContext(context);
            CommandProcessor.getInstance().invoke(command);
            return true;
        }
        catch (Exception e) {
            GITProfile.getQualifiedLogger(GITCommitVersionController.class.getName()).log(Level.SEVERE, e.getMessage());
            return false;
        }
    }
}

