/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.cmd;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.SelectFilesPanel;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFactory;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.BaseMessageDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.cmd.GITExtendedAbstractOperation;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.ui.GITCheryPickCustomizer;
import org.netbeans.libs.git.GitCherryPickResult;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRepositoryState;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITOperationCherryPick
extends GITExtendedAbstractOperation {
    private static final String COMMAND_ID = "oracle.jdeveloper.git.cherrypick";
    private URL _root;

    public GITOperationCherryPick() {
        super(COMMAND_ID);
    }

    public GITOperationCherryPick(String commandId) {
        super(commandId);
    }

    protected VCSOptionsCustomizer createOptionsCustomizer() {
        try {
            Locatable[] locatables = this.getOperands(this.getProfile());
            this._root = GITUtil.getRootContaining(locatables[0].getURL());
            String branch = null;
            Map<String, Object> defaultOpts = this.getBranchRevisionOptions(this._root, branch, false);
            GITCheryPickCustomizer customizer = new GITCheryPickCustomizer();
            customizer.setOptions(defaultOpts);
            return customizer;
        }
        catch (Exception e) {
            GITProfile.getQualifiedLogger(GITOperationCherryPick.class.getName()).log(Level.WARNING, "Cherry pick customizer failed ", e);
            return null;
        }
    }

    protected Locatable[] getOperands(VCSProfile profile) throws Exception {
        return this.getRootOperand(profile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean invokeCommand(VCSProfile profile, CommandState commandState) throws Exception {
        List<Locatable> locs = Arrays.asList(commandState.getLocatables());
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor(Resource.get("CHERRY_PICK_OPERATION"));
        GitClient client = GITClientAdaptor.getClient(locs.toArray(new Locatable[0])[0].getURL());
        try {
            GitRepositoryState state = client.getRepositoryState((ProgressMonitor)monitor);
            if (state == GitRepositoryState.CHERRY_PICKING) {
                this.cherryPickNotCompleted(client, profile);
                boolean bl = false;
                return bl;
            }
        }
        finally {
            client.release();
        }
        return super.invokeCommand(profile, commandState);
    }

    @Override
    protected boolean invokeCommandImpl(VCSProfile profile, CommandState commandState, Component parentUi, Map options) throws Exception {
        String revision = (String)options.get("Git-use-revision");
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor(Resource.get("CHERRY_PICK_OPERATION"));
        final IndeterminateProgressMonitor progress = new IndeterminateProgressMonitor((Component)IdeUtil.getMainWindow(), Resource.get("CHERRY_PICK_PROGRESS_TITLE"), (Object)Resource.get("CHERRY_PICK_PROGRESS"), null);
        VCSCancellable cancellable = new VCSCancellable(){

            public boolean isCancelled() {
                return progress.isCanceled();
            }
        };
        monitor.setLog(true);
        progress.start();
        GitClient client = null;
        boolean status = true;
        try {
            client = GITClientAdaptor.getClient(this._root);
            GitCherryPickResult result = client.cherryPick(GitClient.CherryPickOperation.BEGIN, new String[]{revision}, (ProgressMonitor)monitor);
            if (monitor.getError() != null) {
                throw new GITProcessException(Resource.format("CHERRY_PICK_FAILURE", revision), monitor.getError());
            }
            if (result.getCherryPickStatus() == GitCherryPickResult.CherryPickStatus.FAILED) {
                status = false;
                this.showFailureDialog(result);
            }
            if (result.getCherryPickStatus() == GitCherryPickResult.CherryPickStatus.CONFLICTING) {
                status = this.confirmConflict(result, client, monitor);
            }
            if (status) {
                this.updatedFiles(client, revision, commandState, monitor);
            }
        }
        catch (GitException ex) {
            GITProfile.getQualifiedLogger(GITOperationCherryPick.class.getName()).log(Level.WARNING, "Cherry pick Operation failed ", ex);
            throw new GITProcessException(Resource.format("CHERRY_PICK_FAILURE", revision), ex.getLocalizedMessage());
        }
        finally {
            progress.finish();
            if (client != null) {
                client.release();
            }
        }
        return true;
    }

    private boolean confirmConflict(GitCherryPickResult result, GitClient client, GITCommandProgressMonitor monitor) throws GITProcessException {
        boolean ans = this.showConflictDialog(result);
        if (!ans) {
            try {
                client.cherryPick(GitClient.CherryPickOperation.ABORT, null, (ProgressMonitor)monitor);
            }
            catch (GitException e) {
                GITProfile.getQualifiedLogger(GITOperationCherryPick.class.getName()).log(Level.WARNING, "Cherry pick abort operation failed ", e);
                throw new GITProcessException(Resource.get("CHERRY_PICK_RESET_ERROR"), e.getLocalizedMessage());
            }
        }
        return ans;
    }

    private void updatedFiles(GitClient client, String revision, CommandState commandState, GITCommandProgressMonitor monitor) throws GitException {
        ArrayList processed = new ArrayList();
        GitRevisionInfo info = client.log(revision, (ProgressMonitor)monitor);
        Map files = info.getModifiedFiles();
        files.keySet().stream().forEach(file -> processed.add(URLFactory.newURL((String)file.getPath())));
        if (!processed.isEmpty()) {
            this.setProcessedUrls(commandState, processed.toArray(new URL[0]));
            commandState.setProperty("git.structure-changed", processed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cherryPickNotCompleted(final GitClient client, final VCSProfile profile) {
        final BaseMessageDialog dialog = BaseMessageDialog.createMessageDialogImpl((Component)Ide.getMainWindow(), (String)Resource.get("CHERRY_PICK_MIDDLE_TITLE"), (int)4);
        JButton custom = new JButton();
        ResourceUtils.resButton((AbstractButton)custom, (String)Resource.get("CHERRY_PICK_CONTINUE"));
        dialog.setMessageText(Resource.get("CHERRY_PICK_MIDDLE"));
        dialog.addCustomButton((Component)custom);
        dialog.setOKButtonText(Resource.get("CHERRY_PICK_ABORT"));
        dialog.setCancelButtonText(Resource.get("CHERRY_PICK_QUIT"));
        custom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GITOperationCherryPick.this.cherryPick(client, profile, GitClient.CherryPickOperation.CONTINUE);
                dialog.closeDialog(false);
            }
        });
        dialog.setDefaultCustomButton(custom, true);
        try {
            if (!dialog.runDialog()) {
                this.cherryPick(client, profile, GitClient.CherryPickOperation.QUIT);
            } else if (dialog.isOked()) {
                this.cherryPick(client, profile, GitClient.CherryPickOperation.ABORT);
            }
        }
        catch (Throwable throwable) {
            SwingUtilities.invokeLater(new Runnable(dialog){
                final /* synthetic */ BaseMessageDialog val$dialog;
                {
                    this.val$dialog = baseMessageDialog;
                }

                @Override
                public void run() {
                    this.val$dialog.dispose();
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private void cherryPick(GitClient client, VCSProfile profile, GitClient.CherryPickOperation cherryPickOperation) {
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor(Resource.get("CHERRY_PICK_OPERATION"));
        monitor.setLog(true);
        try {
            Locatable[] loc = this.getRootOperand(profile);
            Collection<File> roots = GITUtil.convertLocatableToFile(loc);
            File[] files = client.listModifiedIndexEntries(roots.toArray(new File[0]), (ProgressMonitor)monitor);
            GitCherryPickResult result = client.cherryPick(cherryPickOperation, null, (ProgressMonitor)monitor);
            final Collection<URL> urls = GITUtil.convertFileToUrl(files);
            profile.getPolicyStatusCache().clear(urls.toArray(new URL[0]));
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VCSBufferUtils.reloadBuffer((URL[])urls.toArray(new URL[0]));
                }
            });
        }
        catch (Exception e) {
            GITProcessException ex = null;
            if (cherryPickOperation == GitClient.CherryPickOperation.ABORT) {
                ex = new GITProcessException(Resource.get("CHERRY_PICK_ABORT_ERROR"), e.getLocalizedMessage());
            } else if (cherryPickOperation == GitClient.CherryPickOperation.CONTINUE) {
                ex = new GITProcessException(Resource.get("CHERRY_PICK_CONTINUE_ERROR"), e.getLocalizedMessage());
            } else if (cherryPickOperation == GitClient.CherryPickOperation.QUIT) {
                ex = new GITProcessException(Resource.get("CHERRY_PICK_QUIT_ERROR"), e.getLocalizedMessage());
            }
            GITProfile.getQualifiedLogger(GITOperationCherryPick.class.getName()).log(Level.WARNING, "Failed to abort,contune or quit cherr pick operation", (Throwable)((Object)ex));
            new VCSExceptionHandler().handleException((Exception)((Object)ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean showConflictDialog(GitCherryPickResult result) {
        CheckBoxListModel model = new CheckBoxListModel();
        result.getConflicts().stream().forEach(e -> model.addElement(e, OracleIcons.getIcon((String)"file.png"), e.getPath(), e.getPath()));
        if (model.getSize() == 1) {
            File[] files = result.getConflicts().toArray(new File[0]);
            String label = Resource.format("CHERRY_PICK_CONFLICTS1", files[0].getPath());
            int ans = SelectFilesPanel.showDialog((String)Resource.get("CHERRY_PICK_CONFLICTS_TITLE"), (String)label, (String)label, (CheckBoxListModel)model, (boolean)false, (int)0);
            return ans == 0;
        }
        CherryPickFilesPanel panel = new CherryPickFilesPanel(model, Resource.get("CHERRY_PICK_CONFLICTS"), false);
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)Ide.getMainWindow(), (Component)((Object)panel), null, (String)Resource.get("CHERRY_PICK_CONFLICTS_TITLE1"), (int)3);
        dlg.setCancelButtonText(Resource.get("CHERRY_PICK_NO"));
        dlg.setOKButtonText(Resource.get("CHERRY_PICK_YES"));
        try {
            boolean bl = dlg.runDialog();
            return bl;
        }
        finally {
            dlg.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showFailureDialog(GitCherryPickResult result) {
        if (result.getFailures().size() == 1) {
            File[] files = result.getFailures().toArray(new File[0]);
            String label = Resource.format("CHERRY_PICK_FAILED_FILE1", files[0].getPath());
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)label, (String)Resource.get("CHERRY_PICK_FAILED_TITLE"), null);
        } else {
            CheckBoxListModel model = new CheckBoxListModel();
            result.getFailures().stream().forEach(e -> model.addElement(e, OracleIcons.getIcon((String)"file.png"), e.getPath(), e.getPath()));
            CherryPickFilesPanel panel = new CherryPickFilesPanel(model, Resource.get("CHERRY_PICK_FAILED_FILE"), false);
            JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)Ide.getMainWindow(), (Component)((Object)panel), null, (String)Resource.get("CHERRY_PICK_FAILED_TITLE"), (int)1);
            try {
                dlg.runDialog();
            }
            finally {
                dlg.dispose();
            }
        }
    }

    private static class CherryPickFilesPanel
    extends SelectFilesPanel {
        CherryPickFilesPanel(CheckBoxListModel listModel, String label, boolean checkedList) {
            super(listModel, checkedList, null, label);
        }
    }
}

