/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.explorer.IconOverlay;
import oracle.jdeveloper.vcs.cache.StatusCache;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSOverlayItemProducer;
import oracle.jdeveloper.vcs.spi.VCSPreferences;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;

public final class GITOverlayItemProducer
extends VCSOverlayItemProducer {
    private final VCSProfile _profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git");
    private static final Map<URL, String> _versionCache = Collections.synchronizedMap(new HashMap());

    public GITOverlayItemProducer(StatusCache<VCSStatus> statusCache) {
        super("oracle.jdeveloper.git", statusCache);
    }

    protected IconOverlay produceOverlay(URL url, VCSStatus status, VCSPreferences prefs) throws Exception {
        IconOverlay overlay = status.getOverlay();
        if (overlay == null) {
            return null;
        }
        boolean useIcons = prefs.getUseOverlays();
        boolean useLabels = prefs.getUseLabelDecorations();
        if (!useIcons && !useLabels) {
            return null;
        }
        return new IconOverlay(useIcons ? overlay.getIcon() : null, useLabels ? this.createOverlayLabel(url, status) : null, this.getToolTip(overlay));
    }

    private String createOverlayLabel(URL url, VCSStatus status) {
        if (!status.isVersioned() || status == this._profile.getStatusInstance("DELETED")) {
            return null;
        }
        String version = _versionCache.get(url);
        return version != null ? " " + version : null;
    }

    static void cacheVersion(URL url, String version) {
        url = VCSFileSystemUtils.removeRefAndQueryParts((URL[])new URL[]{url})[0];
        StringBuilder sb = new StringBuilder("[");
        sb.append(version);
        sb.append("]");
        _versionCache.put(url, sb.toString());
    }

    static void clearVersion(URL url) {
        _versionCache.remove(url);
    }

    public static void clearVersion(URL[] urls) {
        for (URL url : urls) {
            GITOverlayItemProducer.clearVersion(url);
        }
    }

    static void clearVersionCache() {
        _versionCache.clear();
    }

    private String getToolTip(IconOverlay iconOverlay) {
        if (iconOverlay.getToolTipText() != null) {
            return "Git: " + iconOverlay.getToolTipText();
        }
        return null;
    }
}

