/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.xkms.xkrss;

import oracle.security.xmlsec.util.Base64;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.xkms.Request;
import oracle.security.xmlsec.xkms.xkrss.Authentication;
import oracle.security.xmlsec.xkms.xkrss.RevokeKeyBinding;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class RevokeRequest
extends Request {
    public RevokeRequest(Element element) throws DOMException {
        super(element);
    }

    public RevokeRequest(Document owner) throws DOMException {
        super(owner, "RevokeRequest", null);
    }

    public RevokeRequest(Document owner, String systemId) throws DOMException {
        super(owner, "RevokeRequest", systemId);
    }

    public RevokeRequest(Document owner, RevokeKeyBinding keyInfo) throws DOMException {
        this(owner);
        this.setKeyBinding(keyInfo);
    }

    public void setKeyBinding(RevokeKeyBinding keyInfo) throws DOMException {
        this.removeChildren("RevokeKeyBinding", "http://www.w3.org/2002/03/xkms#");
        RevokeKeyBinding ki = new RevokeKeyBinding((Element)this.getOwnerDocument().importNode(keyInfo.getNode(), true));
        this.insertChild(ki, new String[]{"Signature", "MessageExtension", "OpaqueClientData", "ResponseMechanism", "RespondWith", "PendingNotification"}, new String[]{"http://www.w3.org/2000/09/xmldsig#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#"});
        this.clearSignature();
    }

    public RevokeKeyBinding getKeyBinding() throws DOMException {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "RevokeKeyBinding");
        if (nList.getLength() != 0) {
            return new RevokeKeyBinding((Element)nList.item(0));
        }
        return null;
    }

    public void setAuthentication(Authentication authInfo) throws DOMException {
        this.removeChildren("Authentication", "http://www.w3.org/2002/03/xkms#");
        this.removeChildren("RevocationCode", "http://www.w3.org/2002/03/xkms#");
        Authentication ki = new Authentication((Element)this.getOwnerDocument().importNode(authInfo.getNode(), true));
        this.getNode().appendChild(ki.getNode());
        this.clearSignature();
    }

    public Authentication getAuthentication() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "Authentication");
        if (nList.getLength() != 0) {
            return new Authentication((Element)nList.item(0));
        }
        return null;
    }

    public void setRevocationCode(byte[] revocationCode) throws DOMException {
        this.removeChildren("RevocationCode", "http://www.w3.org/2002/03/xkms#");
        this.removeChildren("Authentication", "http://www.w3.org/2002/03/xkms#");
        Element s = this.getOwnerDocument().createElementNS("http://www.w3.org/2002/03/xkms#", "RevocationCode");
        XMLUtils.copyNSPrefix((Element)((Element)this.node), (Element)s);
        s.appendChild(this.getOwnerDocument().createTextNode(Base64.toBase64((byte[])revocationCode, (boolean)false)));
        this.getNode().appendChild(s);
        this.clearSignature();
    }

    public byte[] getRevocationCode() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "RevocationCode");
        if (nList.getLength() != 0) {
            Element s = (Element)nList.item(0);
            s.normalize();
            Text sText = (Text)s.getFirstChild();
            if (sText != null) {
                return Base64.fromBase64((String)sText.getData());
            }
        }
        return null;
    }
}

