/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.xkms.xkrss;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import oracle.security.xmlsec.c14n.CanonicalizationException;
import oracle.security.xmlsec.c14n.XMLC14NWithComments;
import oracle.security.xmlsec.enc.XEEncryptedData;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.xkms.util.XKMSInitializer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PrivateKey
extends XMLElement {
    public PrivateKey(Element element) throws DOMException {
        super(element);
    }

    public PrivateKey(Document owner) throws DOMException {
        super(owner, "http://www.w3.org/2002/03/xkms#", "PrivateKey");
    }

    public PrivateKey(Document owner, String systemId) throws DOMException {
        super(owner, "http://www.w3.org/2002/03/xkms#", "PrivateKey", systemId);
    }

    public void setEncryptedKeyData(XEEncryptedData xenc) throws DOMException {
        Element kiElement = null;
        try {
            byte[] kiBytes = new XMLC14NWithComments().canonicalize(xenc.getNode());
            Document kiDoc = XMLUtils.createDocBuilder().parse(new ByteArrayInputStream(kiBytes));
            kiElement = kiDoc.getDocumentElement();
        }
        catch (CanonicalizationException ex) {
            throw new DOMException(11, "Error canonicalizing xenc:EncryptedData");
        }
        catch (IOException ex) {
            throw new DOMException(11, "Error reading xenc:EncryptedData");
        }
        catch (SAXException ex) {
            throw new DOMException(11, "Error parsing xenc:EncryptedData");
        }
        XEEncryptedData ki = new XEEncryptedData((Element)this.getOwnerDocument().importNode(kiElement, true));
        NodeList nList = ((Element)this.node).getChildNodes();
        if (nList.getLength() == 0) {
            ((Element)this.getNode()).appendChild(ki.getNode());
        } else if (nList.getLength() == 1) {
            ((Element)this.getNode()).replaceChild(ki.getNode(), nList.item(0));
        } else {
            throw new DOMException(11, "Error parsing xkms:PrivateKey");
        }
    }

    public XEEncryptedData getEncryptedKeyData() {
        Element encVal;
        NodeList nList = ((Element)this.node).getChildNodes();
        if (nList.getLength() != 0 && (encVal = (Element)nList.item(0)) != null) {
            return new XEEncryptedData(encVal);
        }
        return null;
    }

    static {
        XKMSInitializer.initialize();
    }
}

