/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.xkms.util;

import java.util.Hashtable;
import oracle.security.xmlsec.util.TagManager;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.xkms.CompoundRequest;
import oracle.security.xmlsec.xkms.CompoundResult;
import oracle.security.xmlsec.xkms.KeyBinding;
import oracle.security.xmlsec.xkms.OpaqueClientData;
import oracle.security.xmlsec.xkms.PendingRequest;
import oracle.security.xmlsec.xkms.PrototypeKeyBinding;
import oracle.security.xmlsec.xkms.QueryKeyBinding;
import oracle.security.xmlsec.xkms.RSAKeyPair;
import oracle.security.xmlsec.xkms.Result;
import oracle.security.xmlsec.xkms.Status;
import oracle.security.xmlsec.xkms.StatusRequest;
import oracle.security.xmlsec.xkms.StatusResult;
import oracle.security.xmlsec.xkms.UnverifiedKeyBinding;
import oracle.security.xmlsec.xkms.xkiss.LocateRequest;
import oracle.security.xmlsec.xkms.xkiss.LocateResult;
import oracle.security.xmlsec.xkms.xkiss.ValidateRequest;
import oracle.security.xmlsec.xkms.xkiss.ValidateResult;
import oracle.security.xmlsec.xkms.xkrss.Authentication;
import oracle.security.xmlsec.xkms.xkrss.PrivateKey;
import oracle.security.xmlsec.xkms.xkrss.ProofOfPossession;
import oracle.security.xmlsec.xkms.xkrss.RecoverKeyBinding;
import oracle.security.xmlsec.xkms.xkrss.RecoverRequest;
import oracle.security.xmlsec.xkms.xkrss.RecoverResult;
import oracle.security.xmlsec.xkms.xkrss.RegisterRequest;
import oracle.security.xmlsec.xkms.xkrss.RegisterResult;
import oracle.security.xmlsec.xkms.xkrss.ReissueKeyBinding;
import oracle.security.xmlsec.xkms.xkrss.ReissueRequest;
import oracle.security.xmlsec.xkms.xkrss.ReissueResult;
import oracle.security.xmlsec.xkms.xkrss.RevokeKeyBinding;
import oracle.security.xmlsec.xkms.xkrss.RevokeRequest;
import oracle.security.xmlsec.xkms.xkrss.RevokeResult;

public class XKMSInitializer {
    private static boolean initialized;

    public static synchronized void initialize() {
        if (!initialized) {
            XMLElement.setDefaultNSPrefix((String)"http://www.w3.org/2002/03/xkms#", (String)"xkms");
            XMLUtils.addIdAttribute((String)"http://www.w3.org/2002/03/xkms#", (String)"Id");
            XKMSInitializer.mapXKMSTags();
            initialized = true;
        }
    }

    private XKMSInitializer() {
    }

    private static void mapXKMSTags() {
        Hashtable<String, Class<RSAKeyPair>> xkmsMap = new Hashtable<String, Class<RSAKeyPair>>();
        xkmsMap.put("PendingRequest", PendingRequest.class);
        xkmsMap.put("StatusRequest", StatusRequest.class);
        xkmsMap.put("StatusResult", StatusResult.class);
        xkmsMap.put("CompoundRequest", CompoundRequest.class);
        xkmsMap.put("CompoundResult", CompoundResult.class);
        xkmsMap.put("OpaqueClientData", OpaqueClientData.class);
        xkmsMap.put("Result", Result.class);
        xkmsMap.put("LocateRequest", LocateRequest.class);
        xkmsMap.put("LocateResult", LocateResult.class);
        xkmsMap.put("ValidateRequest", ValidateRequest.class);
        xkmsMap.put("ValidateResult", ValidateResult.class);
        xkmsMap.put("RevokeRequest", RevokeRequest.class);
        xkmsMap.put("RevokeResult", RevokeResult.class);
        xkmsMap.put("ReissueRequest", ReissueRequest.class);
        xkmsMap.put("ReissueResult", ReissueResult.class);
        xkmsMap.put("RecoverRequest", RecoverRequest.class);
        xkmsMap.put("RecoverResult", RecoverResult.class);
        xkmsMap.put("RegisterRequest", RegisterRequest.class);
        xkmsMap.put("RegisterResult", RegisterResult.class);
        xkmsMap.put("UnverifiedKeyBinding", UnverifiedKeyBinding.class);
        xkmsMap.put("KeyBinding", KeyBinding.class);
        xkmsMap.put("PrototypeKeyBinding", PrototypeKeyBinding.class);
        xkmsMap.put("QueryKeyBinding", QueryKeyBinding.class);
        xkmsMap.put("RecoverKeyBinding", RecoverKeyBinding.class);
        xkmsMap.put("ReissueKeyBinding", ReissueKeyBinding.class);
        xkmsMap.put("RevokeKeyBinding", RevokeKeyBinding.class);
        xkmsMap.put("Authentication", Authentication.class);
        xkmsMap.put("PrivateKey", PrivateKey.class);
        xkmsMap.put("ProofOfPossession", ProofOfPossession.class);
        xkmsMap.put("Status", Status.class);
        xkmsMap.put("RSAKeyPair", RSAKeyPair.class);
        TagManager.getTagManager().mapNamespace("http://www.w3.org/2002/03/xkms#", xkmsMap);
    }
}

