/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;
import oracle.bali.ewt.dateEditor.DateEditor;
import oracle.bali.ewt.text.NumberTextField;
import oracle.hcs.util.HyperLinkControl;
import oracle.hcs.util.HyperLinkLabel;
import oracle.hcs.util.HyperParamColoringHelper;

public class HyperLinkField
extends JPanel
implements HyperLinkControl,
HyperParamColoringHelper {
    protected JPopupMenu m_editMenu = null;
    private EventListenerList m_focusListenerList = new EventListenerList();
    private boolean m_blnIsEnabled = true;
    private HyperLinkLabel m_hyperLabel;
    private JLabel m_percentLbl;
    private Component m_editor;
    private JCheckBox m_percentChkBox;
    private boolean m_enterPressed;
    private boolean m_blnEscaped = false;
    private boolean m_blnIsHyperLink = true;
    private boolean m_blnPercentVisible = false;
    private NumberFormat m_numberFormat;
    private static String m_strPercent = "";
    private boolean m_bSuperCalled = true;

    public HyperLinkField(JTextField jTextField) {
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(null);
        this.setEnabled(true);
        this.m_numberFormat = NumberFormat.getInstance();
        this.m_numberFormat.setGroupingUsed(false);
        this.m_numberFormat.setMaximumFractionDigits(Integer.MAX_VALUE);
        this.m_hyperLabel = new HyperLinkLabel(){

            @Override
            protected void showEditMenu() {
                super.showEditMenu();
                HyperLinkField.this.m_blnEscaped = false;
                HyperLinkField.this.m_editor.requestFocusInWindow();
                if (HyperLinkField.this.m_editor instanceof JTextField) {
                    ((JTextField)HyperLinkField.this.m_editor).selectAll();
                }
            }
        };
        this.m_hyperLabel.setName("m_hyperLabel");
        this.add(this.m_hyperLabel);
        this.m_percentLbl = new JLabel();
        this.m_percentLbl.setName("m_percentLbl");
        this.m_percentChkBox = new JCheckBox();
        this.m_percentChkBox.setName("m_percentChkBox");
        this.m_percentChkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                HyperLinkField.this.m_percentLbl.setText(HyperLinkField.this.m_percentChkBox.isSelected() ? m_strPercent : "");
                HyperLinkField.this.fireFocusLostEvent();
            }
        });
        this.setEditor(jTextField);
    }

    public HyperLinkField() {
        this(new JTextField(5));
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.m_blnIsEnabled != bl) {
            this.m_blnIsEnabled = bl;
            this.m_hyperLabel.setEnabled(bl);
            this.m_editor.setEnabled(bl);
            this.m_percentChkBox.setEnabled(bl);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = null;
        dimension = this.isHyperLink() ? super.getPreferredSize() : this.m_editor.getPreferredSize();
        return dimension;
    }

    @Override
    public void setHyperLink(boolean bl) {
        if (this.m_blnIsHyperLink != bl) {
            this.m_blnIsHyperLink = bl;
            this.removeAll();
            if (bl) {
                this.add(this.m_hyperLabel);
                if (this.isPercentVisible()) {
                    this.add(this.m_percentLbl);
                }
                this.m_hyperLabel.setContents(this.m_editor);
                this.m_hyperLabel.setText(this.getFieldText());
            } else {
                this.add(this.m_editor);
                if (this.isPercentVisible()) {
                    this.add(this.m_percentChkBox);
                }
            }
            this.revalidate();
        }
    }

    @Override
    public boolean isHyperLink() {
        return this.m_blnIsHyperLink;
    }

    public void setPercentVisible(boolean bl) {
        if (this.isPercentVisible() != bl) {
            this.m_blnPercentVisible = bl;
            if (this.m_blnIsHyperLink) {
                if (bl) {
                    this.add(this.m_percentLbl);
                } else {
                    this.remove(this.m_percentLbl);
                }
            } else if (bl) {
                this.add(this.m_percentChkBox);
            } else {
                this.remove(this.m_percentChkBox);
            }
            this.revalidate();
        }
    }

    public boolean isPercentVisible() {
        return this.m_blnPercentVisible;
    }

    public void setPercent(boolean bl) {
        this.m_percentLbl.setText(bl ? m_strPercent : "");
        this.m_percentChkBox.setSelected(bl);
        this.revalidate();
    }

    public boolean isPercent() {
        return this.m_percentChkBox.isSelected();
    }

    public void setText(String string) {
        if (this.m_editor instanceof JTextField) {
            ((JTextField)this.m_editor).setText(string);
        } else if (this.m_editor instanceof DateEditor) {
            try {
                ((DateEditor)this.m_editor).setDateString(string);
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
        }
        this.m_hyperLabel.setText(string);
    }

    public String getText() {
        return this.getFieldText();
    }

    private String getFieldText() {
        String string = null;
        if (this.m_editor != null) {
            if (this.m_editor instanceof NumberTextField) {
                Number number = ((NumberTextField)this.m_editor).getNumber();
                if (number != null) {
                    string = this.m_numberFormat.format(number.doubleValue());
                }
            } else if (this.m_editor instanceof JTextField) {
                string = ((JTextField)this.m_editor).getText();
            } else if (this.m_editor instanceof DateEditor) {
                string = ((DateEditor)this.m_editor).getDateString();
            }
        }
        return string;
    }

    public Component getEditor() {
        return this.m_editor;
    }

    public void setEditor(Component component) {
        this.m_editor = component;
        this.m_editor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!HyperLinkField.this.m_blnEscaped && HyperLinkField.this.m_enterPressed) {
                    if (HyperLinkField.this.validateField()) {
                        HyperLinkField.this.m_hyperLabel.setText(HyperLinkField.this.getFieldText());
                        HyperLinkField.this.fireFocusLostEvent();
                    }
                    HyperLinkField.this.m_enterPressed = false;
                } else {
                    HyperLinkField.this.m_blnEscaped = true;
                    if (HyperLinkField.this.m_editor instanceof JTextField) {
                        ((JTextField)HyperLinkField.this.m_editor).setText(HyperLinkField.this.m_hyperLabel.getText());
                    } else if (HyperLinkField.this.m_editor instanceof DateEditor) {
                        try {
                            ((DateEditor)HyperLinkField.this.m_editor).setDateString(HyperLinkField.this.m_hyperLabel.getText());
                        }
                        catch (ParseException parseException) {
                            parseException.printStackTrace();
                        }
                    }
                    HyperLinkField.this.m_hyperLabel.hideEditMenu();
                }
            }
        });
        this.m_editor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (HyperLinkField.this.isHyperLink()) {
                    if (keyEvent.getKeyCode() == 10) {
                        HyperLinkField.this.m_enterPressed = true;
                        if (HyperLinkField.this.validateField()) {
                            HyperLinkField.this.m_hyperLabel.hideEditMenu();
                        }
                        keyEvent.consume();
                    } else if (keyEvent.getKeyCode() == 27) {
                        HyperLinkField.this.m_blnEscaped = true;
                        if (HyperLinkField.this.m_editor instanceof JTextField) {
                            ((JTextField)HyperLinkField.this.m_editor).setText(HyperLinkField.this.m_hyperLabel.getText());
                        } else if (HyperLinkField.this.m_editor instanceof DateEditor) {
                            try {
                                ((DateEditor)HyperLinkField.this.m_editor).setDateString(HyperLinkField.this.m_hyperLabel.getText());
                            }
                            catch (ParseException parseException) {
                                parseException.printStackTrace();
                            }
                        }
                        HyperLinkField.this.m_hyperLabel.hideEditMenu();
                        keyEvent.consume();
                    }
                }
            }
        });
        if (this.isHyperLink()) {
            this.m_hyperLabel.setContents(this.m_editor);
            this.m_hyperLabel.setText(this.getFieldText());
        } else {
            this.removeAll();
            this.add(this.m_editor);
            this.revalidate();
        }
    }

    public void addFieldFocusListener(FocusListener focusListener) {
        this.m_focusListenerList.add(FocusListener.class, focusListener);
    }

    public void removeFieldFocusListener(FocusListener focusListener) {
        this.m_focusListenerList.remove(FocusListener.class, focusListener);
    }

    private void fireFocusLostEvent() {
        Object[] objectArray = this.m_focusListenerList.getListenerList();
        FocusEvent focusEvent = new FocusEvent(this.m_editor, 1005);
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != FocusListener.class) continue;
            FocusListener focusListener = (FocusListener)objectArray[i + 1];
            focusListener.focusLost(focusEvent);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    protected boolean validateField() {
        return true;
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.m_hyperLabel.setLblBackgroundColor(color);
    }
}

