/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.util;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.javatools.icons.OracleIcons;

public class ButtonMenu
extends JToggleButton {
    private static final Insets ICON_INSETS = new Insets(0, 0, 0, 4);
    private static final Insets TEXT_INSETS = new Insets(0, 2, 0, 2);
    private final PopupMenuListener listener;
    private final JPopupMenu popup = new JPopupMenu();
    private final Icon dropIcon;
    private static final int dropIconGap = 2;
    private static final int dropTextGap = 4;
    private List<JMenuItem> menuItems;

    public ButtonMenu(String string, Icon icon, List<JMenuItem> list) {
        this(string, icon, list, null);
    }

    public ButtonMenu(String string, Icon icon, List<JMenuItem> list, PopupMenuListener popupMenuListener) {
        super(string, icon);
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                if (ButtonMenu.this.listener != null) {
                    ButtonMenu.this.listener.popupMenuWillBecomeInvisible(new PopupMenuEvent(this));
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                if (ButtonMenu.this.listener != null) {
                    ButtonMenu.this.listener.popupMenuCanceled(new PopupMenuEvent(this));
                }
            }
        });
        this.dropIcon = OracleIcons.getIcon((String)"extras/dropdown.png");
        this.menuItems = list;
        this.listener = popupMenuListener;
        this.setMargin(string == null ? ICON_INSETS : TEXT_INSETS);
        this.setHorizontalAlignment(2);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ButtonMenu.this.toggle();
            }
        });
    }

    public static ButtonMenu createButtonMenu(String string, Icon icon, List<JMenuItem> list) {
        return new ButtonMenu(string, icon, list);
    }

    public void setMenuItems(List<JMenuItem> list) {
        this.menuItems = list;
    }

    private void toggle() {
        if (this.isSelected()) {
            this.popup.removeAll();
            if (this.menuItems == null || this.menuItems.isEmpty()) {
                return;
            }
            if (this.listener != null) {
                this.listener.popupMenuWillBecomeVisible(new PopupMenuEvent(this));
            }
            this.createPopup(this.menuItems);
            Point point = this.getLocationOnScreen();
            this.popup.pack();
            GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
            Rectangle rectangle = graphicsConfiguration.getBounds();
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
            Rectangle rectangle2 = new Rectangle();
            rectangle2.x = rectangle.x + insets.left;
            rectangle2.y = rectangle.y + insets.top;
            rectangle2.height = rectangle.height - insets.top - insets.bottom;
            rectangle2.width = rectangle.width - insets.left - insets.right;
            point.y += this.getHeight();
            if (point.y + this.popup.getHeight() > rectangle2.height) {
                point.y = point.y - this.popup.getHeight() - this.getHeight();
            }
            SwingUtilities.convertPointFromScreen(point, this);
            this.popup.show(this, point.x, point.y);
        } else if (this.popup.isVisible()) {
            this.popup.setVisible(false);
            this.popup.removeAll();
        }
    }

    private void toggle2() {
        if (this.isSelected()) {
            this.popup.removeAll();
            if (this.listener != null) {
                this.listener.popupMenuWillBecomeVisible(new PopupMenuEvent(this));
            }
            this.createPopup(this.menuItems);
            Point point = this.getLocationOnScreen();
            this.popup.pack();
            point.y += this.getHeight();
            SwingUtilities.convertPointFromScreen(point, this);
            this.popup.show(this, point.x, point.y);
        } else if (this.popup.isVisible()) {
            this.popup.setVisible(false);
            this.popup.removeAll();
        }
    }

    private void createPopup(List<JMenuItem> list) {
        for (JMenuItem jMenuItem : list) {
            if (jMenuItem == null) {
                this.popup.addSeparator();
                continue;
            }
            this.popup.add(jMenuItem);
        }
        this.popup.addPropertyChangeListener("visible", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!ButtonMenu.this.popup.isVisible() && ButtonMenu.this.isSelected()) {
                    ButtonMenu.this.setSelected(false);
                }
            }
        });
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.dropIcon.paintIcon(this, graphics, this.getWidth() - this.getInsets().right - this.dropIcon.getIconWidth(), this.getHeight() / 2 - this.dropIcon.getIconHeight() / 2);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width = dimension.width + (this.dropIcon.getIconWidth() + (this.getText() == null ? 2 : 4));
        dimension.height = Math.max(dimension.height, 20);
        return dimension;
    }
}

