/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.tree.view;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.hcs.util.actions.PopupMenuHandler;
import oracle.hcs.util.actions.data.Actions;
import oracle.hcs.util.context.Context;
import oracle.hcs.util.context.ContextCallback;

public class JTree2
extends JTree
implements ContextCallback,
TreeSelectionListener {
    private JPopupMenu popupMenu;

    public JTree2() {
        this.setupPopupMenuHandler();
    }

    public JTree2(TreeNode treeNode) {
        super(treeNode);
        this.setupPopupMenuHandler();
    }

    public JTree2(TreeModel treeModel) {
        super(treeModel);
        this.setupPopupMenuHandler();
    }

    public TreePath find(JTree jTree, Object[] objectArray) {
        TreeNode treeNode = (TreeNode)jTree.getModel().getRoot();
        return this.find2(jTree, new TreePath(treeNode), objectArray, 0, false);
    }

    public TreePath findByName(JTree jTree, String[] stringArray) {
        TreeNode treeNode = (TreeNode)jTree.getModel().getRoot();
        return this.find2(jTree, new TreePath(treeNode), stringArray, 0, true);
    }

    private TreePath find2(JTree jTree, TreePath treePath, Object[] objectArray, int n, boolean bl) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        Object object = treeNode;
        if (bl) {
            object = object.toString();
        }
        if (object.equals(objectArray[n])) {
            if (n == objectArray.length - 1) {
                return treePath;
            }
            if (treeNode.getChildCount() >= 0) {
                Enumeration<? extends TreeNode> enumeration = treeNode.children();
                while (enumeration.hasMoreElements()) {
                    TreeNode treeNode2 = enumeration.nextElement();
                    TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
                    TreePath treePath3 = this.find2(jTree, treePath2, objectArray, n + 1, bl);
                    if (treePath3 == null) continue;
                    return treePath3;
                }
            }
        }
        return null;
    }

    public void expandAll() {
        this.setAllExpansionState(true);
    }

    public void collapseAll() {
        this.setAllExpansionState(false);
    }

    public void setAllExpansionState(boolean bl) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (bl) {
                this.expandRow(i);
                continue;
            }
            this.collapseRow(i);
        }
    }

    public boolean isRoot(TreeNode treeNode) {
        return this.getModel().getRoot() == treeNode;
    }

    public static TreePath getPath(TreeNode treeNode) {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        while (treeNode != null) {
            arrayList.add(treeNode);
            treeNode = treeNode.getParent();
        }
        Collections.reverse(arrayList);
        return new TreePath(arrayList.toArray());
    }

    public void setActions(Class clazz, String string) throws Exception {
        PopupMenuHandler popupMenuHandler = new PopupMenuHandler(clazz, string, this);
        this.popupMenu = popupMenuHandler.getPopupMenu();
    }

    public void setActions(Actions actions) {
        PopupMenuHandler popupMenuHandler = new PopupMenuHandler(actions);
        this.popupMenu = popupMenuHandler.getPopupMenu();
    }

    public void setActions(List<AbstractAction> list) {
        this.popupMenu = new JPopupMenu();
        if (list != null) {
            for (Action action : list) {
                this.popupMenu.add(action);
            }
        }
    }

    private void setupPopupMenuHandler() {
        this.addTreeSelectionListener(this);
        this.addMouseListener(new MouseAdapter(){
            boolean clickHandled;

            private void showPopup(MouseEvent mouseEvent) {
                if (JTree2.this.popupMenu != null && JTree2.this.popupMenu.getComponentCount() == 0) {
                    this.forwardMouseClick(mouseEvent);
                    return;
                }
                if (mouseEvent.isPopupTrigger()) {
                    TreePath treePath = JTree2.this.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    JTree2.this.setSelectionPath(treePath);
                    if (JTree2.this.popupMenu != null) {
                        JTree2.this.popupMenu.show((JComponent)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                    }
                    this.clickHandled = true;
                } else {
                    this.forwardMouseClick(mouseEvent);
                }
            }

            private void forwardMouseClick(MouseEvent mouseEvent) {
                if (!this.clickHandled) {
                    JTree2.this.mouseClicked(mouseEvent);
                    this.clickHandled = true;
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.clickHandled = false;
                this.showPopup(mouseEvent);
            }
        });
    }

    protected void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void setupContext(Context context) {
        context.setSource(this);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
    }
}

