/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.tree.view;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.hcs.tree.model.CheckTreeSelectionModel;
import oracle.hcs.tree.view.CheckTreeCellRenderer;
import oracle.hcs.tree.view.JTree2;
import oracle.hcs.tree.view.NodeIcon;

public class CheckTreeManager
extends MouseAdapter
implements TreeSelectionListener,
KeyListener {
    private CheckTreeSelectionModel selectionModel;
    private JTree2 tree = new JTree2();
    int hotspot;
    private List<PropertyChangeListener> propertyChangeListeners;
    private boolean isPropertyChangeListenersOn;
    public static final String NODE_UNSELECTED_EVENT = "NODE_UNSELECTED";
    public static final String NODE_SELECTED_EVENT = "NODE_SELECTED";

    public CheckTreeManager(JTree2 jTree2) {
        this(jTree2, null);
    }

    public CheckTreeManager(JTree2 jTree2, NodeIcon nodeIcon) {
        this.hotspot = new JCheckBox().getPreferredSize().width;
        this.propertyChangeListeners = new ArrayList<PropertyChangeListener>();
        this.isPropertyChangeListenersOn = true;
        this.tree = jTree2;
        this.selectionModel = new CheckTreeSelectionModel(jTree2.getModel());
        jTree2.setCellRenderer(new CheckTreeCellRenderer(jTree2.getCellRenderer(), this.selectionModel, nodeIcon));
        jTree2.addMouseListener(this);
        jTree2.addKeyListener(this);
        this.selectionModel.addTreeSelectionListener(this);
    }

    public CheckTreeManager(JTree2 jTree2, TreeCellRenderer treeCellRenderer, CheckTreeSelectionModel checkTreeSelectionModel) {
        this.hotspot = new JCheckBox().getPreferredSize().width;
        this.propertyChangeListeners = new ArrayList<PropertyChangeListener>();
        this.isPropertyChangeListenersOn = true;
        this.tree = jTree2;
        this.selectionModel = checkTreeSelectionModel;
        jTree2.setCellRenderer(treeCellRenderer);
        jTree2.addMouseListener(this);
        jTree2.addKeyListener(this);
        checkTreeSelectionModel.addTreeSelectionListener(this);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 32) {
            TreeNode treeNode = (TreeNode)this.tree.getLastSelectedPathComponent();
            if (treeNode == null) {
                return;
            }
            TreePath treePath = JTree2.getPath(treeNode);
            if (treePath == null) {
                return;
            }
            this.processMouseClickOrKeyEvent(treePath);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        this.processMouseClickOrKeyEvent(treePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMouseClickOrKeyEvent(TreePath treePath) {
        PropertyChangeEvent propertyChangeEvent;
        block3: {
            boolean bl = this.selectionModel.isPathSelected(treePath, true);
            this.selectionModel.removeTreeSelectionListener(this);
            propertyChangeEvent = null;
            try {
                if (bl) {
                    this.selectionModel.removeSelectionPath(treePath);
                    propertyChangeEvent = new PropertyChangeEvent(this, NODE_UNSELECTED_EVENT, null, treePath);
                    break block3;
                }
                this.selectionModel.addSelectionPath(treePath);
                propertyChangeEvent = new PropertyChangeEvent(this, NODE_SELECTED_EVENT, null, treePath);
            }
            catch (Throwable throwable) {
                this.selectionModel.addTreeSelectionListener(this);
                this.tree.treeDidChange();
                this.firePropertyChangeEvent(propertyChangeEvent);
                throw throwable;
            }
        }
        this.selectionModel.addTreeSelectionListener(this);
        this.tree.treeDidChange();
        this.firePropertyChangeEvent(propertyChangeEvent);
    }

    public CheckTreeSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.tree.treeDidChange();
    }

    public void setSelected(TreePath treePath, boolean bl) {
        if (bl) {
            this.selectionModel.addSelectionPath(treePath);
        } else {
            this.selectionModel.removeSelectionPath(treePath);
        }
    }

    public void setSelectedAll(boolean bl) {
        Object object = this.tree.getModel().getRoot();
        TreePath treePath = null;
        if (object instanceof TreeNode) {
            TreeNode treeNode = (TreeNode)object;
            treePath = JTree2.getPath(treeNode);
            if (bl) {
                this.selectionModel.setSelectionPath(treePath);
            } else {
                this.selectionModel.removeSelectionPath(treePath);
            }
        }
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            boolean bl2 = true;
            for (MouseListener eventListener : this.tree.getMouseListeners()) {
                if (!(eventListener instanceof CheckTreeManager)) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                this.tree.addMouseListener(this);
            }
            bl2 = true;
            for (EventListener eventListener : this.tree.getKeyListeners()) {
                if (!(eventListener instanceof CheckTreeManager)) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                this.tree.addKeyListener(this);
            }
            bl2 = true;
            for (EventListener eventListener : this.selectionModel.getTreeSelectionListeners()) {
                if (!(eventListener instanceof CheckTreeManager)) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                this.selectionModel.addTreeSelectionListener(this);
            }
            this.setCheckTreeCellEnabled(true);
        } else {
            this.tree.removeMouseListener(this);
            this.tree.removeKeyListener(this);
            this.selectionModel.removeTreeSelectionListener(this);
            this.setCheckTreeCellEnabled(false);
        }
    }

    private void setCheckTreeCellEnabled(boolean bl) {
        CheckTreeCellRenderer checkTreeCellRenderer = (CheckTreeCellRenderer)this.tree.getCellRenderer();
        checkTreeCellRenderer.setCheckBoxEnabled(bl);
        this.tree.invalidate();
        this.tree.repaint();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (!this.propertyChangeListeners.contains(propertyChangeListener)) {
            this.propertyChangeListeners.add(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyChangeListeners.contains(propertyChangeListener)) {
            this.propertyChangeListeners.remove(propertyChangeListener);
        }
    }

    public void removeAllPropertyChangeListeners() {
        this.propertyChangeListeners.clear();
    }

    public void enablePropertyChangeListeners(boolean bl) {
        this.isPropertyChangeListenersOn = bl;
    }

    private void firePropertyChangeEvent(PropertyChangeEvent propertyChangeEvent) {
        if (this.isPropertyChangeListenersOn) {
            for (PropertyChangeListener propertyChangeListener : this.propertyChangeListeners) {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
    }
}

