/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.tree.model;

import java.lang.annotation.Annotation;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import oracle.hcs.tree.model.ColumnData;
import oracle.hcs.tree.model.ColumnEditable;
import oracle.hcs.tree.model.ColumnList;
import oracle.hcs.tree.model.Node;
import oracle.hcs.tree.model.TreeTableModel;

public abstract class AbstractTreeTableModel
implements TreeTableModel {
    protected Object root;
    protected EventListenerList listenerList = new EventListenerList();

    public AbstractTreeTableModel() {
    }

    public AbstractTreeTableModel(Object object) {
        this.root = object;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    public void setRoot(Object object) {
        this.root = object;
    }

    @Override
    public boolean isLeaf(Object object) {
        return this.getChildCount(object) == 0;
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        for (int i = 0; i < this.getChildCount(object); ++i) {
            if (!this.getChild(object, i).equals(object2)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(TreeModelListener.class, treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(TreeModelListener.class, treeModelListener);
    }

    protected void fireTreeNodesChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeNodesChanged(treeModelEvent);
        }
    }

    protected void fireTreeNodesInserted(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeNodesInserted(treeModelEvent);
        }
    }

    protected void fireTreeNodesRemoved(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeNodesRemoved(treeModelEvent);
        }
    }

    protected void fireTreeStructureChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeStructureChanged(treeModelEvent);
        }
    }

    @Override
    public Class getColumnClass(int n) {
        return Object.class;
    }

    @Override
    public boolean isCellEditable(Object object, int n) {
        Node node;
        boolean bl;
        boolean bl2 = bl = this.getColumnClass(n) == TreeTableModel.class;
        if (!bl && object instanceof Node && (node = (Node)object).getChildren().size() == 0) {
            Object object2 = node.getUserObject();
            for (Annotation annotation : object2.getClass().getAnnotations()) {
                ColumnList columnList;
                if (!(annotation instanceof ColumnList) || (columnList = (ColumnList)annotation).columns().length <= n) continue;
                bl = columnList.columns()[n].editable();
                return bl;
            }
            if (node.getUserObject() instanceof ColumnEditable) {
                ColumnEditable columnEditable = (ColumnEditable)node.getUserObject();
                return columnEditable.isEditable(n);
            }
        }
        return bl;
    }

    @Override
    public void setValueAt(Object object, Object object2, int n) {
        Node node;
        if (object2 instanceof Node && (node = (Node)object2).getUserObject() instanceof ColumnData) {
            ColumnData columnData = (ColumnData)node.getUserObject();
            columnData.setData(n, object);
        }
    }
}

