/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.tree.loader;

import oracle.hcs.tree.loader.TreeLoader;
import oracle.hcs.tree.model.DefaultNode;
import oracle.hcs.tree.model.HierarchyNodeData;
import oracle.hcs.tree.model.Node;
import oracle.hcs.tree.model.Tree;

public class TreeLoaderBreadthFirst
extends TreeLoader {
    final int MEMBER_CAPTION = 2;
    final int MEMBER_DESCRIPTION = 3;
    final int MEMBER_UNIQUE_NAME = 4;

    public TreeLoaderBreadthFirst(Tree tree) {
        super(tree);
    }

    public Node load(HierarchyNodeData hierarchyNodeData, Object object, int n) {
        Node node = null;
        if (hierarchyNodeData.parent != null) {
            node = this.getTree().findNode(hierarchyNodeData.parent, n - 1);
        }
        DefaultNode defaultNode = new DefaultNode(this.getTree(), node, object);
        if (node == null) {
            this.getTree().addRoot(defaultNode);
        }
        return defaultNode;
    }

    @Override
    public void changeDisplayColumn(int n) {
        block4: for (Node node : this.getTree().getRoots()) {
            switch (n) {
                case 1: {
                    this.traverse(node, 3);
                    continue block4;
                }
                case 2: {
                    this.traverse(node, 4);
                    continue block4;
                }
            }
            this.traverse(node, 2);
        }
    }

    private void traverse(Node node, int n) {
        if (node != null) {
            HierarchyNodeData hierarchyNodeData = (HierarchyNodeData)node.getUserObject();
            hierarchyNodeData.setData(1, hierarchyNodeData.getData(n));
            for (Node node2 : node.getChildren()) {
                this.traverse(node2, n);
            }
        }
    }
}

