/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.templates.templateview;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AVDimensionality;
import oracle.hcs.db.model.NamedObjectWithDesc;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.dimension.model.DimensionLevel;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.hierarchy.model.HierarchyLevel;
import oracle.hcs.templates.stringexpr.NameSyntaxParseException;
import oracle.hcs.templates.stringexpr.ParamValue;
import oracle.hcs.templates.stringexpr.ParseException;
import oracle.hcs.templates.stringexpr.StringExprParser;
import oracle.hcs.templates.stringexpr.TokenMgrError;
import oracle.hcs.templates.templatelist.BaseTemplate;
import oracle.hcs.templates.templatelist.Param;
import oracle.hcs.templates.templatelist.Template;
import oracle.hcs.templates.templatelist.TemplateGroup;
import oracle.hcs.templates.templatelist.TemplateList;
import oracle.hcs.templates.templatelist.TemplateNameFormat;
import oracle.hcs.templates.templateview.BaseTemplateHyperView;
import oracle.hcs.templates.templateview.TemplateContext;
import oracle.hcs.templates.templateview.TemplateGroupHyperView;
import oracle.hcs.templates.templateview.TemplateHyperContext;
import oracle.hcs.templates.templateview.TemplateHyperParam;

public class TemplateHyperView
extends BaseTemplateHyperView {
    private static final Logger LOG = Logger.getLogger(TemplateHyperView.class.getName());
    private String desc;
    private String nameSuffix;
    private JCheckBox checkBox;
    private TemplateNameFormat templateNameFormat;
    private AVBaseMeasure baseMeasure;
    private Hierarchy levelHier;

    public TemplateHyperView(TemplateGroupHyperView templateGroupHyperView, TemplateContext templateContext, TemplateHyperContext templateHyperContext, boolean bl, Template template, TemplateGroup templateGroup) {
        this(templateGroupHyperView, templateContext, templateHyperContext, bl, template, templateGroup, null, null);
    }

    public TemplateHyperView(TemplateGroupHyperView templateGroupHyperView, TemplateContext templateContext, TemplateHyperContext templateHyperContext, boolean bl, Template template, TemplateGroup templateGroup, Map<String, String> map, ParamValue paramValue) {
        super(templateGroupHyperView, templateContext, templateHyperContext, bl, template, templateGroup, map, paramValue);
        if (template != null) {
            this.desc = template.getName();
            this.nameSuffix = "_" + template.getType();
            if (templateHyperContext.getResources() != null && template.getTemplateList() != null) {
                this.desc = templateHyperContext.getResources().getXLIFFResource(template.getTemplateList().getFileName(), this.desc);
            }
            this.checkBox = new JCheckBox(this.desc);
            this.checkBox.setSelected(template.isSelected());
        }
    }

    @Override
    public TemplateList getTemplateList() {
        BaseTemplate baseTemplate = this.getTemplate();
        return baseTemplate.getTemplateList();
    }

    public JCheckBox getCheckBox() {
        return this.checkBox;
    }

    public String getType() {
        return this.getTemplate().getType();
    }

    public void setDesc(String string) {
        this.desc = string;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getDescSuffix() {
        return " " + this.desc;
    }

    @Override
    protected String getUi() {
        if (this.getTemplateGroup().getUi() == null && this.getTemplate() != null) {
            return this.getTemplate().getUi();
        }
        return null;
    }

    @Override
    public boolean setupTemplateHyperParamDependencies(List<TemplateHyperParam> list) {
        boolean bl = this.setupHyperParamDependencies(list);
        return bl;
    }

    public TemplateNameFormat getTemplateNameFormat() {
        return this.templateNameFormat;
    }

    public void setTemplateNameFormat(TemplateNameFormat templateNameFormat) {
        this.templateNameFormat = templateNameFormat;
    }

    public void setNameSuffix(String string) {
        this.nameSuffix = string;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public void setEnabled(boolean bl) {
        this.checkBox.setEnabled(bl);
    }

    public boolean isEnabled() {
        return this.checkBox.isEnabled();
    }

    public boolean isSelected() {
        return this.checkBox.isSelected();
    }

    @Override
    public Param getParam(String string) {
        Template template = (Template)this.getTemplate();
        if (template != null && template.getParams() != null) {
            for (Param param : template.getParams()) {
                if (param.getName() == null || !param.getName().equals(string)) continue;
                return param;
            }
        }
        return super.getParam(string);
    }

    public String generateName(String string, AVBaseMeasure aVBaseMeasure, Hierarchy hierarchy, String string2) throws NameSyntaxParseException, SQLException, IOException {
        if (string.equalsIgnoreCase("name")) {
            return this.generateName(aVBaseMeasure, hierarchy, string2);
        }
        if (string.equalsIgnoreCase("description")) {
            return this.generateDescription(aVBaseMeasure, hierarchy, string2);
        }
        if (string.equalsIgnoreCase("caption")) {
            return this.generateCaption(aVBaseMeasure, hierarchy, string2);
        }
        return "";
    }

    public String generateName(AVBaseMeasure aVBaseMeasure, Hierarchy hierarchy, String string) throws NameSyntaxParseException, SQLException, IOException {
        String string2;
        Object object = aVBaseMeasure.getName() + string;
        if (this.templateNameFormat != null && this.templateNameFormat.getName() != null && (string2 = this.generateFromRule(this.templateNameFormat.getName(), aVBaseMeasure, hierarchy)).trim().length() > 0) {
            object = string2;
        }
        if (((String)(object = ((String)object).replace(' ', '_'))).length() > 30) {
            object = ((String)object).substring(0, 30);
        }
        return object;
    }

    public String generateDescription(AVBaseMeasure aVBaseMeasure, Hierarchy hierarchy, String string) throws NameSyntaxParseException, SQLException, IOException {
        String string2;
        String string3 = aVBaseMeasure.getDescription() + string;
        if (this.templateNameFormat != null && this.templateNameFormat.getDescription() != null && (string2 = this.generateFromRule(this.templateNameFormat.getDescription(), aVBaseMeasure, hierarchy)).trim().length() > 0) {
            return string2;
        }
        return string3;
    }

    public String generateCaption(AVBaseMeasure aVBaseMeasure, Hierarchy hierarchy, String string) throws NameSyntaxParseException, SQLException, IOException {
        String string2;
        String string3 = aVBaseMeasure.getDescription() + string;
        if (this.templateNameFormat != null && this.templateNameFormat.getCaption() != null && (string2 = this.generateFromRule(this.templateNameFormat.getCaption(), aVBaseMeasure, hierarchy)).trim().length() > 0) {
            return string2;
        }
        return string3;
    }

    public String generateFromRule(String string, AVBaseMeasure aVBaseMeasure, Hierarchy hierarchy) throws NameSyntaxParseException, SQLException, IOException {
        try {
            this.baseMeasure = aVBaseMeasure;
            this.levelHier = hierarchy;
            List<String> list = this.getVisibleParamNames();
            String string2 = StringExprParser.getParseTree(string, this, list);
            return string2;
        }
        catch (ParseException parseException) {
            NameSyntaxParseException nameSyntaxParseException = new NameSyntaxParseException(string, parseException);
            throw nameSyntaxParseException;
        }
        catch (TokenMgrError tokenMgrError) {
            NameSyntaxParseException nameSyntaxParseException = new NameSyntaxParseException(string, tokenMgrError);
            throw nameSyntaxParseException;
        }
        catch (RuntimeException runtimeException) {
            NameSyntaxParseException nameSyntaxParseException = new NameSyntaxParseException(string, runtimeException);
            throw nameSyntaxParseException;
        }
    }

    private String getObjectValue(String string, AVBaseMeasure aVBaseMeasure, Hierarchy hierarchy) throws SQLException, IOException {
        if (string.startsWith("{")) {
            string = string.substring(1, string.length());
        }
        if (string.startsWith("}")) {
            string = string.substring(0, string.length() - 1);
        }
        if ((string = string.trim()).toLowerCase().startsWith("measure")) {
            string = string.length() > "measure_".length() ? string.substring("measure_".length(), string.length()) : "name";
            return TemplateHyperView.getObjectDesc(aVBaseMeasure, string);
        }
        if (string.toLowerCase().startsWith("hierarchy_level")) {
            Object object = this.getProperty("hierarchy_level");
            if (object instanceof NamedObjectWithDesc) {
                String string2 = "name";
                if (string.startsWith("hierarchy_level_")) {
                    string2 = string.substring("hierarchy_level_".length(), string.length());
                }
                NamedObjectWithDesc namedObjectWithDesc = (NamedObjectWithDesc)object;
                return TemplateHyperView.getObjectDesc(namedObjectWithDesc, string2);
            }
            if (object != null) {
                return object.toString();
            }
            return "";
        }
        if (string.toLowerCase().startsWith("hierarchy")) {
            string = string.substring("hierarchy_".length(), string.length());
            return TemplateHyperView.getObjectDesc(hierarchy, string);
        }
        if (string.toLowerCase().startsWith("level")) {
            HierarchyLevel hierarchyLevel;
            string = string.length() > "level_".length() ? string.substring("level_".length(), string.length()) : "name";
            Object object = this.getProperty("LEVEL");
            if (object instanceof HierarchyLevel && (hierarchyLevel = (HierarchyLevel)object) != null) {
                DimensionLevel dimensionLevel = hierarchyLevel.getLevel();
                return TemplateHyperView.getObjectDesc(dimensionLevel, string);
            }
        } else if (string.toLowerCase().startsWith("dimension")) {
            string = string.length() > "dimension_".length() ? string.substring("dimension_".length(), string.length()) : "name";
            Object object = this.getProperty("DIMENSION");
            if (object instanceof AttributeDimension) {
                AttributeDimension attributeDimension = (AttributeDimension)object;
                return TemplateHyperView.getObjectDesc(attributeDimension, string);
            }
            if (object instanceof AVDimensionality) {
                AVDimensionality aVDimensionality = (AVDimensionality)object;
                return TemplateHyperView.getObjectDesc(aVDimensionality, string);
            }
        } else {
            Object object = this.getProperty(string);
            if (object != null) {
                if (object instanceof String) {
                    return (String)object;
                }
                return object.toString();
            }
        }
        return "";
    }

    public static String getObjectDesc(NamedObjectWithDesc namedObjectWithDesc, String string) {
        String string2 = namedObjectWithDesc.getName();
        if (string.equalsIgnoreCase("name")) {
            return string2;
        }
        if (string.equalsIgnoreCase("description")) {
            string2 = namedObjectWithDesc.getDescription();
        }
        if (string.equalsIgnoreCase("caption")) {
            string2 = namedObjectWithDesc.getCaption();
        }
        if (string2 == null || string2.length() == 0) {
            string2 = namedObjectWithDesc.getName();
        }
        return string2;
    }

    public static String getObjectDesc(AVDimensionality aVDimensionality, String string) {
        String string2 = aVDimensionality.getName();
        if (string.equalsIgnoreCase("name")) {
            return string2;
        }
        if (string2 == null || string2.length() == 0) {
            string2 = aVDimensionality.getName();
        }
        return string2;
    }

    @Override
    public Object getValue(String string) {
        String string2 = null;
        try {
            if (string.equalsIgnoreCase("index$")) {
                int n = this.getParentTemplateHyperView().indexOf(this);
                return new Integer(n);
            }
            string2 = this.getObjectValue(string, this.baseMeasure, this.levelHier);
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return string2;
    }

    @Override
    public String getName() {
        if (this.getTemplate() != null) {
            return this.getTemplate().getName();
        }
        return null;
    }

    @Override
    public List<TemplateHyperParam> getHyperParams() {
        TemplateGroupHyperView templateGroupHyperView;
        BaseTemplateHyperView baseTemplateHyperView = this.getParentTemplateHyperView();
        if (baseTemplateHyperView instanceof TemplateGroupHyperView && (templateGroupHyperView = (TemplateGroupHyperView)baseTemplateHyperView) != null && templateGroupHyperView.getUi() != null) {
            return templateGroupHyperView.getHyperParams();
        }
        return super.getHyperParams();
    }

    @Override
    public String getExpression() throws SQLException, IOException {
        String string = this.getExpression(null);
        return string;
    }

    public String getExpression(AVBaseMeasure aVBaseMeasure) throws SQLException, IOException {
        if (this.getTemplate() == null) {
            return null;
        }
        String string = this.getTemplate().getExpression();
        return this.getExpression(string, aVBaseMeasure);
    }

    private TemplateNameFormat getDependentTemplateNameFormat() {
        Template template = (Template)this.getTemplate();
        String string = template.getTemplateDependencies().get(0).getType();
        for (Template template2 : this.getTemplateList().getTemplatesOnly()) {
            if (template2.getType() == null || !template2.getType().equalsIgnoreCase(string)) continue;
            return template2.getTemplateNameFormat();
        }
        return null;
    }

    public void checkDependentTemplateView(String string) {
    }

    public void checkReferencedTemplateView(String string) {
    }
}

