/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.templates.templateview;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.syntaxbuilder.HCSSyntaxType;
import oracle.hcs.templates.syntaxparser.ParseNode;
import oracle.hcs.templates.templateview.TemplateHyperParam;
import oracle.hcs.util.HyperLabel;
import oracle.hcs.util.HyperLabelActionListener;

public class TemplateHyperParamBaseDimension
extends TemplateHyperParam {
    private HyperLabel hyperLabel = new HyperLabel("");
    private AttributeDimension dimension;
    private String member;
    private static final Logger LOG = Logger.getLogger(TemplateHyperParamBaseDimension.class.getName());
    private static final ParseNode pattern = new ParseNode("base_dimension", HCSSyntaxType.DIMENSION.toString(), ParseNode.PatternType.NONE);

    public TemplateHyperParamBaseDimension() {
        this.hyperLabel.addActionListener(new HyperLabelActionListener(){

            @Override
            public void actionPerformed(Object object, String string) {
            }
        });
    }

    @Override
    public ParseNode getPattern() {
        return pattern;
    }

    public void setDimension(AttributeDimension attributeDimension) throws SQLException, IOException {
        this.dimension = attributeDimension;
        this.hyperLabel.setText(attributeDimension.getName());
    }

    @Override
    public String getExpression() {
        if (this.dimension != null) {
            if (this.member == null) {
                return this.dimension.getName();
            }
            return this.dimension.getName() + "='" + this.member + "'";
        }
        return "";
    }

    @Override
    public Object getValue() {
        if (this.dimension != null) {
            if (this.member == null) {
                return this.dimension.getName();
            }
            return this.dimension.getName() + "='" + this.member + "'";
        }
        return "";
    }

    @Override
    public boolean setValue(Object object) {
        if (object instanceof String) {
            this.hyperLabel.setText((String)object);
        }
        return true;
    }

    @Override
    public Component getComponent() {
        return this.hyperLabel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    @Override
    public void init() {
        if (this.getTemplateContext().getBaseDimension() != null) {
            try {
                this.setDimension(this.getTemplateContext().getBaseDimension());
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, exception.getLocalizedMessage(), exception);
            }
        }
    }

    @Override
    public int getPixelSize(int n) {
        return this.hyperLabel.getFontMetrics(this.hyperLabel.getFont()).stringWidth(this.getExpression());
    }
}

