/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.templates.syntaxparser;

import java.util.HashSet;
import java.util.List;
import oracle.hcs.syntaxbuilder.HCSSyntaxType;
import oracle.hcs.templates.syntaxparser.ParseNode;
import oracle.hcs.templates.templateview.TemplateHyperParam;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FlatNode {
    protected FlatNode prev;
    protected FlatNode special;
    protected FlatNode next;
    boolean checkName;
    String value;
    String type;
    String paramName;
    ParseNode.PatternType patternType;
    private static final HashSet<String> MEASURE_ALTS = new HashSet(4);

    FlatNode() {
    }

    FlatNode(ParseNode parseNode, String string) {
        if (parseNode != null) {
            this.value = parseNode.getValue();
            this.type = parseNode.getType();
            this.patternType = parseNode.getPatternType();
            this.checkName = parseNode.isCheckName();
        }
        this.paramName = string;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof FlatNode) {
            FlatNode flatNode = (FlatNode)object;
            if (this.compare(this.value, flatNode.value) && this.compare(this.type, flatNode.type) && this.checkName == flatNode.checkName && this.patternType == flatNode.patternType) {
                return true;
            }
        }
        return false;
    }

    private boolean compare(String string, String string2) {
        return string == string2 || string != null && string.equals(string2);
    }

    public String toString() {
        return this.toString(0);
    }

    public Element marshall(Document document, Element element) {
        Element element2 = document.createElement(this.getClass().getSimpleName());
        element2.setAttribute("value", this.getValue());
        element2.setAttribute("type", this.getType());
        element2.setAttribute("paramName", this.getParamName());
        element2.setAttribute("patternType", this.getPatternType().toString());
        element2.setAttribute("checkName", String.valueOf(this.isCheckName()));
        element.appendChild(element2);
        return element2;
    }

    public String toString(int n) {
        return String.format("%s;paramName=%s:type=%s:checkName=%s:patternType=%s:%s", new Object[]{this.value, this.paramName == null ? "_" : this.paramName, this.type, this.checkName, this.patternType, this.hashCode()});
    }

    public FlatNode getNext() {
        return this.next;
    }

    public FlatNode getPrev() {
        return this.prev;
    }

    public FlatNode getSpecial() {
        return this.special;
    }

    FlatNode linkNext(FlatNode flatNode) {
        this.next = flatNode;
        flatNode.prev = this;
        return flatNode;
    }

    FlatNode linkSpecial(FlatNode flatNode) {
        this.special = flatNode;
        return flatNode;
    }

    public boolean isCheckName() {
        return this.checkName;
    }

    public void setCheckName(boolean bl) {
        this.checkName = bl;
    }

    public String getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    public String getParamName() {
        return this.paramName;
    }

    public ParseNode.PatternType getPatternType() {
        return this.patternType;
    }

    public void restartMatch() {
    }

    public FlatNode nextMatch() {
        return this.getNext();
    }

    int matches(ParseNode parseNode) {
        int n = 0;
        n = !this.isCheckName() ? (HCSSyntaxType.MEASURE.toString().equals(this.getType()) && this.isMeasureAlternative(parseNode.getType()) ? ++n : (this.getType().equals(parseNode.getType()) ? ++n : 0)) : (this.getValue().equalsIgnoreCase((String)parseNode.getUserObject()) && this.getType().equals(parseNode.getType()) ? ++n : 0);
        return n;
    }

    private boolean isMeasureAlternative(String string) {
        return MEASURE_ALTS.contains(string);
    }

    public boolean tryLoad(List<TemplateHyperParam> list, ParseNode parseNode) {
        if (this.paramName != null && parseNode != null) {
            for (TemplateHyperParam templateHyperParam : list) {
                if (!templateHyperParam.getName().equals(this.getParamName())) continue;
                templateHyperParam.setValue(parseNode);
                list.remove(templateHyperParam);
                return true;
            }
        }
        return false;
    }

    static {
        MEASURE_ALTS.add(HCSSyntaxType.FUNCTION.toString());
        MEASURE_ALTS.add(HCSSyntaxType.OPERATOR.toString());
        MEASURE_ALTS.add(HCSSyntaxType.MEASURE.toString());
        MEASURE_ALTS.add(HCSSyntaxType.QDR.toString());
    }
}

