/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntaxbuilder.spectree;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.hcs.HCSArb;
import oracle.hcs.syntaxbuilder.specification.Spec;
import oracle.hcs.syntaxbuilder.specification.SpecTreeNode;
import oracle.hcs.syntaxbuilder.spectree.SpecTreeModel;
import oracle.hcs.templates.templateview.AbstractTemplateJTree;
import oracle.hcs.templates.templateview.TemplateGUI;
import oracle.hcs.util.ErrorDisplay;

public class SpecJTree
extends AbstractTemplateJTree
implements TreeSelectionListener {
    public static final String ENCODING = "UTF-8";
    private transient Spec spec;
    private transient ErrorDisplay errorDisplay;
    boolean showLeaves;
    private JPopupMenu popupMenu;

    public SpecJTree(Spec spec, ErrorDisplay errorDisplay, boolean bl, boolean bl2) {
        super(new SpecTreeModel(spec.getRootNode(), bl, bl2));
        this.spec = spec;
        this.errorDisplay = errorDisplay;
        this.showLeaves = bl2;
        this.setCellRenderer(new IconTreeCellRenderer());
        this.setShowsRootHandles(true);
        this.setRootVisible(false);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
        this.addTreeSelectionListener(this);
    }

    public void reload() {
        ((SpecTreeModel)this.getModel()).reload();
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        SpecTreeNode specTreeNode;
        TreePath treePath = this.getPathForLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
        if (treePath != null && (specTreeNode = (SpecTreeNode)treePath.getLastPathComponent()).isLeaf()) {
            if (specTreeNode.getTemplateHelper() != null) {
                TemplateGUI templateGUI = specTreeNode.getTemplateHelper().getGUI(true);
                try {
                    String string = templateGUI.getSyntax();
                    if (string != null) {
                        return string;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return ((SpecTreeNode)treePath.getLastPathComponent()).getTemplate();
        }
        return null;
    }

    @Override
    public void valueChanged(final TreeSelectionEvent treeSelectionEvent) {
        SpecTreeNode specTreeNode = (SpecTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
        if (specTreeNode != null && specTreeNode.getTemplateHelper() != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpecJTree.this.startEditingAtPath(treeSelectionEvent.getPath());
                }
            });
        }
    }

    public boolean isShowLeaves() {
        return this.showLeaves;
    }

    public Spec getSpec() {
        return this.spec;
    }

    class LoadXMLAction
    extends AbstractAction {
        File lastLoaded;

        public LoadXMLAction(String string) {
            super(string);
            this.lastLoaded = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TreePath treePath = SpecJTree.this.getSelectionPath();
            if (treePath == null) {
                return;
            }
            SpecTreeNode specTreeNode = (SpecTreeNode)treePath.getLastPathComponent();
            JFileChooser jFileChooser = new JFileChooser();
            if (this.lastLoaded != null) {
                jFileChooser.setCurrentDirectory(this.lastLoaded.getParentFile());
            }
            jFileChooser.setFileFilter(new FileNameExtensionFilter("*.xml", "xml"));
            jFileChooser.showOpenDialog(SpecJTree.this);
            File file = jFileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                SpecJTree.this.spec.parseReader(specTreeNode, new InputStreamReader((InputStream)fileInputStream, SpecJTree.ENCODING));
                ((SpecTreeModel)SpecJTree.this.getModel()).nodeStructureChanged(specTreeNode);
                this.lastLoaded = file;
            }
            catch (IOException iOException) {
                SpecJTree.this.errorDisplay.show(iOException, HCSArb.getString("EXPRESSIONBUILDER_SPEC_FILE_ERROR_MESSAGE"), HCSArb.getString("EXPRESSION_EDITOR_SPEC_ERROR_TITLE"), (Component)SpecJTree.this);
            }
        }
    }

    static class IconTreeCellRenderer
    extends DefaultTreeCellRenderer {
        IconTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Icon icon;
            SpecTreeNode specTreeNode = (SpecTreeNode)object;
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, specTreeNode.isLeaf(), n, bl4);
            if (component instanceof JLabel && (icon = specTreeNode.getIcon()) != null) {
                ((JLabel)component).setIcon(icon);
            }
            return component;
        }
    }
}

