/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntaxbuilder.shuttle;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import oracle.hcs.syntaxbuilder.shuttle.GuiNodeSelector;
import oracle.hcs.syntaxbuilder.specification.SpecTreeNode;
import oracle.hcs.templates.templateview.TemplateData;

public class InputHandler
extends MouseAdapter {
    private static final Logger LOG = Logger.getLogger(InputHandler.class.getName());
    private static final TemplateData.Mode[] modes = new TemplateData.Mode[]{TemplateData.Mode.REPLACE, TemplateData.Mode.WRAP, TemplateData.Mode.REPLACEALL};
    private static final KeyStroke[] insertKeyStrokes = new KeyStroke[]{KeyStroke.getKeyStroke(10, 0), KeyStroke.getKeyStroke(39, 128)};
    private final JPopupMenu popupMenu;
    private final InsertAction[] actions = new InsertAction[3];
    private final InsertAction defaultAction = new InsertAction(null);
    private final GuiNodeSelector selector;

    public InputHandler(GuiNodeSelector guiNodeSelector, ActionMap actionMap, InputMap inputMap) {
        this.selector = guiNodeSelector;
        this.popupMenu = new JPopupMenu();
        for (int i = 0; i < modes.length; ++i) {
            this.actions[i] = new InsertAction(modes[i]);
            this.popupMenu.add(this.actions[i]);
        }
        for (KeyStroke keyStroke : insertKeyStrokes) {
            inputMap.put(keyStroke, "INSERT_NODE");
            actionMap.put("INSERT_NODE", this.defaultAction);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.selector.selectClickedNode(mouseEvent);
            this.defaultAction.actionPerformed(null);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
    }

    private void checkPopup(MouseEvent mouseEvent) {
        SpecTreeNode specTreeNode;
        if (mouseEvent.isPopupTrigger() && (specTreeNode = this.selector.selectClickedNode(mouseEvent)) != null) {
            if (specTreeNode.getTemplateHelper() != null) {
                TemplateData.Mode[] modeArray = specTreeNode.getTemplateHelper().availableModes(modes);
                int n = 0;
                for (int i = 0; i < this.actions.length; ++i) {
                    if (n < modeArray.length && this.actions[i].buttons[0] == modeArray[n]) {
                        ++n;
                        this.actions[i].setEnabled(true);
                        continue;
                    }
                    this.actions[i].setEnabled(false);
                }
            } else {
                this.actions[0].setEnabled(true);
                this.actions[1].setEnabled(false);
                this.actions[2].setEnabled(false);
            }
            this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private class InsertAction
    extends AbstractAction {
        final TemplateData.Mode[] buttons;

        InsertAction(TemplateData.Mode mode) {
            if (mode != null) {
                this.putValue("Name", mode.toString());
                this.buttons = new TemplateData.Mode[]{mode};
            } else {
                this.buttons = null;
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SpecTreeNode specTreeNode = InputHandler.this.selector.getSelectedNode();
            if (specTreeNode == null) {
                return;
            }
            try {
                if (this.buttons != null) {
                    InputHandler.this.selector.getTemplateHandler().insertNode(specTreeNode, this.buttons);
                } else {
                    InputHandler.this.selector.getTemplateHandler().insertNode(specTreeNode);
                }
            }
            catch (Throwable throwable) {
                LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
            }
        }
    }
}

