/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntaxbuilder.parsetree;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import oracle.hcs.syntaxbuilder.shuttle.TemplateHandler;
import oracle.hcs.syntaxbuilder.specification.Spec;
import oracle.hcs.syntaxbuilder.specification.SpecTreeNode;
import oracle.hcs.templates.syntaxparser.ParseNode;
import oracle.hcs.templates.templateview.TemplateData;

public class ParseJTree
extends JTree {
    private static final Logger LOG = Logger.getLogger(ParseJTree.class.getName());
    private static final TemplateData.Mode[] EDITBUTTONS = new TemplateData.Mode[]{TemplateData.Mode.OK};
    private transient TemplateHandler handler;

    public ParseJTree(TreeModel treeModel, final Spec spec) {
        super(treeModel);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        treeModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                this.expandAll();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                this.expandAll();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                this.expandAll();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                this.expandAll();
            }

            private void expandAll() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; i < ParseJTree.this.getRowCount(); ++i) {
                            ParseJTree.this.expandRow(i);
                        }
                    }
                });
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ParseNode parseNode;
                if (ParseJTree.this.handler != null && mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1 && (parseNode = (ParseNode)ParseJTree.this.getLastSelectedPathComponent()) != null) {
                    try {
                        SpecTreeNode specTreeNode = spec.findMatchingNode(parseNode);
                        ParseJTree.this.handler.insertNode(specTreeNode, EDITBUTTONS);
                    }
                    catch (Throwable throwable) {
                        LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
                    }
                }
            }
        });
    }

    public void setShuttleHandler(TemplateHandler templateHandler) {
        this.handler = templateHandler;
    }

    public TemplateHandler getShuttleHandler() {
        return this.handler;
    }
}

