/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax;

import java.util.List;
import oracle.hcs.syntax.HierarchyQualifier;
import oracle.hcs.syntax.SyntaxObject;
import oracle.hcs.syntax.SyntaxObjectVisitor;
import oracle.hcs.syntax.SyntaxPrintingContext;
import oracle.hcs.syntax.TypedExpression;
import oracle.hcs.syntax.ValidationContext;

public final class QualifyExpression
extends TypedExpression {
    private HierarchyQualifier[] m_Qualifiers;
    private TypedExpression m_BaseExpression;

    public HierarchyQualifier[] getQualifiersInternal() {
        return this.m_Qualifiers;
    }

    private QualifyExpression(TypedExpression typedExpression, HierarchyQualifier[] hierarchyQualifierArray, boolean bl) {
        QualifyExpression.validateValue(typedExpression);
        if (hierarchyQualifierArray != null) {
            QualifyExpression.validateValues(hierarchyQualifierArray, 1);
            this.m_Qualifiers = (HierarchyQualifier[])hierarchyQualifierArray.clone();
        }
        this.m_BaseExpression = typedExpression;
        this.initialize();
    }

    private static HierarchyQualifier[] createQualifierArray(List<HierarchyQualifier> list) {
        if (null == list) {
            return null;
        }
        HierarchyQualifier[] hierarchyQualifierArray = new HierarchyQualifier[list.size()];
        list.toArray(hierarchyQualifierArray);
        return hierarchyQualifierArray;
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.append("QUALIFY(");
        syntaxPrintingContext.print(this.getBaseExpression());
        syntaxPrintingContext.append(", ");
        for (int i = 0; i < this.getQualifiersInternal().length; ++i) {
            if (0 != i) {
                syntaxPrintingContext.append(", ");
            }
            syntaxPrintingContext.print(this.getQualifiersInternal()[i]);
        }
        syntaxPrintingContext.append(")");
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        this.m_BaseExpression = validationContext.validateExp(this.m_BaseExpression);
        validationContext.pop();
        if (this.getQualifiersInternal() != null) {
            validationContext.validateComponents(this, this.getQualifiersInternal());
        }
        this.setDataType(this.getBaseExpression().getDataType());
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        return this.getBaseExpression().isDefinitionComplete() && this.areComponentsComplete(this.getQualifiersInternal());
    }

    public QualifyExpression(TypedExpression typedExpression, HierarchyQualifier[] hierarchyQualifierArray) {
        this(typedExpression, hierarchyQualifierArray, true);
    }

    public QualifyExpression(TypedExpression typedExpression, List<HierarchyQualifier> list) {
        this(typedExpression, QualifyExpression.createQualifierArray(list), false);
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitQualifyExpression(this, object);
    }

    public TypedExpression getBaseExpression() {
        return this.m_BaseExpression;
    }

    public HierarchyQualifier[] getQualifiers() {
        return (HierarchyQualifier[])this.m_Qualifiers.clone();
    }

    @Override
    public boolean isCompositeObject() {
        return true;
    }
}

