/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax;

import oracle.hcs.syntax.DataType;
import oracle.hcs.syntax.FunctionArgument;
import oracle.hcs.syntax.LiteralExpression;
import oracle.hcs.syntax.SyntaxException;
import oracle.hcs.syntax.SyntaxObjectVisitor;
import oracle.hcs.syntax.SyntaxPrintingContext;

public final class NumberExpression
extends LiteralExpression
implements FunctionArgument {
    private Number m_Value;

    private void setValue(Number number) {
        this.m_Value = number;
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.append(this.getValue());
    }

    public void _negateNumber() {
        if (this.getValue() instanceof Integer) {
            int n = (Integer)this.getValue();
            this.setValue(new Integer(-n));
        } else if (this.getValue() instanceof Short) {
            short s = (Short)this.getValue();
            this.setValue(new Short(-s));
        } else if (this.getValue() instanceof Long) {
            long l = (Long)this.getValue();
            this.setValue(new Long(-l));
        } else if (this.getValue() instanceof Float) {
            float f = ((Float)this.getValue()).floatValue();
            this.setValue(new Float(-f));
        } else if (this.getValue() instanceof Double) {
            double d = (Double)this.getValue();
            this.setValue(new Double(-d));
        } else if (this.getValue() instanceof Byte) {
            byte by = (Byte)this.getValue();
            this.setValue(new Byte(-by));
        } else {
            throw new SyntaxException("UnexpectedSyntaxError", "");
        }
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitNumberExpression(this, object);
    }

    public NumberExpression(Number number) {
        NumberExpression.validateValue(number);
        this.setValue(number);
        this.setDataType(DataType.NUMBER);
    }

    public NumberExpression(int n) {
        this(new Integer(n));
    }

    public NumberExpression(double d) {
        this(new Double(d));
    }

    public NumberExpression(float f) {
        this(new Float(f));
    }

    public NumberExpression(short s) {
        this(new Short(s));
    }

    public NumberExpression(long l) {
        this(new Long(l));
    }

    public Number getValue() {
        return this.m_Value;
    }
}

