/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax;

import oracle.hcs.syntax.Condition;
import oracle.hcs.syntax.SyntaxObject;
import oracle.hcs.syntax.SyntaxObjectVisitor;
import oracle.hcs.syntax.SyntaxPrintingContext;
import oracle.hcs.syntax.TypedExpression;
import oracle.hcs.syntax.ValidationContext;

public final class LikeCondition
extends Condition {
    public static final String LIKE = "LIKE";
    public static final String LIKEC = "LIKEC";
    public static final String LIKE2 = "LIKE2";
    public static final String LIKE4 = "LIKE4";
    static final String[] ALL_OPERATORS = new String[]{"LIKE", "LIKEC", "LIKE2", "LIKE4"};
    private String m_Operator;
    private TypedExpression m_LhsExpression;
    private TypedExpression m_RhsExpression;
    private TypedExpression m_EscapeExpression;
    private boolean m_Negated = false;

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.print(this.getLhsExpression());
        if (this.isNegated()) {
            syntaxPrintingContext.append(" NOT");
        }
        syntaxPrintingContext.append(" " + this.getOperator() + " ");
        syntaxPrintingContext.print(this.getRhsExpression());
        if (null != this.getEscapeExpression()) {
            syntaxPrintingContext.append(" ESCAPE ");
            syntaxPrintingContext.print(this.getEscapeExpression());
        }
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        this.m_LhsExpression = (TypedExpression)validationContext.validate(this.m_LhsExpression);
        this.m_RhsExpression = (TypedExpression)validationContext.validate(this.m_RhsExpression);
        if (null != this.m_EscapeExpression) {
            this.m_EscapeExpression = (TypedExpression)validationContext.validate(this.m_EscapeExpression);
        }
        validationContext.pop();
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        return this.getLhsExpression().isDefinitionComplete() && this.getRhsExpression().isDefinitionComplete() && (null == this.getEscapeExpression() || this.getEscapeExpression().isDefinitionComplete());
    }

    public LikeCondition(TypedExpression typedExpression, String string, TypedExpression typedExpression2, TypedExpression typedExpression3, boolean bl) {
        this.m_Operator = LikeCondition.validateEnum(string, ALL_OPERATORS);
        LikeCondition.validateValue(typedExpression);
        LikeCondition.validateValue(typedExpression2);
        this.m_Negated = bl;
        this.m_LhsExpression = typedExpression;
        this.m_RhsExpression = typedExpression2;
        this.m_EscapeExpression = typedExpression3;
        this.initialize();
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitLikeCondition(this, object);
    }

    public LikeCondition(TypedExpression typedExpression, String string, TypedExpression typedExpression2) {
        this(typedExpression, string, typedExpression2, null, false);
    }

    public boolean isNegated() {
        return this.m_Negated;
    }

    @Override
    public String getOperator() {
        return this.m_Operator;
    }

    public TypedExpression getEscapeExpression() {
        return this.m_EscapeExpression;
    }

    public TypedExpression getLhsExpression() {
        return this.m_LhsExpression;
    }

    public TypedExpression getRhsExpression() {
        return this.m_RhsExpression;
    }
}

