/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax;

import oracle.hcs.syntax.DataType;
import oracle.hcs.syntax.FunctionArgument;
import oracle.hcs.syntax.FunctionDescriptorArgument;
import oracle.hcs.syntax.IdentifierArgument;
import oracle.hcs.syntax.ValidationContext;

public final class FunctionDescriptorIdentifierArgument
extends FunctionDescriptorArgument {
    public static final int NO_EFFECT = 0;
    public static final int LOSSLESS_TYPE = 1;
    private String m_Name = null;
    private int m_ReturnTypeEffect = 0;

    FunctionDescriptorIdentifierArgument(String string, boolean bl, boolean bl2, int n) {
        super(bl, bl2);
        this.m_Name = string;
        this.m_ReturnTypeEffect = n;
    }

    @Override
    int validate(FunctionArgument[] functionArgumentArray, FunctionArgument[] functionArgumentArray2, ValidationContext validationContext, int n) {
        FunctionArgument functionArgument = null;
        if (functionArgumentArray.length > n) {
            functionArgument = functionArgumentArray[n];
        }
        if (functionArgument instanceof IdentifierArgument) {
            DataType dataType;
            IdentifierArgument identifierArgument = (IdentifierArgument)functionArgument;
            functionArgumentArray2[n] = functionArgument;
            if (this.getReturnTypeEffect() == 1 && null != (dataType = identifierArgument.getSQLDataType().getDataType())) {
                if (null == validationContext.getCurrentDataType()) {
                    validationContext.setCurrentDataType(dataType);
                } else {
                    validationContext.setCurrentDataType(validationContext.getCurrentDataType().getLosslessType(dataType));
                }
            }
            return n + 1;
        }
        return -1;
    }

    @Override
    public void toSyntaxInternal(StringBuffer stringBuffer) {
        stringBuffer.append(this.getArgumentName());
    }

    public String getArgumentName() {
        return this.m_Name;
    }

    public int getReturnTypeEffect() {
        return this.m_ReturnTypeEffect;
    }
}

