/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax;

import oracle.hcs.syntax.DataType;
import oracle.hcs.syntax.FunctionArgument;
import oracle.hcs.syntax.ValidationContext;

public abstract class FunctionDescriptorArgument {
    private boolean m_Optional;
    private boolean m_Repeated;
    private static final boolean DEBUG_MODE = false;

    FunctionDescriptorArgument(boolean bl, boolean bl2) {
        this.m_Optional = bl;
        this.m_Repeated = bl2;
    }

    static void printArguments(FunctionDescriptorArgument[] functionDescriptorArgumentArray, StringBuffer stringBuffer) {
        stringBuffer.append("(");
        for (int i = 0; i < functionDescriptorArgumentArray.length; ++i) {
            FunctionDescriptorArgument functionDescriptorArgument = functionDescriptorArgumentArray[i];
            if (i != 0) {
                if (functionDescriptorArgument.needsComma(true) && functionDescriptorArgumentArray[i - 1].needsComma(false)) {
                    stringBuffer.append(", ");
                } else {
                    stringBuffer.append(" ");
                }
            }
            functionDescriptorArgument.toSyntax(stringBuffer);
        }
        stringBuffer.append(")");
    }

    static int validateList(FunctionArgument[] functionArgumentArray, FunctionArgument[] functionArgumentArray2, FunctionDescriptorArgument[] functionDescriptorArgumentArray, ValidationContext validationContext, int n) {
        if (null == functionArgumentArray && null == functionDescriptorArgumentArray) {
            return 0;
        }
        if (null == functionArgumentArray && null != functionDescriptorArgumentArray) {
            return -1;
        }
        if (null != functionArgumentArray && null == functionDescriptorArgumentArray) {
            return -1;
        }
        int n2 = n;
        int n3 = 0;
        boolean bl = false;
        while (n3 < functionDescriptorArgumentArray.length) {
            FunctionDescriptorArgument functionDescriptorArgument = functionDescriptorArgumentArray[n3];
            DataType dataType = validationContext.getCurrentDataType();
            int n4 = functionDescriptorArgument.validate(functionArgumentArray, functionArgumentArray2, validationContext, n2);
            if (-1 == n4) {
                validationContext.setCurrentDataType(dataType);
                if (bl) {
                    ++n3;
                    bl = false;
                    continue;
                }
                if (functionDescriptorArgument.isOptional()) {
                    ++n3;
                    continue;
                }
                return -1;
            }
            n2 = n4;
            if (functionDescriptorArgument.isRepeated()) {
                bl = true;
                continue;
            }
            ++n3;
        }
        return n2;
    }

    abstract int validate(FunctionArgument[] var1, FunctionArgument[] var2, ValidationContext var3, int var4);

    public abstract void toSyntaxInternal(StringBuffer var1);

    boolean needsComma(boolean bl) {
        return true;
    }

    public final boolean isOptional() {
        return this.m_Optional;
    }

    public final boolean isRepeated() {
        return this.m_Repeated;
    }

    final void toSyntax(StringBuffer stringBuffer) {
        if (this.isOptional()) {
            stringBuffer.append("[");
        }
        this.toSyntaxInternal(stringBuffer);
        if (this.isOptional()) {
            stringBuffer.append("]");
        }
        if (this.isRepeated()) {
            stringBuffer.append("[, ");
            this.toSyntaxInternal(stringBuffer);
            stringBuffer.append("]...");
        }
    }
}

