/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax;

import java.util.List;
import oracle.hcs.syntax.Condition;
import oracle.hcs.syntax.Expression;
import oracle.hcs.syntax.FunctionArgument;
import oracle.hcs.syntax.FunctionDescriptor;
import oracle.hcs.syntax.FunctionDescriptorCatalog;
import oracle.hcs.syntax.SyntaxObject;
import oracle.hcs.syntax.SyntaxObjectVisitor;
import oracle.hcs.syntax.SyntaxPrintingContext;
import oracle.hcs.syntax.ValidationContext;

public final class FunctionCondition
extends Condition {
    private String m_FunctionName;
    private FunctionDescriptor m_FunctionDescriptor;
    private FunctionArgument[] m_Arguments;

    private FunctionArgument[] getArgumentsInternal() {
        return this.m_Arguments;
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.append(this.getFunctionName());
        Expression.printExpressions(this.getArgumentsInternal(), syntaxPrintingContext);
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        FunctionArgument[] functionArgumentArray = new FunctionArgument[this.getArgumentsInternal().length];
        this.m_FunctionDescriptor = FunctionDescriptorCatalog.getValidFunctionDescriptor(this.getFunctionName(), this.getArgumentsInternal(), functionArgumentArray, null, null, 128, "UnknownConditionFunction", validationContext);
        this.m_Arguments = functionArgumentArray;
        validationContext.pop();
        return this;
    }

    public FunctionCondition(String string, FunctionArgument[] functionArgumentArray) {
        FunctionCondition.validateValue(string);
        this.m_FunctionName = string;
        this.m_Arguments = FunctionCondition.getFunctionArgumentArrayClone(functionArgumentArray);
        this.initialize();
    }

    public FunctionCondition(String string, List<FunctionArgument> list) {
        this(string, FunctionCondition.getFunctionArgumentArrayClone(list));
    }

    public FunctionCondition(String string) {
        this(string, new FunctionArgument[0]);
    }

    public FunctionCondition(String string, FunctionArgument functionArgument) {
        this(string, new FunctionArgument[]{functionArgument});
    }

    public FunctionCondition(String string, FunctionArgument functionArgument, FunctionArgument functionArgument2) {
        this(string, new FunctionArgument[]{functionArgument, functionArgument2});
    }

    public FunctionCondition(String string, FunctionArgument functionArgument, FunctionArgument functionArgument2, FunctionArgument functionArgument3) {
        this(string, new FunctionArgument[]{functionArgument, functionArgument2, functionArgument3});
    }

    public FunctionCondition(String string, FunctionArgument functionArgument, FunctionArgument functionArgument2, FunctionArgument functionArgument3, FunctionArgument functionArgument4) {
        this(string, new FunctionArgument[]{functionArgument, functionArgument2, functionArgument3, functionArgument4});
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitFunctionCondition(this, object);
    }

    public FunctionArgument[] getArguments() {
        return (FunctionArgument[])this.getArgumentsInternal().clone();
    }

    public FunctionDescriptor getFunctionDescriptor() {
        return this.m_FunctionDescriptor;
    }

    public String getFunctionName() {
        return this.m_FunctionName;
    }
}

