/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax;

import java.util.ArrayList;
import java.util.List;
import oracle.hcs.syntax.BaseMetadataObjectReference;
import oracle.hcs.syntax.ColumnExpression;
import oracle.hcs.syntax.MetadataObjectReference;
import oracle.hcs.syntax.Query;
import oracle.hcs.syntax.SyntaxObject;
import oracle.hcs.syntax.SyntaxObjectVisitor;
import oracle.hcs.syntax.SyntaxPrintingContext;
import oracle.hcs.syntax.ValidationContext;
import oracle.hcs.syntax.metadata.BaseMetadataObject;
import oracle.hcs.syntax.metadata.mdm.MdmQuery;
import oracle.hcs.syntax.metadata.mdm.MdmQueryColumn;
import oracle.hcs.syntax.parser.ExpParser;

public final class BaseQuery
extends Query {
    private BaseMetadataObjectReference m_MdmQuery;
    private List<ColumnExpression> m_ColumnExpressions = new ArrayList<ColumnExpression>();

    private synchronized ColumnExpression getColumnExpression(MdmQueryColumn mdmQueryColumn) {
        for (ColumnExpression columnExpression : this.m_ColumnExpressions) {
            if (columnExpression.getQueryColumn() != mdmQueryColumn) continue;
            return columnExpression;
        }
        ColumnExpression columnExpression = new ColumnExpression(mdmQueryColumn, this);
        this.m_ColumnExpressions.add(columnExpression);
        return columnExpression;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        if (!this.m_MdmQuery.isDefinitionComplete()) {
            return false;
        }
        return super.checkIfDefinitionIsComplete();
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        this.m_MdmQuery.toSyntax(syntaxPrintingContext);
    }

    public BaseQuery(MdmQuery mdmQuery) {
        BaseQuery.validateValue(mdmQuery);
        this.m_MdmQuery = new MetadataObjectReference((BaseMetadataObject)((Object)mdmQuery), MdmQuery.class);
        this.initialize();
    }

    public BaseQuery(ExpParser expParser, BaseMetadataObjectReference baseMetadataObjectReference) {
        this.m_MdmQuery = baseMetadataObjectReference;
        this.initialize();
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        this.m_MdmQuery = (BaseMetadataObjectReference)validationContext.validate(this.m_MdmQuery);
        return this;
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitBaseQuery(this, object);
    }

    public MdmQuery getMdmQuery() {
        return (MdmQuery)((Object)this.m_MdmQuery.getBaseMetadataObject());
    }

    public String getMdmQueryID() {
        return this.m_MdmQuery.getIdentifier().toString();
    }

    @Override
    public String getName() {
        return this.m_MdmQuery.getIdentifier().toString();
    }

    @Override
    public synchronized List<ColumnExpression> getColumnExpressions() {
        List<MdmQueryColumn> list = this.getMdmQuery().getQueryColumns();
        ArrayList<ColumnExpression> arrayList = new ArrayList<ColumnExpression>();
        for (MdmQueryColumn mdmQueryColumn : list) {
            arrayList.add(this.getColumnExpression(mdmQueryColumn));
        }
        return arrayList;
    }

    @Override
    public ColumnExpression getColumnExpression(String string) {
        MdmQueryColumn mdmQueryColumn = this.getMdmQuery().getQueryColumn(string);
        if (null == mdmQueryColumn) {
            return null;
        }
        return this.getColumnExpression(mdmQueryColumn);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BaseQuery)) {
            return false;
        }
        BaseQuery baseQuery = (BaseQuery)object;
        return this.getMdmQuery() == baseQuery.getMdmQuery();
    }
}

